/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.wizard;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.ReportWriter;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserChoicesWizardTemplate {
    private String name = "";
    private String templateFile = "";
    private List groupExpressions = new ArrayList();
    private List displayFields = new ArrayList();
    private String query = "";
    private String query_language = "";
    private String iRDatasourceName = "";
    private boolean saveFieldDescriptions = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getGroupExpressions() {
        return this.groupExpressions;
    }

    public void setGroupExpressions(List groupExpressions) {
        this.groupExpressions = groupExpressions;
    }

    public List getDisplayFields() {
        return this.displayFields;
    }

    public void setDisplayFields(List displayFields) {
        this.displayFields = displayFields;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getIRDatasourceName() {
        return this.iRDatasourceName;
    }

    public void setIRDatasourceName(String iRDatasourceName) {
        this.iRDatasourceName = iRDatasourceName;
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return "Unnamed template";
    }

    public static List loadWizardTemplates() {
        ArrayList<UserChoicesWizardTemplate> templates = new ArrayList<UserChoicesWizardTemplate>();
        StringBuilder stringBuilder = new StringBuilder();
        MainFrame.getMainInstance();
        String locationFileName = stringBuilder.append(MainFrame.IREPORT_USER_HOME_DIR).append(File.separator).append("wizardUserTemplates.xml").toString();
        File source = new File(locationFileName);
        if (!source.exists()) {
            System.out.println("locationFileName does not exisit");
            return templates;
        }
        DOMParser parser = new DOMParser();
        try {
            parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    InputSource inputSource = null;
                    if (systemId != null) {
                        String dtd = null;
                        if (!systemId.equals("http://ireport.sourceforge.net/dtds/userWizardChoicesTemplate.dtd")) {
                            return new InputSource(systemId);
                        }
                        dtd = "it/businesslogic/ireport/dtds/userWizardChoicesTemplate.dtd";
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        InputStream is = classLoader.getResourceAsStream(dtd);
                        if (is != null) {
                            inputSource = new InputSource(is);
                        }
                    }
                    return inputSource;
                }
            });
            FileInputStream input_source = null;
            if (source instanceof File) {
                input_source = new FileInputStream(source);
            }
            parser.parse(new InputSource(input_source));
            Document document = parser.getDocument();
            Element node = document.getDocumentElement();
            NodeList list = XPathAPI.selectNodeList((Node)node, (String)"/userWizardChoicesTemplateSet/userWizardChoicesTemplate");
            Node childnode = null;
            for (int n = 0; n < list.getLength(); ++n) {
                UserChoicesWizardTemplate template = new UserChoicesWizardTemplate();
                childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"@name");
                if (childnode != null) {
                    template.setName(childnode.getNodeValue());
                }
                if ((childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"@saveFieldDescriptions")) != null) {
                    template.setSaveFieldDescriptions(childnode.getNodeValue().equals("true"));
                }
                if ((childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"templateFile/text()")) != null) {
                    template.setTemplateFile(childnode.getNodeValue());
                }
                NodeList listExpressions = null;
                listExpressions = XPathAPI.selectNodeList((Node)list.item(n), (String)"groupExpression");
                for (int n2 = 0; n2 < listExpressions.getLength(); ++n2) {
                    childnode = XPathAPI.selectSingleNode((Node)listExpressions.item(n2), (String)"text()");
                    if (childnode == null) continue;
                    template.getGroupExpressions().add(childnode.getNodeValue());
                }
                NodeList listFields = XPathAPI.selectNodeList((Node)list.item(n), (String)"displayField");
                for (int n2 = 0; n2 < listFields.getLength(); ++n2) {
                    String fname = "";
                    String fclass = "";
                    String fdesc = "";
                    childnode = XPathAPI.selectSingleNode((Node)listFields.item(n2), (String)"@name");
                    if (childnode != null) {
                        fname = childnode.getNodeValue();
                    }
                    if ((childnode = XPathAPI.selectSingleNode((Node)listFields.item(n2), (String)"@class")) != null) {
                        fclass = childnode.getNodeValue();
                    }
                    if ((childnode = XPathAPI.selectSingleNode((Node)listFields.item(n2), (String)"fieldDescription/text()")) != null) {
                        fdesc = childnode.getNodeValue();
                    }
                    JRField jrField = new JRField(fname, fclass);
                    jrField.setDescription(fdesc);
                    template.getDisplayFields().add(jrField);
                }
                childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"query/text()");
                if (childnode != null) {
                    template.setQuery(childnode.getNodeValue());
                }
                if ((childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"query/@language")) != null) {
                    template.setQuery_language(childnode.getNodeValue());
                }
                if ((childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"iRDatasourceName/text()")) != null) {
                    template.setIRDatasourceName(childnode.getNodeValue());
                }
                templates.add(template);
            }
        }
        catch (SAXException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void storeWizardTemplates(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        MainFrame.getMainInstance();
        String locationFileName = stringBuilder.append(MainFrame.IREPORT_USER_HOME_DIR).append(File.separator).append("wizardUserTemplates.xml").toString();
        File destination = new File(locationFileName);
        StringBuffer output = new StringBuffer();
        output.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.append("<userWizardChoicesTemplateSet>\n");
        for (int i = 0; i < list.size(); ++i) {
            int k;
            UserChoicesWizardTemplate template = (UserChoicesWizardTemplate)list.get(i);
            output.append("\t<userWizardChoicesTemplate name=\"" + Misc.xmlEscape(template.getName()) + "\" saveFieldDescriptions=\"" + template.isSaveFieldDescriptions() + "\">\n");
            output.append("\t\t<templateFile>" + ReportWriter.getCDATAString(template.getTemplateFile(), 2) + "</templateFile>\n");
            for (k = 0; k < template.getGroupExpressions().size(); ++k) {
                output.append("\t\t<groupExpression>" + ReportWriter.getCDATAString(template.getGroupExpressions().get(k) + "", 2) + "</groupExpression>\n");
            }
            for (k = 0; k < template.getDisplayFields().size(); ++k) {
                JRField field = (JRField)template.getDisplayFields().get(k);
                output.append("\t\t<displayField name=\"" + Misc.xmlEscape(field.getName()) + "\" class=\"" + Misc.xmlEscape(field.getClassType()) + "\">\n");
                output.append("\t\t<fieldDescription>" + ReportWriter.getCDATAString(field.getDescription(), 2) + "</fieldDescription>\n");
                output.append("\t\t</displayField>\n");
            }
            if (template.getQuery() != null && template.getQuery().length() > 0) {
                output.append("\t\t<query language=\"" + Misc.xmlEscape(template.getQuery_language()) + "\">" + ReportWriter.getCDATAString(template.getQuery(), 2) + "</query>\n");
            }
            if (template.getIRDatasourceName() != null && template.getIRDatasourceName().length() > 0) {
                output.append("\t\t<iRDatasourceName>" + ReportWriter.getCDATAString(template.getIRDatasourceName(), 2) + "</iRDatasourceName>\n");
            }
            output.append("\t</userWizardChoicesTemplate>\n");
        }
        output.append("</userWizardChoicesTemplateSet>\n");
        FileWriter fos = null;
        fos = new FileWriter(destination);
        fos.write(output.toString());
        Object var9_10 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                ex.printStackTrace();
                Object var9_11 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(String templateFile) {
        this.templateFile = templateFile;
    }

    public String getQuery_language() {
        return this.query_language;
    }

    public void setQuery_language(String query_language) {
        this.query_language = query_language;
    }

    public boolean isSaveFieldDescriptions() {
        return this.saveFieldDescriptions;
    }

    public void setSaveFieldDescriptions(boolean saveFieldDescriptions) {
        this.saveFieldDescriptions = saveFieldDescriptions;
    }
}

