/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.util;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ConditionedStyle;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.ExpressionEditor;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.xerces.parsers.DOMParser;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.defaults.DefaultDockingStrategy;
import org.flexdock.view.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Misc {
    public static final String[] special_chars = new String[]{"&", "&amp;", "\"", "&quot;", "'", "&apos;", "<", "&lt;", ">", "&gt;"};
    public static HashMap opTimes = new HashMap();
    public static final KeyListener ARABIC_KEY_LISTENER = new KeyListener(){
        boolean pressedRightShift = false;
        boolean pressedRightCtl = false;

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (this.pressedRightShift && this.pressedRightCtl) {
                return;
            }
            if (e.getKeyCode() == 16 && e.getKeyLocation() == 3) {
                this.pressedRightShift = true;
            } else if (e.getKeyCode() == 17 && e.getKeyLocation() == 3) {
                this.pressedRightCtl = true;
            }
            if (this.pressedRightShift && this.pressedRightCtl && e.getSource() instanceof JComponent) {
                ((JComponent)e.getSource()).setComponentOrientation(((JComponent)e.getSource()).getComponentOrientation().equals(ComponentOrientation.RIGHT_TO_LEFT) ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 16 && e.getKeyLocation() == 3) {
                this.pressedRightShift = false;
            }
            if (e.getKeyCode() == 17 && e.getKeyLocation() == 3) {
                this.pressedRightCtl = false;
            }
        }
    };

    public static String xmlEscape(String text) {
        if (text == null) {
            return "";
        }
        int i = 0;
        String tmp = "";
        for (i = 0; i < special_chars.length; i += 2) {
            text = Misc.string_replace(special_chars[i + 1], special_chars[i], text);
        }
        return text;
    }

    public static Image loadImageFromResources(String filename) {
        try {
            return new ImageIcon(Misc.class.getResource("/" + filename)).getImage();
        }
        catch (Exception ex) {
            System.out.println("Exception loading resource: " + filename);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] getBytesFromInputStream(InputStream in, int length) throws IOException {
        DataInputStream din = new DataInputStream(in);
        byte[] bytecodes = new byte[length];
        try {
            din.readFully(bytecodes);
            Object var5_4 = null;
            if (din == null) return bytecodes;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (din == null) throw throwable;
            din.close();
            throw throwable;
        }
        din.close();
        return bytecodes;
    }

    public static BufferedImage loadBufferedImageFromResources(Component c, String filename) {
        try {
            Misc m = new Misc();
            Image img = Misc.loadImageFromResources(filename);
            MediaTracker mt = new MediaTracker(c);
            mt.addImage(img, 0);
            mt.waitForID(0);
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics gg = bi.getGraphics();
            gg.drawImage(img, 0, 0, null);
            gg.dispose();
            return bi;
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            return null;
        }
    }

    public static void updateComboBox(JComboBox comboBox, Vector newItems) {
        Misc.updateComboBox(comboBox, newItems, false);
    }

    public static void updateComboBox(JComboBox comboBox, Vector newItems, boolean addNullEntry) {
        Object itemSelected = null;
        if (comboBox.getSelectedIndex() >= 0) {
            itemSelected = comboBox.getSelectedItem();
        }
        Vector items = new Vector(newItems.size(), 1);
        boolean selected = false;
        boolean foundNullItem = false;
        Enumeration e = newItems.elements();
        int selectedIndex = -1;
        int currentelement = 0;
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            items.add(item);
            if (item == itemSelected) {
                selectedIndex = currentelement;
            }
            if (item.equals("")) {
                foundNullItem = true;
            }
            ++currentelement;
        }
        if (addNullEntry) {
            if (!foundNullItem) {
                items.add(0, "");
            }
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
        }
        comboBox.setModel(new DefaultComboBoxModel(items));
        comboBox.setSelectedIndex(selectedIndex);
    }

    public static void updateStringComboBox(JComboBox comboBox, Vector newItems, boolean addNullEntry) {
        String itemSelected = null;
        if (comboBox.getSelectedIndex() >= 0) {
            itemSelected = comboBox.getSelectedItem() + "";
        }
        Vector<String> items = new Vector<String>(newItems.size(), 1);
        boolean selected = false;
        boolean foundNullItem = false;
        Enumeration e = newItems.elements();
        int selectedIndex = -1;
        int currentelement = 0;
        while (e.hasMoreElements()) {
            String item = "" + e.nextElement();
            items.add(item);
            if (item.equals(itemSelected)) {
                selectedIndex = currentelement;
            }
            if (item.equals("")) {
                foundNullItem = true;
            }
            ++currentelement;
        }
        if (addNullEntry) {
            if (!foundNullItem) {
                items.add(0, "");
            }
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
        }
        comboBox.setModel(new DefaultComboBoxModel(items));
        comboBox.setSelectedIndex(selectedIndex);
    }

    public static String nvl(Object obj, String def) {
        return obj == null ? def : obj.toString();
    }

    public static void centerFrame(Component c) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        c.setLocation((int)((tk.getScreenSize().getWidth() - (double)c.getWidth()) / 2.0), (int)((tk.getScreenSize().getHeight() - (double)c.getHeight()) / 2.0));
    }

    public static String string_replace(String s1, String s2, String s3) {
        String string = "";
        string = "";
        if (s2 == null || s3 == null || s2.length() == 0) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = string + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        string = string + s3.substring(pos_i);
        return string;
    }

    public static Image loadImageFromFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Image img = tk.createImage(path);
            try {
                MediaTracker mt = new MediaTracker(new JPanel());
                mt.addImage(img, 0);
                mt.waitForID(0);
            }
            catch (Exception ex) {
                return null;
            }
            return img;
        }
        return null;
    }

    public static String treatNewLineChars(String source) {
        String result = source;
        if (source != null && source.length() > 0) {
            StringBuffer sbuffer = new StringBuffer(source);
            int offset = source.length() - 1;
            int pos = source.lastIndexOf("\n\n", offset);
            while (pos >= 0 && offset > 0) {
                sbuffer = sbuffer.insert(pos + 1, " ");
                offset = pos - 1;
                pos = source.lastIndexOf("\n\n", offset);
            }
            if (sbuffer.charAt(sbuffer.length() - 1) == '\n') {
                sbuffer.append(' ');
            }
            if (sbuffer.charAt(0) == '\n') {
                sbuffer.insert(0, ' ');
            }
            result = sbuffer.toString();
        }
        result = Misc.replaceTabWithBlank(result);
        return result;
    }

    public static String replaceTabWithBlank(String source) {
        String result = source;
        if (source != null && source.length() > 0) {
            StringBuffer sbuffer = new StringBuffer(source);
            int offset = 0;
            int pos = source.indexOf("\t", offset);
            while (pos >= 0) {
                sbuffer.setCharAt(pos, ' ');
                offset = pos + 1;
                pos = source.indexOf("\t", offset);
            }
            result = sbuffer.toString();
        }
        return result;
    }

    public static String toHTML(String s) {
        s = Misc.string_replace("&gt;", ">", s);
        s = Misc.string_replace("&lt;", "<", s);
        s = Misc.string_replace("&nbsp;", " ", s);
        s = Misc.string_replace("&nbsp;&nbsp;&nbsp;&nbsp;", "\t", s);
        s = Misc.string_replace("<br>", "\n", s);
        return s;
    }

    public static String getShortFileName(String filename) {
        File f;
        if (filename.length() > 50 && Misc.nvl((f = new File(filename)).getParentFile(), "").length() > 10) {
            String dir = f.getParentFile().getPath() + File.separatorChar;
            String shortDir = dir.substring(0, dir.indexOf(File.separatorChar) + 1);
            if ((dir = dir.substring(dir.indexOf(File.separatorChar) + 1)).indexOf(File.separatorChar) > 0) {
                shortDir = shortDir + dir.substring(0, dir.indexOf(File.separatorChar) + 1);
            }
            return shortDir + "..." + File.separatorChar + f.getName();
        }
        return filename;
    }

    public static String getJdbcTypeClass(ResultSetMetaData rsmd, int t) {
        String cls = "java.lang.Object";
        try {
            cls = rsmd.getColumnClassName(t);
            cls = Misc.getJRFieldType(cls);
        }
        catch (Exception ex) {
            try {
                int type = rsmd.getColumnType(t);
                switch (type) {
                    case -7: 
                    case -6: {
                        cls = "java.lang.Byte";
                        break;
                    }
                    case 5: {
                        cls = "java.lang.Short";
                        break;
                    }
                    case 4: {
                        cls = "java.lang.Integer";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        cls = "java.lang.Double";
                        break;
                    }
                    case 1: 
                    case 12: {
                        cls = "java.lang.String";
                        break;
                    }
                    case -5: {
                        cls = "java.lang.Long";
                        break;
                    }
                    case 91: {
                        cls = "java.util.Date";
                        break;
                    }
                    case 92: {
                        cls = "java.sql.Time";
                        break;
                    }
                    case 93: {
                        cls = "java.sql.Timestamp";
                    }
                }
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        return cls;
    }

    public static String getJRFieldType(String type) {
        if (type == null) {
            return "java.lang.Object";
        }
        if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.equals("java.lang.Byte") || type.equals("byte")) {
            return "java.lang.Byte";
        }
        if (type.equals("java.lang.Integer") || type.equals("int")) {
            return "java.lang.Integer";
        }
        if (type.equals("java.lang.Long") || type.equals("long")) {
            return "java.lang.Long";
        }
        if (type.equals("java.lang.Double") || type.equals("double")) {
            return "java.lang.Double";
        }
        if (type.equals("java.lang.Float") || type.equals("float")) {
            return "java.lang.Float";
        }
        if (type.equals("java.lang.Short") || type.equals("short")) {
            return "java.lang.Short";
        }
        if (type.startsWith("[")) {
            return "java.lang.Object";
        }
        return type;
    }

    public static long getLastWriteTime(String filename) {
        try {
            File f = new File(filename);
            if (f.exists()) {
                return f.lastModified();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public static Frame frameFromComponent(Component parent) {
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        return f;
    }

    public static List getAvailablePLAF() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("System");
        l.add("TinyLAF");
        l.add("TonicLAF");
        l.add("JGoodiesLAF-PlasticXP");
        l.add("JGoodiesLAF-Plastic");
        l.add("JGoodiesLAF-Plastic3D");
        l.add("JGoodiesLAF-ExtWindows");
        l.add("JGoodiesLAF-ExtWindows");
        UIManager.LookAndFeelInfo[] lfinfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lfinfo.length; ++i) {
            l.add(lfinfo[i].getName());
        }
        return l;
    }

    public static void setPLAF(String s) {
        block16: {
            try {
                if (s.equals("TinyLAF")) {
                    UIManager.setLookAndFeel("de.muntjak.tinylookandfeel.TinyLookAndFeel");
                    break block16;
                }
                if (s.equals("TonicLAF")) {
                    UIManager.setLookAndFeel("com.digitprop.tonic.TonicLookAndFeel");
                    break block16;
                }
                if (s.equals("JGoodiesLAF-PlasticXP")) {
                    UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                    break block16;
                }
                if (s.equals("JGoodiesLAF-Plastic")) {
                    UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticLookAndFeel");
                    break block16;
                }
                if (s.equals("JGoodiesLAF-Plastic3D")) {
                    UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
                    break block16;
                }
                if (s.equals("JGoodiesLAF-ExtWindows")) {
                    UIManager.setLookAndFeel("com.jgoodies.looks.windows.WindowsLookAndFeel");
                    break block16;
                }
                if (s.equals("System")) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    UIDefaults uiDefaults = UIManager.getDefaults();
                    Object obj = uiDefaults.get("Panel.background");
                    if (obj instanceof ColorUIResource) {
                        ColorUIResource cr = (ColorUIResource)obj;
                        uiDefaults.put("Desktop.background", new ColorUIResource(cr.darker()));
                    }
                    break block16;
                }
                UIManager.LookAndFeelInfo[] lfinfo = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < lfinfo.length; ++i) {
                    if (!lfinfo[i].getName().equalsIgnoreCase(s)) continue;
                    UIManager.setLookAndFeel(lfinfo[i].getClassName());
                    if (s.equals("Metal") && MainFrame.getMainInstance().getProperties().getProperty("overrideDefaultFont", "true").equals("true")) {
                        String fontFamily = MainFrame.getMainInstance().getProperties().getProperty("overrideDefaultFontName", I18n.getString("defaultFont", "Tahoma"));
                        int fontSize = 11;
                        try {
                            fontSize = Integer.parseInt(MainFrame.getMainInstance().getProperties().getProperty("overrideDefaultFontSize", "11"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        String sNum = MainFrame.getMainInstance().getProperties().getProperty("overrideDefaultFontAttrs", "0");
                        if (sNum == null || !sNum.equals("1")) {
                            sNum = "0";
                        }
                        int fontAttrs = Integer.parseInt(sNum);
                        FontUIResource f = new FontUIResource(fontFamily, fontAttrs, fontSize);
                        Enumeration keys = UIManager.getDefaults().keys();
                        while (keys.hasMoreElements()) {
                            Object key = keys.nextElement();
                            Object value = UIManager.get(key);
                            if (!(value instanceof FontUIResource)) continue;
                            UIManager.put(key, f);
                        }
                    }
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getClassPath() {
        String cp = System.getProperty("java.class.path");
        if (MainFrame.getMainInstance() != null) {
            Vector cp_v = MainFrame.getMainInstance().getClasspath();
            for (int i = 0; i < cp_v.size(); ++i) {
                cp = cp + File.pathSeparator + cp_v.elementAt(i);
            }
        }
        return cp;
    }

    public static Set getResoucesInPackage(String packageName) throws IOException {
        String localPackageName = packageName.endsWith("/") ? packageName : packageName + '/';
        ClassLoader cl = Misc.class.getClassLoader();
        if (MainFrame.getMainInstance() != null) {
            cl = MainFrame.getMainInstance().getReportClassLoader();
        }
        Enumeration<URL> dirEnum = cl.getResources(localPackageName);
        HashSet<String> names = new HashSet<String>();
        while (dirEnum.hasMoreElements()) {
            URL resUrl = dirEnum.nextElement();
            if (resUrl.getProtocol().equals("file")) {
                try {
                    File dir = new File(resUrl.getFile());
                    File[] files = dir.listFiles();
                    if (files == null) continue;
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory()) continue;
                        names.add(localPackageName + file.getName());
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            if (!resUrl.getProtocol().equals("jar")) continue;
            JarURLConnection jconn = (JarURLConnection)resUrl.openConnection();
            JarFile jfile = jconn.getJarFile();
            Enumeration<JarEntry> entryEnum = jfile.entries();
            while (entryEnum.hasMoreElements()) {
                String parentDirName;
                JarEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                if (entryName.equals(localPackageName) || !(parentDirName = entryName.substring(0, entryName.lastIndexOf(47) + 1)).equals(localPackageName)) continue;
                names.add(entryName);
            }
        }
        return names;
    }

    public static String changeFileExtension(String filename, String newExtension) {
        if (!newExtension.startsWith(".")) {
            newExtension = "." + newExtension;
        }
        if (filename == null || filename.length() == 0) {
            return newExtension;
        }
        int index = filename.lastIndexOf(".");
        if (index >= 0) {
            filename = filename.substring(0, index);
        }
        filename = filename + newExtension;
        return filename;
    }

    public static Locale getLocaleFromString(String localeName) {
        return Misc.getLocaleFromString(localeName, Locale.getDefault());
    }

    public static Locale getLocaleFromString(String localeName, Locale defaultLocale) {
        String language = "";
        String country = "";
        String variant = "";
        Locale locale = defaultLocale;
        if (localeName == null || localeName.length() == 0) {
            return locale;
        }
        if (localeName.startsWith("_")) {
            localeName = localeName.substring(1);
        }
        if (localeName.indexOf("_") > 0) {
            language = localeName.substring(0, localeName.indexOf("_"));
            if ((localeName = localeName.substring(localeName.indexOf("_") + 1)).indexOf("_") > 0) {
                country = localeName.substring(0, localeName.indexOf("_"));
                if ((localeName = localeName.substring(localeName.indexOf("_") + 1)).indexOf("_") > 0) {
                    variant = localeName.substring(0, localeName.indexOf("_"));
                    localeName = localeName.substring(localeName.indexOf("_") + 1);
                } else {
                    variant = localeName;
                }
            } else {
                country = localeName;
            }
        } else {
            language = localeName;
        }
        locale = new Locale(language, country, variant);
        return locale;
    }

    public static void setComboboxSelectedTagValue(JComboBox comboBox, String itemValue) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object val = comboBox.getItemAt(i);
            if (!(val instanceof Tag) || !((Tag)val).getValue().equals(itemValue)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public static Connection getConnection(String name) {
        Vector v = MainFrame.getMainInstance().getConnections();
        for (int i = 0; i < v.size(); ++i) {
            IReportConnection irc = (IReportConnection)v.get(i);
            if (!irc.getName().equals(name)) continue;
            return irc.getConnection();
        }
        return null;
    }

    public static JRDataSource getJRDataSource(String name) {
        Vector v = MainFrame.getMainInstance().getConnections();
        for (int i = 0; i < v.size(); ++i) {
            IReportConnection irc = (IReportConnection)v.get(i);
            if (!irc.getName().equals(name)) continue;
            return irc.getJRDataSource();
        }
        return null;
    }

    public static Vector loadStyleLibrary(String fileName) {
        Vector v = new Vector();
        try {
            File f = new File(fileName);
            InputStream fis = null;
            if (!f.exists()) {
                fis = Misc.class.getClassLoader().getResourceAsStream("it/businesslogic/ireport/res/defaultStyleLibrary.xml");
                fileName = "" + Misc.class.getClassLoader().getResource("it/businesslogic/ireport/res/defaultStyleLibrary.xml");
            } else {
                fis = new FileInputStream(f);
                fileName = "file:///" + fileName;
            }
            v.addAll(Misc.loadStyleLibrary(fis, fileName));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return v;
    }

    public static Vector loadStyleLibrary(InputStream is, String filename) {
        Vector<Style> v = new Vector<Style>();
        try {
            DOMParser parser = new DOMParser();
            InputSource input_sss = new InputSource(is);
            parser.parse(input_sss);
            Document document = parser.getDocument();
            Element node = document.getDocumentElement();
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                Node styleNode = list_child.item(ck);
                if (styleNode.getNodeName() == null || !styleNode.getNodeName().equals("style")) continue;
                Style s = Misc.readStyle(styleNode, null);
                v.add(s);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return v;
    }

    public static Style readStyle(Node styleNode, ConditionedStyle cStyle) {
        Style style = new Style();
        if (cStyle != null) {
            style = cStyle;
        }
        NamedNodeMap nnm = styleNode.getAttributes();
        for (int i = 0; i < Style.JRXMLStyleAttributes.length; ++i) {
            if (nnm.getNamedItem(Style.JRXMLStyleAttributes[i]) == null) continue;
            style.getAttributes().put(Style.JRXMLStyleAttributes[i], nnm.getNamedItem(Style.JRXMLStyleAttributes[i]).getNodeValue());
        }
        NodeList children = styleNode.getChildNodes();
        if (children != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("conditionalStyle")) continue;
                ConditionedStyle childStyle = Misc.readConditionalStyle(nodeChild);
                style.getConditionedStyles().add(childStyle);
            }
        }
        return style;
    }

    private static ConditionedStyle readConditionalStyle(Node styleNode) {
        ConditionedStyle style = new ConditionedStyle();
        NodeList children = styleNode.getChildNodes();
        if (children != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("conditionExpression")) {
                    style.setCondition(Report.readPCDATA(nodeChild));
                    continue;
                }
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("style")) continue;
                style = (ConditionedStyle)Misc.readStyle(nodeChild, style);
            }
        }
        return style;
    }

    public static void saveStyleLibrary(String filename, Vector styles) {
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF8"));
            pw.print("<?xml version=\"1.0\"?>");
            pw.println("<!-- iReport styles library -->");
            pw.println("<styles>");
            Misc.writeXMLStyles(styles, pw, "\t");
            pw.println("</styles>");
            pw.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.misc.errorSavingStyles", "Error saving styles library: {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
        }
    }

    private static void writeXMLStyles(Vector styles, PrintWriter pw, String tabs) {
        Enumeration e = styles.elements();
        if (styles.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            Style style = (Style)e.nextElement();
            String tabs2 = tabs;
            if (style instanceof ConditionedStyle) {
                pw.println(tabs2 + "<conditionalStyle>");
                tabs = tabs + "\t";
                pw.print(tabs + "<conditionExpression");
                pw.println(">" + Report.getCDATAString(((ConditionedStyle)style).getCondition(), tabs2.length() + 1) + "</conditionExpression>");
            }
            pw.println(tabs + "<style ");
            for (int i = 0; i < Style.JRXMLStyleAttributes.length; ++i) {
                if (!style.getAttributes().containsKey(Style.JRXMLStyleAttributes[i]) || style.getAttributes().get(Style.JRXMLStyleAttributes[i]) == null) continue;
                Object obj = style.getAttributes().get(Style.JRXMLStyleAttributes[i]);
                String value = "" + obj;
                if (obj instanceof Color) {
                    value = Report.writeEncodedColor((Color)obj);
                }
                if (Style.JRXMLStyleAttributes[i].toLowerCase().endsWith("color") && value.startsWith("[")) {
                    try {
                        value = Report.writeEncodedColor(ColorSelectorPanel.parseColorString(value));
                    }
                    catch (Exception ex) {
                        value = "black";
                    }
                }
                if (Style.JRXMLStyleAttributes[i].equals("style") && (value == null || value.trim().length() == 0)) continue;
                pw.println(tabs + "\t" + Style.JRXMLStyleAttributes[i] + "=\"" + value + "\"");
            }
            if (style.getConditionedStyles().size() == 0) {
                pw.println(tabs + "/>");
            } else {
                pw.println(tabs + ">");
                Misc.writeXMLStyles(style.getConditionedStyles(), pw, tabs + "\t");
                pw.println(tabs + "</style>");
            }
            if (!(style instanceof ConditionedStyle)) continue;
            pw.println(tabs2 + "</conditionalStyle>");
        }
    }

    public static boolean saveSQLQuery(String query) {
        return Misc.saveSQLQuery(query, MainFrame.getMainInstance());
    }

    public static boolean saveSQLQuery(String query, Component c) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".sql") || filename.endsWith(".txt") || file.isDirectory();
            }

            public String getDescription() {
                return "SQL query (*.sql, *.txt)";
            }
        });
        if (jfc.showSaveDialog(c) == 0) {
            try {
                String fileName = jfc.getSelectedFile().getName();
                if (fileName.indexOf(".") < 0) {
                    fileName = fileName + ".sql";
                }
                File f = new File(jfc.getSelectedFile().getParent(), fileName);
                FileWriter fw = new FileWriter(f);
                fw.write(query);
                fw.close();
                return true;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(c, "Error saving the query: " + ex.getMessage(), I18n.getString("message.title.error", "Error"), 0);
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static String loadSQLQuery() {
        return Misc.loadSQLQuery(MainFrame.getMainInstance());
    }

    public static String loadSQLQuery(Component c) {
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".sql") || filename.endsWith(".txt") || file.isDirectory();
            }

            public String getDescription() {
                return "SQL query (*.sql, *.txt)";
            }
        });
        if (jfc.showOpenDialog(c) == 0) {
            try {
                FileReader fr = new FileReader(jfc.getSelectedFile());
                StringBuffer sb = new StringBuffer();
                char[] cbuf = new char[1024];
                int i = fr.read(cbuf);
                while (i > 0) {
                    sb.append(cbuf, 0, i);
                    i = fr.read(cbuf);
                }
                fr.close();
                return sb.toString();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(c, "Error loading the query: " + ex.getMessage(), I18n.getString("message.title.error", "Error"), 0);
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean saveExpressionsList(Vector v, String xmlFile) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(xmlFile));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<!-- iReport 2 expressions list - " + new Date() + " -->");
            pw.println("<!DOCTYPE iReportExpressionsList PUBLIC \"-//iReport/DTD iReport Configuration//EN\" \"http://ireport.sourceforge.net/dtds/iReportExpressionsList.dtd\">");
            pw.println("<iReportExpressionsList>");
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                String exp = (String)e.nextElement();
                pw.println("\t<expression><![CDATA[" + exp + "]]></expression>");
            }
            pw.println("</iReportExpressionsList>");
            pw.close();
        }
        catch (Exception ex) {
            try {
                MainFrame.getMainInstance().logOnConsole("Error saving iReport file: " + xmlFile + "\n" + ex.getMessage() + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        try {
            MainFrame.getMainInstance().logOnConsole("iReport file " + xmlFile + " successfully updated!\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static Vector loadExpressionsList(String xmlFile) {
        File file = null;
        Vector<String> v = new Vector<String>();
        try {
            file = new File(xmlFile);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (file == null || !file.exists() || file.isDirectory()) {
            return ExpressionEditor.defaultExpressions;
        }
        DOMParser parser = new DOMParser();
        try {
            parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    InputSource inputSource = null;
                    if (systemId != null) {
                        InputStream is;
                        String dtd = null;
                        if (!systemId.equals("http://ireport.sourceforge.net/dtds/iReportExpressionsList.dtd")) {
                            return new InputSource(systemId);
                        }
                        dtd = "it/businesslogic/ireport/dtds/iReportExpressionsList.dtd";
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        URL url = null;
                        if (classLoader != null) {
                            url = classLoader.getResource(dtd);
                        }
                        if (url == null) {
                            classLoader = this.getClass().getClassLoader();
                        }
                        if ((is = classLoader.getResourceAsStream(dtd)) != null) {
                            InputStreamReader isr = new InputStreamReader(is);
                            inputSource = new InputSource(isr);
                        }
                    }
                    return inputSource;
                }
            });
            parser.parse(new File(xmlFile).toURI().toString());
            Document document = parser.getDocument();
            System.out.println("FL3: " + document.getDocumentElement());
            Element fileList = document.getDocumentElement();
            if (fileList == null) {
                return v;
            }
            NodeList list = fileList.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                String expression;
                Node child = list.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("expression") || (expression = Report.readPCDATA(child)) == null || expression.trim().length() <= 0) continue;
                v.addElement(expression);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return v;
    }

    public static boolean dockAt(Dockable toDock, String side, int index) {
        View rootDockable;
        View dockable = rootDockable = MainFrame.getMainInstance().getDesktopView();
        String directionV = null;
        String directionH = null;
        String directionIndex = null;
        if (side.equals("NORTH")) {
            directionV = "NORTH";
            directionH = "WEST";
            directionIndex = "EAST";
        }
        if (side.equals("WEST")) {
            directionV = "NORTH";
            directionH = "WEST";
            directionIndex = "SOUTH";
        }
        if (side.equals("EAST")) {
            directionV = "NORTH";
            directionH = "EAST";
            directionIndex = "SOUTH";
        }
        if (side.equals("SOUTH")) {
            directionV = "SOUTH";
            directionH = "WEST";
            directionIndex = "EAST";
        }
        String counterDirectionIndex = null;
        if (directionIndex.equals("NORTH")) {
            counterDirectionIndex = "SOUTH";
        }
        if (directionIndex.equals("SOUTH")) {
            counterDirectionIndex = "NORTH";
        }
        if (directionIndex.equals("WEST")) {
            counterDirectionIndex = "EAST";
        }
        if (directionIndex.equals("EAST")) {
            counterDirectionIndex = "WEST";
        }
        try {
            if (rootDockable.getSibling(side) != null) {
                dockable = rootDockable.getSibling(side);
                while (DefaultDockingStrategy.getSibling((Dockable)dockable, (String)directionV) != null || DefaultDockingStrategy.getSibling((Dockable)dockable, (String)directionH) != null) {
                    Dockable tmp = DefaultDockingStrategy.getSibling((Dockable)dockable, (String)directionV);
                    dockable = tmp != null ? tmp : DefaultDockingStrategy.getSibling((Dockable)dockable, (String)directionH);
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (dockable == rootDockable) {
            return dockable.dock(toDock, side);
        }
        int i = 0;
        for (i = 0; i < index; ++i) {
            try {
                System.out.println("Index " + i);
                if (DefaultDockingStrategy.getSibling((Dockable)dockable, (String)directionIndex) == null) break;
                dockable = DefaultDockingStrategy.getSibling((Dockable)dockable, (String)directionIndex);
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (i == index) {
            return dockable.dock(toDock, counterDirectionIndex);
        }
        return dockable.dock(toDock, directionIndex);
    }

    public static boolean saveExpression(String expression) {
        return Misc.saveExpression(expression, MainFrame.getMainInstance());
    }

    public static boolean saveExpression(String expression, Component c) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".txt") || file.isDirectory();
            }

            public String getDescription() {
                return "Text file (*.txt)";
            }
        });
        if (jfc.showSaveDialog(c) == 0) {
            try {
                String fileName = jfc.getSelectedFile().getName();
                if (fileName.indexOf(".") < 0) {
                    fileName = fileName + ".txt";
                }
                File f = new File(jfc.getSelectedFile().getParent(), fileName);
                FileWriter fw = new FileWriter(f);
                fw.write(expression);
                fw.close();
                return true;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(c, "Error saving the expression: " + ex.getMessage(), I18n.getString("message.title.error", "Error"), 0);
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static String loadExpression() {
        return Misc.loadExpression(MainFrame.getMainInstance());
    }

    public static String loadExpression(Component c) {
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".txt") || file.isDirectory();
            }

            public String getDescription() {
                return "Text file (*.txt)";
            }
        });
        if (jfc.showOpenDialog(c) == 0) {
            try {
                FileReader fr = new FileReader(jfc.getSelectedFile());
                StringBuffer sb = new StringBuffer();
                char[] cbuf = new char[1024];
                int i = fr.read(cbuf);
                while (i > 0) {
                    sb.append(cbuf, 0, i);
                    i = fr.read(cbuf);
                }
                fr.close();
                return sb.toString();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(c, "Error loading the expression: " + ex.getMessage(), I18n.getString("message.title.error", "Error"), 0);
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape", "htmlview"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception(I18n.getString("misc.browserNotFound", "Could not find web browser"));
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("misc.browserLunchError", "Error attempting to launch web browser") + "\n" + e.getLocalizedMessage());
        }
    }

    public static Object getComboboxSelectedValue(JComboBox combo) {
        Object result = null;
        if (combo != null && (result = combo.getSelectedItem()) != null && result instanceof Tag) {
            return ((Tag)result).getValue();
        }
        return result;
    }

    public static void saveTemporaryLocale(Properties properties, String fileName) {
        if (properties == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        MainFrame.getMainInstance();
        String dir = stringBuilder.append(MainFrame.IREPORT_USER_HOME_DIR).append(File.separator).append("classes").append(File.separator).append("it").append(File.separator).append("businesslogic").append(File.separator).append("ireport").append(File.separator).append("locale").toString();
        File fdir = new File(dir);
        if (!fdir.exists()) {
            fdir.mkdirs();
            if (!fdir.exists()) {
                JOptionPane.showMessageDialog(null, I18n.getFormattedString("translationStatusDialog.messages.unableToCreateDir", "Unable to create directory: {0}", new Object[]{"" + fdir}));
                return;
            }
        }
        try {
            File outFile = new File(fdir, fileName);
            properties.store(new FileOutputStream(outFile), "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void ensurePathIsSelected(TreePath treePath, JTree jTree) {
        if (jTree == null || treePath == null) {
            return;
        }
        TreePath[] selectedPaths = jTree.getSelectionPaths();
        for (int i = 0; selectedPaths != null && i < selectedPaths.length; ++i) {
            if (!selectedPaths[i].equals(treePath)) continue;
            return;
        }
        jTree.setSelectionPath(treePath);
    }

    public static void selectTextAndFocusArea(JComponent expArea) {
        if (expArea == null) {
            return;
        }
        if (expArea instanceof JRTextExpressionArea) {
            ((JRTextExpressionArea)expArea).setSelectionStart(0);
            ((JRTextExpressionArea)expArea).setSelectionEnd(((JRTextExpressionArea)expArea).getText().length());
            ((JRTextExpressionArea)expArea).setHasErrors(true);
        } else if (expArea instanceof JTextComponent) {
            ((JTextComponent)expArea).setSelectionStart(0);
            ((JTextComponent)expArea).setSelectionEnd(((JTextComponent)expArea).getText().length());
            ((JTextComponent)expArea).setBorder(new LineBorder(Color.RED.darker(), 2));
        }
        expArea.requestFocusInWindow();
    }

    public static DefaultMutableTreeNode findNodeWithUserObject(Object userObject, TreeNode node) {
        DefaultMutableTreeNode dmtn;
        if (node == null || userObject == null) {
            return null;
        }
        if (node instanceof DefaultMutableTreeNode && (dmtn = (DefaultMutableTreeNode)node).getUserObject() != null && dmtn.getUserObject().equals(userObject)) {
            return dmtn;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode dmtn2 = Misc.findNodeWithUserObject(userObject, node.getChildAt(i));
            if (dmtn2 == null) continue;
            return dmtn2;
        }
        return null;
    }

    public static void addProperties(String resourceUri, Properties props) {
        try {
            InputStream is = Misc.class.getResourceAsStream(resourceUri);
            if (is == null) {
                return;
            }
            props.load(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getResourceContent(String resourceUri) {
        String content = "";
        if (resourceUri == null) {
            return content;
        }
        try {
            InputStream is = Misc.class.getResourceAsStream(resourceUri);
            if (is == null) {
                return content;
            }
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
            String line = null;
            boolean first = true;
            while ((line = lnr.readLine()) != null) {
                if (!first) {
                    content = content + "\n";
                }
                content = content + line;
                first = false;
            }
            lnr.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return content;
    }

    public static void optime(String opName) {
        long t = new Date().getTime();
        if (opTimes.containsKey(opName)) {
            long t0 = (Long)opTimes.get(opName);
            long opCounter = (Long)opTimes.get(opName + "_coutner");
            opTimes.remove(opName);
            System.out.println(opName + " END (" + opCounter + ")\t" + (t - t0) + "ms");
            System.out.flush();
        } else {
            long opCounter = 0L;
            opTimes.put(opName, new Long(t));
            if (opTimes.containsKey(opName + "_coutner")) {
                opCounter = (Long)opTimes.get(opName + "_coutner");
            }
            opTimes.put(opName + "_coutner", new Long(++opCounter));
            System.out.println(opName + " START (" + opCounter + ")");
            System.out.flush();
        }
    }

    public static boolean isValidUrl(String url) {
        String strRegex = "((([0-9]{1,3}\\.){3})[0-9]{1,3})|(([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.?)++(:[0-9]{1,4})?";
        return url.matches(strRegex);
    }

    public static SubDataset getObjectSubDataset(SubDataset report, Object object) {
        if (report.getParameters().contains(object)) {
            return report;
        }
        if (report.getFields().contains(object)) {
            return report;
        }
        if (report.getVariables().contains(object)) {
            return report;
        }
        if (report instanceof Report) {
            for (int i = 0; i < ((Report)report).getSubDatasets().size(); ++i) {
                SubDataset s = (SubDataset)((Report)report).getSubDatasets().get(i);
                if (Misc.getObjectSubDataset(s, object) == null) continue;
                return s;
            }
        }
        return null;
    }

    public static int getMaxBandHeight(Report report, Band band) {
        int available_height = report.getHeight() - report.getTopMargin() - report.getBottomMargin();
        String bname = band.getName();
        if (bname.equals("background")) {
            return available_height;
        }
        if (bname.equals("title") && report.isIsTitleNewPage()) {
            return available_height;
        }
        if (bname.equals("summary") && report.isIsSummaryNewPage()) {
            return available_height;
        }
        if (bname.equals("noData")) {
            return available_height;
        }
        if (band.isGroupHeader() || band.isGroupFooter()) {
            if (!report.isIsTitleNewPage()) {
                available_height -= report.getBandByName("title").getHeight();
            }
            available_height -= report.getBandByName("pageHeader").getHeight();
            available_height -= report.getBandByName("pageFooter").getHeight();
            available_height -= report.getBandByName("columnHeader").getHeight();
            available_height -= report.getBandByName("columnFooter").getHeight();
        } else if (bname.equals("lastPageFooter")) {
            available_height -= report.getBandByName("pageHeader").getHeight();
            available_height -= report.getBandByName("columnHeader").getHeight();
            available_height -= report.getBandByName("columnFooter").getHeight();
        } else {
            if (!bname.equals("pageHeader")) {
                available_height -= report.getBandByName("pageHeader").getHeight();
            }
            if (!bname.equals("columnHeader")) {
                available_height -= report.getBandByName("columnHeader").getHeight();
            }
            if (!bname.equals("columnFooter")) {
                available_height -= report.getBandByName("columnFooter").getHeight();
            }
            if (!bname.equals("detail")) {
                available_height -= report.getBandByName("detail").getHeight();
            }
        }
        return available_height;
    }
}

