/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityIdentityInsertAction
extends EntityAction {
    private final Object[] state;
    private Serializable generatedId;

    public EntityIdentityInsertAction(Object[] state, Object instance, EntityPersister persister, SessionImplementor session) throws HibernateException {
        super(session, null, instance, persister);
        this.state = state;
    }

    public void execute() throws HibernateException {
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        PreInsertEvent preEvent = new PreInsertEvent(instance, null, this.state, persister, session);
        boolean veto = session.getListeners().getPreInsertEventListener().onPreInsert(preEvent);
        if (!veto) {
            this.generatedId = persister.insert(this.state, instance, session);
        }
        PostInsertEvent postEvent = new PostInsertEvent(instance, this.generatedId, this.state, this.getPersister(), session);
        session.getListeners().getPostInsertEventListener().onPostInsert(postEvent);
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled() && !veto) {
            this.getSession().getFactory().getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
    }

    public boolean hasAfterTransactionCompletion() {
        return false;
    }

    public final Serializable getGeneratedId() {
        return this.generatedId;
    }
}

