/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryFolder;
import com.jaspersoft.jasperserver.irplugin.gui.DataSourceDialog;
import com.jaspersoft.jasperserver.irplugin.gui.RepositoryExplorer;
import com.jaspersoft.jasperserver.irplugin.gui.ValidationUtils;
import com.jaspersoft.jasperserver.irplugin.gui.explorer.ResourceChooser;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class QueryDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private String reportUnitUri = null;
    private RepositoryFolder resource = null;
    private ResourceDescriptor dataSourceDescriptor = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private boolean doNotStore = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JButton jButtonEditLocalDataSource;
    private JButton jButtonPickResource;
    private JButton jButtonSave;
    private JComboBox jComboBoxDatasources;
    private JComboBox jComboBoxQueryLanguage;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelResourceType1;
    private JLabel jLabelUriString;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelDatasource;
    private JRadioButton jRadioButtonLocal;
    private JRadioButton jRadioButtonNone;
    private JRadioButton jRadioButtonRepo;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextAreaSql;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldUriString;

    public QueryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Misc.centerFrame((Component)this);
        DocumentListener changesListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                QueryDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                QueryDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                QueryDialog.this.updateSaveButton();
            }
        };
        this.jTextFieldLabel.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.requestFocusInWindow();
        List list = IRPlugin.getMainInstance().getSupportedQueryLanguages();
        for (int i = 0; i < list.size(); ++i) {
            this.jComboBoxQueryLanguage.addItem(list.get(i));
        }
        this.jTextAreaSql.getDocument().addDocumentListener(changesListener);
        if (!IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            this.jTabbedPane1.remove(this.jPanelDatasource);
        }
        this.applyI18n();
    }

    public void applyI18n() {
        this.jButtonClose.setText(IRPlugin.getString("queryDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(IRPlugin.getString("queryDialog.buttonSave", "Save"));
        this.jLabel1.setText(IRPlugin.getString("queryDialog.title", "Query"));
        this.jLabelDescription.setText(IRPlugin.getString("queryDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(IRPlugin.getString("queryDialog.labelLabel", "Label"));
        this.jLabelName.setText(IRPlugin.getString("queryDialog.labelName", "Name"));
        this.jLabelUriString.setText(IRPlugin.getString("queryDialog.labelParentFolder", "Parent folder"));
        this.jLabel2.setText(IRPlugin.getString("queryDialog.labelQuery", "Query"));
        this.jLabel3.setText(IRPlugin.getString("queryDialog.labelQueryLanguage", "Query language"));
        this.jTabbedPane1.setTitleAt(0, IRPlugin.getString("queryDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, IRPlugin.getString("queryDialog.tabDetails", "Query"));
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0 && this.jTextAreaSql.getText().length() > 0) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jComboBoxQueryLanguage = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaSql = new JTextArea();
        this.jPanelDatasource = new JPanel();
        this.jLabelResourceType1 = new JLabel();
        this.jRadioButtonRepo = new JRadioButton();
        this.jComboBoxDatasources = new JComboBox();
        this.jButtonPickResource = new JButton();
        this.jRadioButtonLocal = new JRadioButton();
        this.jButtonEditLocalDataSource = new JButton();
        this.jRadioButtonNone = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Type");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource_new.png")));
        this.jLabel1.setText("Query");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setPreferredSize(new Dimension(400, 185));
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel3.setText("Query language");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel3.add((Component)this.jComboBoxQueryLanguage, gridBagConstraints);
        this.jLabel2.setText("Query");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextAreaSql.setColumns(20);
        this.jTextAreaSql.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaSql);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTabbedPane1.addTab("Query", this.jPanel3);
        this.jPanelDatasource.setLayout(new GridBagLayout());
        this.jLabelResourceType1.setText("Locate Data Source");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelDatasource.add((Component)this.jLabelResourceType1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonRepo);
        this.jRadioButtonRepo.setSelected(true);
        this.jRadioButtonRepo.setText("From the repository");
        this.jRadioButtonRepo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryDialog.this.jRadioButtonRepoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanelDatasource.add((Component)this.jRadioButtonRepo, gridBagConstraints);
        this.jComboBoxDatasources.setEditable(true);
        this.jComboBoxDatasources.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 4, 2);
        this.jPanelDatasource.add((Component)this.jComboBoxDatasources, gridBagConstraints);
        this.jButtonPickResource.setText("Browse");
        this.jButtonPickResource.setEnabled(false);
        this.jButtonPickResource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryDialog.this.jButtonPickResourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        this.jPanelDatasource.add((Component)this.jButtonPickResource, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonLocal);
        this.jRadioButtonLocal.setText("Locally Defined");
        this.jRadioButtonLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryDialog.this.jRadioButtonLocalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanelDatasource.add((Component)this.jRadioButtonLocal, gridBagConstraints);
        this.jButtonEditLocalDataSource.setText("Edit local datasource");
        this.jButtonEditLocalDataSource.setEnabled(false);
        this.jButtonEditLocalDataSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryDialog.this.jButtonEditLocalDataSourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanelDatasource.add((Component)this.jButtonEditLocalDataSource, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonNone);
        this.jRadioButtonNone.setText("None");
        this.jRadioButtonNone.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonNone.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryDialog.this.jRadioButtonLocalActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(16, 8, 4, 4);
        this.jPanelDatasource.add((Component)this.jRadioButtonNone, gridBagConstraints);
        this.jTabbedPane1.addTab("Data Source", this.jPanelDatasource);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 30));
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jRadioButtonLocalActionPerformed1(ActionEvent evt) {
        this.updateDataSourceFromType();
    }

    private void jButtonEditLocalDataSourceActionPerformed(ActionEvent evt) {
        DataSourceDialog dtd = new DataSourceDialog((Frame)MainFrame.getMainInstance(), true);
        dtd.setServer(this.getServer());
        dtd.setParentFolder(this.getParentFolder() + "/<dataSource>");
        dtd.setDoNotStore(true);
        if (this.dataSourceDescriptor != null) {
            dtd.setResource(this.dataSourceDescriptor);
        }
        ((Component)dtd).setVisible(true);
        if (dtd.getDialogResult() == 0) {
            this.dataSourceDescriptor = dtd.getNewResourceDescriptor();
        }
    }

    private void jRadioButtonLocalActionPerformed(ActionEvent evt) {
        this.updateDataSourceFromType();
    }

    private void jButtonPickResourceActionPerformed(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (rd == null || rd.getUriString() == null) {
                this.jComboBoxDatasources.setSelectedItem("");
            } else {
                this.jComboBoxDatasources.setSelectedItem(rd.getUriString());
            }
            this.updateSaveButton();
        }
    }

    private void jRadioButtonRepoActionPerformed(ActionEvent evt) {
        this.updateDataSourceFromType();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setName(this.jTextFieldName.getText());
        String uri = this.getParentFolder();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.jTextFieldName.getText();
        rd.setUriString(uri);
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getParentFolder());
        rd.setIsNew(this.resource == null);
        rd.setWsType("query");
        rd.setSql(this.jTextAreaSql.getText());
        if (IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            ResourceDescriptor tmpDataSourceDescriptor = null;
            if (this.jRadioButtonRepo.isSelected()) {
                tmpDataSourceDescriptor = new ResourceDescriptor();
                tmpDataSourceDescriptor.setWsType("datasource");
                tmpDataSourceDescriptor.setReferenceUri(this.jComboBoxDatasources.getSelectedItem() + "");
                tmpDataSourceDescriptor.setIsReference(true);
            } else if (this.jRadioButtonLocal.isSelected()) {
                if (this.dataSourceDescriptor == null) {
                    JOptionPane.showMessageDialog(this, IRPlugin.getString("reportUnitDialog.message.localDatasourceNotDefined", "The local datasource is not correctly defined.\nPress the button \"Edit local datasource\" to fix the problem."));
                    return;
                }
                tmpDataSourceDescriptor = this.dataSourceDescriptor;
                tmpDataSourceDescriptor.setIsReference(false);
            }
            if (tmpDataSourceDescriptor != null) {
                rd.getChildren().add(tmpDataSourceDescriptor);
            }
        }
        String queryLanguage = "sql";
        Object obj = this.jComboBoxQueryLanguage.getSelectedItem();
        queryLanguage = obj != null && obj instanceof Tag ? "" + ((Tag)obj).getValue() : "" + obj;
        rd.setResourceProperty("PROP_QUERY_LANGUAGE", queryLanguage);
        try {
            this.validate(rd);
            this.newResourceDescriptor = !this.doNotStore ? this.getServer().getWSClient().addOrModifyResource(rd, null) : rd;
            this.setDialogResult(0);
            if (this.resource != null) {
                this.resource.setDescriptor(this.newResourceDescriptor);
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        if (this.reportUnitUri != null && this.reportUnitUri.length() > 0) {
            this.parentFolder = this.reportUnitUri + "_files";
        }
        this.jTextFieldUriString.setText(parentFolder);
    }

    public String getReportUnitUri() {
        return this.reportUnitUri;
    }

    public void setReportUnitUri(String reportUnitUri) {
        this.reportUnitUri = reportUnitUri;
        if (reportUnitUri != null && reportUnitUri.length() > 0) {
            this.setParentFolder(reportUnitUri + "_files");
        }
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryFolder resource) {
        this.resource = resource;
        if (resource != null) {
            this.setResource(resource.getDescriptor());
            this.jTextFieldName.setEditable(false);
            this.jTextFieldName.setOpaque(false);
        }
    }

    public void setResource(ResourceDescriptor descriptor) {
        this.resource = this.resource;
        this.jTextFieldName.setText(descriptor.getName());
        this.jTextFieldLabel.setText(descriptor.getLabel());
        this.jEditorPaneDescription.setText(descriptor.getDescription());
        this.jTextAreaSql.setText(descriptor.getSql() != null ? descriptor.getSql() : "");
        String ql = descriptor.getResourcePropertyValue("PROP_QUERY_LANGUAGE");
        if (ql == null) {
            ql = "sql";
        }
        boolean found = false;
        for (int ix = 0; ix < this.jComboBoxQueryLanguage.getItemCount(); ++ix) {
            Tag t = (Tag)this.jComboBoxQueryLanguage.getItemAt(ix);
            if (!t.getValue().equals(ql)) continue;
            found = true;
            this.jComboBoxQueryLanguage.setSelectedIndex(ix);
            break;
        }
        if (!found) {
            this.jComboBoxQueryLanguage.setSelectedItem(ql);
        }
        this.jRadioButtonLocal.setSelected(false);
        this.jRadioButtonRepo.setSelected(false);
        this.jRadioButtonNone.setSelected(true);
        for (int i = 0; i < descriptor.getChildren().size(); ++i) {
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(i);
            if (rd.getWsType().equals("datasource")) {
                this.jComboBoxDatasources.setSelectedItem(rd.getReferenceUri());
                this.jRadioButtonRepo.setSelected(true);
                this.jRadioButtonLocal.setSelected(false);
                this.jRadioButtonNone.setSelected(false);
                continue;
            }
            if (!RepositoryExplorer.isDataSource(rd)) continue;
            this.dataSourceDescriptor = rd;
            this.jRadioButtonLocal.setSelected(true);
            this.jRadioButtonRepo.setSelected(false);
            this.jRadioButtonNone.setSelected(false);
        }
        this.updateDataSourceFromType();
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
    }

    public boolean isDoNotStore() {
        return this.doNotStore;
    }

    public void setDoNotStore(boolean doNotStore) {
        this.doNotStore = doNotStore;
    }

    public void updateDataSourceFromType() {
        this.jComboBoxDatasources.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonPickResource.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonEditLocalDataSource.setEnabled(this.jRadioButtonLocal.isSelected());
    }

    public void setDatasources(List datasources) {
        this.jComboBoxDatasources.removeAllItems();
        for (int i = 0; i < datasources.size(); ++i) {
            Object datasource = datasources.get(i);
            if (datasource instanceof String) {
                this.jComboBoxDatasources.addItem(datasource);
                continue;
            }
            if (!(datasource instanceof ResourceDescriptor)) continue;
            this.jComboBoxDatasources.addItem(((ResourceDescriptor)datasource).getUriString());
        }
        if (this.jComboBoxDatasources.getItemCount() > 0) {
            this.jComboBoxDatasources.setSelectedIndex(0);
        }
    }
}

