/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ResolverBase;

class CaseTestFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    public CaseTestFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        final BooleanCalc[] conditionCalcs = new BooleanCalc[args.length / 2];
        final Calc[] exprCalcs = new Calc[args.length / 2];
        ArrayList<Calc> calcList = new ArrayList<Calc>();
        int j = 0;
        for (int i = 0; i < exprCalcs.length; ++i) {
            conditionCalcs[i] = compiler.compileBoolean(args[j++]);
            calcList.add(conditionCalcs[i]);
            exprCalcs[i] = compiler.compileScalar(args[j++], true);
            calcList.add(exprCalcs[i]);
        }
        final ConstantCalc defaultCalc = args.length % 2 == 1 ? compiler.compileScalar(args[args.length - 1], true) : ConstantCalc.constantNull(call.getType());
        calcList.add(defaultCalc);
        final Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
        return new AbstractCalc(call){

            public Object evaluate(Evaluator evaluator) {
                for (int i = 0; i < conditionCalcs.length; ++i) {
                    if (!conditionCalcs[i].evaluateBoolean(evaluator)) continue;
                    return exprCalcs[i].evaluate(evaluator);
                }
                return defaultCalc.evaluate(evaluator);
            }

            public Calc[] getCalcs() {
                return calcs;
            }
        };
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("_CaseTest", "Case When <Logical Expression> Then <Expression> [...] [Else <Expression>] End", "Evaluates various conditions, and returns the corresponding expression for the first which evaluates to true.", Syntax.Case);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length < 1) {
                return null;
            }
            int j = 0;
            int clauseCount = args.length / 2;
            int mismatchingArgs = 0;
            int returnType = args[1].getCategory();
            for (int i = 0; i < clauseCount; ++i) {
                if (!validator.canConvert(args[j++], 5, conversionCount)) {
                    ++mismatchingArgs;
                }
                if (validator.canConvert(args[j++], returnType, conversionCount)) continue;
                ++mismatchingArgs;
            }
            if (j < args.length && !validator.canConvert(args[j++], returnType, conversionCount)) {
                ++mismatchingArgs;
            }
            Util.assertTrue(j == args.length);
            if (mismatchingArgs != 0) {
                return null;
            }
            FunDef dummy = ResolverImpl.createDummyFunDef(this, returnType, args);
            return new CaseTestFunDef(dummy);
        }

        public boolean requiresExpression(int k) {
            return true;
        }
    }
}

