/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mondrian.olap.CacheControl;
import mondrian.olap.Evaluator;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.CacheControlImpl;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.RangeColumnPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapAggregationManager
implements CellReader {
    public static CellRequest makeRequest(Member[] members, boolean extendedContext, boolean drillThrough) {
        if (!(members[0] instanceof RolapStoredMeasure)) {
            return null;
        }
        RolapStoredMeasure measure = (RolapStoredMeasure)members[0];
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        assert (starMeasure != null);
        RolapStar star = starMeasure.getStar();
        CellRequest request = new CellRequest(starMeasure, extendedContext, drillThrough);
        Map<RolapLevel, RolapStar.Column> levelToColumnMap = star.getLevelToColumnMap(measure.getCube());
        if (request.extendedContext) {
            for (int i = 1; i < members.length; ++i) {
                RolapMember member = (RolapMember)members[i];
                RolapAggregationManager.addNonConstrainingColumns(member, levelToColumnMap, request);
                RolapLevel level = member.getLevel();
                boolean needToReturnNull = level.getLevelReader().constrainRequest(member, levelToColumnMap, request);
                if (!needToReturnNull) continue;
                return null;
            }
        } else {
            for (int i = 1; i < members.length; ++i) {
                RolapMember member = (RolapMember)members[i];
                RolapLevel level = member.getLevel();
                boolean needToReturnNull = level.getLevelReader().constrainRequest(member, levelToColumnMap, request);
                if (!needToReturnNull) continue;
                return null;
            }
        }
        return request;
    }

    private static void addNonConstrainingColumns(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
        RolapHierarchy hierarchy = member.getHierarchy();
        Level[] levels = hierarchy.getLevels();
        int depth = member.getLevel().getDepth();
        for (int j = levels.length - 1; j > depth; --j) {
            RolapLevel level = (RolapLevel)levels[j];
            RolapStar.Column column = levelToColumnMap.get(level);
            if (column == null) continue;
            request.addConstrainedColumn(column, null);
            if (!request.extendedContext || level.getNameExp() == null) continue;
            RolapStar.Column nameColumn = column.getNameColumn();
            Util.assertTrue(nameColumn != null);
            request.addConstrainedColumn(nameColumn, null);
        }
    }

    protected RolapAggregationManager() {
    }

    public Object getCellFromCache(Member[] members) {
        CellRequest request = RolapAggregationManager.makeRequest(members, false, false);
        return request == null ? Util.nullValue : this.getCellFromCache(request);
    }

    public abstract Object getCellFromCache(CellRequest var1);

    public abstract Object getCellFromCache(CellRequest var1, PinSet var2);

    public Object getCell(Member[] members) {
        CellRequest request = RolapAggregationManager.makeRequest(members, false, false);
        RolapStoredMeasure measure = (RolapStoredMeasure)members[0];
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        assert (starMeasure != null);
        RolapStar star = starMeasure.getStar();
        return star.getCell(request);
    }

    @Override
    public Object get(Evaluator evaluator) {
        RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
        return this.getCell(rolapEvaluator.getMembers());
    }

    public abstract String getDrillThroughSql(CellRequest var1, boolean var2);

    @Override
    public int getMissCount() {
        return 0;
    }

    public CacheControl getCacheControl(final PrintWriter pw) {
        return new CacheControlImpl(){

            protected void flushNonUnion(CacheControl.CellRegion region) {
                List<RolapStar> starList = 1.getStarList(region);
                for (RolapStar star : starList) {
                    star.flush(this, region);
                }
            }

            public void flush(CacheControl.CellRegion region) {
                if (pw != null) {
                    pw.println("Cache state before flush:");
                    this.printCacheState(pw, region);
                    pw.println();
                }
                super.flush(region);
                if (pw != null) {
                    pw.println("Cache state after flush:");
                    this.printCacheState(pw, region);
                    pw.println();
                }
            }

            public void trace(String message) {
                if (pw != null) {
                    pw.println(message);
                }
            }
        };
    }

    public static RolapCacheRegion makeCacheRegion(RolapStar star, CacheControl.CellRegion region) {
        List<Member> measureList = CacheControlImpl.findMeasures(region);
        ArrayList<RolapStar.Measure> starMeasureList = new ArrayList<RolapStar.Measure>();
        Map<RolapLevel, RolapStar.Column> levelToColumnMap = null;
        for (Member measure : measureList) {
            if (!(measure instanceof RolapStoredMeasure)) continue;
            RolapStoredMeasure storedMeasure = (RolapStoredMeasure)measure;
            RolapStar.Measure starMeasure = (RolapStar.Measure)storedMeasure.getStarMeasure();
            assert (starMeasure != null);
            if (star != starMeasure.getStar()) continue;
            levelToColumnMap = star.getLevelToColumnMap(storedMeasure.getCube());
            starMeasureList.add(starMeasure);
        }
        RolapCacheRegion cacheRegion = new RolapCacheRegion(star, starMeasureList);
        if (region instanceof CacheControlImpl.CrossjoinCellRegion) {
            CacheControlImpl.CrossjoinCellRegion crossjoin = (CacheControlImpl.CrossjoinCellRegion)region;
            for (CacheControl.CellRegion component : crossjoin.getComponents()) {
                RolapAggregationManager.constrainCacheRegion(cacheRegion, levelToColumnMap, component);
            }
        } else {
            RolapAggregationManager.constrainCacheRegion(cacheRegion, levelToColumnMap, region);
        }
        return cacheRegion;
    }

    private static void constrainCacheRegion(RolapCacheRegion cacheRegion, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CacheControl.CellRegion region) {
        if (region instanceof CacheControlImpl.MemberCellRegion) {
            CacheControlImpl.MemberCellRegion memberCellRegion = (CacheControlImpl.MemberCellRegion)region;
            List<Member> memberList = memberCellRegion.getMemberList();
            for (Member member : memberList) {
                RolapMember rolapMember = (RolapMember)member;
                RolapLevel level = rolapMember.getLevel();
                RolapStar.Column column = levelToColumnMap.get(level);
                level.getLevelReader().constrainRegion(new MemberColumnPredicate(column, rolapMember), levelToColumnMap, cacheRegion);
            }
        } else if (region instanceof CacheControlImpl.MemberRangeCellRegion) {
            CacheControlImpl.MemberRangeCellRegion rangeRegion = (CacheControlImpl.MemberRangeCellRegion)region;
            RolapLevel level = rangeRegion.getLevel();
            RolapStar.Column column = levelToColumnMap.get(level);
            level.getLevelReader().constrainRegion(new RangeColumnPredicate(column, rangeRegion.getLowerInclusive(), rangeRegion.getLowerBound() == null ? null : new MemberColumnPredicate(column, rangeRegion.getLowerBound()), rangeRegion.getUpperInclusive(), rangeRegion.getUpperBound() == null ? null : new MemberColumnPredicate(column, rangeRegion.getUpperBound())), levelToColumnMap, cacheRegion);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public abstract PinSet createPinSet();

    public static interface PinSet {
    }
}

