/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.flex;

import flex2.tools.Compiler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Permission;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.util.JRStreamUtil;
import net.sf.jasperreports.export.flex.JRMxmlExporter;
import net.sf.jasperreports.export.flex.JRMxmlExporterParameter;
import net.sf.jasperreports.export.flex.JRSwfExporterParameter;

public class JRSwfExporter
extends JRAbstractExporter {
    private static String SWC_FILE = null;
    protected String flexSdkHome;
    protected String libraryPath;
    protected boolean isUseNetwork;
    protected boolean isSuppressFlexCompilerMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        this.setOffset();
        try {
            this.setExportContext();
            this.setInput();
            if (!this.isModeBatch) {
                this.setPageRange();
            }
            this.flexSdkHome = this.getStringParameter((JRExporterParameter)JRSwfExporterParameter.FLEX_SDK_HOME, "net.sf.jasperreports.export.flex.sdk.home");
            if (this.flexSdkHome == null) {
                this.flexSdkHome = System.getenv("FLEX_SDK_HOME");
                if (this.flexSdkHome == null) {
                    throw new JRException("The FLEX_SDK_HOME environment variable is not set.");
                }
            }
            this.libraryPath = this.getStringParameter((JRExporterParameter)JRSwfExporterParameter.LIBRARY_PATH, "net.sf.jasperreports.export.flex.library.path");
            if (this.libraryPath == null) {
                if (SWC_FILE == null) {
                    try {
                        File swcFile = File.createTempFile("jasperreports-flash", ".swc");
                        swcFile.deleteOnExit();
                        JRStreamUtil.copyFromLocation("jasperreports-flash.swc", swcFile);
                        SWC_FILE = swcFile.getAbsolutePath();
                    }
                    catch (IOException e) {
                        throw new JRException("Error trying to extract the JasperReports Flash Exporter SWC resource.");
                    }
                }
                this.libraryPath = SWC_FILE;
            }
            this.isUseNetwork = this.getBooleanParameter((JRExporterParameter)JRSwfExporterParameter.USE_NETWORK, "net.sf.jasperreports.export.flex.use.network", true);
            this.isSuppressFlexCompilerMessages = this.getBooleanParameter((JRExporterParameter)JRSwfExporterParameter.SUPPRESS_COMPILER_MESSAGES, "net.sf.jasperreports.export.flex.suppress.compiler.messages", true);
            OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
            if (os != null) {
                this.exportReportToStream(os);
                return;
            }
            File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (destFile == null) {
                String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (fileName == null) throw new JRException("No output specified for the exporter.");
                destFile = new File(fileName);
            }
            try {
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                    os.flush();
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, (Throwable)e);
                }
                Object var5_6 = null;
                if (os == null) return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            os.close();
            return;
        }
        finally {
            this.resetExportContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void exportReportToStream(OutputStream os) throws JRException {
        File tmpSwfFile;
        block16: {
            File tmpMxmlFile = null;
            tmpSwfFile = null;
            try {
                try {
                    block15: {
                        JRMxmlExporter exporter = new JRMxmlExporter();
                        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
                        if (this.parameters.containsKey(JRExporterParameter.FILTER)) {
                            exporter.setParameter(JRExporterParameter.FILTER, this.filter);
                        }
                        tmpMxmlFile = File.createTempFile(this.jasperPrint.getName(), ".mxml");
                        tmpSwfFile = File.createTempFile(this.jasperPrint.getName(), ".swf");
                        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, tmpMxmlFile);
                        exporter.setParameter((JRExporterParameter)JRMxmlExporterParameter.IS_EMBEDDING_IMAGES, this.parameters.get(JRSwfExporterParameter.IS_EMBEDDING_IMAGES));
                        exporter.setParameter((JRExporterParameter)JRMxmlExporterParameter.IS_EMBEDDING_FONTS, this.parameters.get((Object)JRSwfExporterParameter.IS_EMBEDDING_FONTS));
                        exporter.exportReport();
                        PrintStream out = System.out;
                        PrintStream err = System.err;
                        if (this.isSuppressFlexCompilerMessages) {
                            PrintStream dummyStream = new PrintStream(new OutputStream(){

                                public void write(int b) throws IOException {
                                }
                            });
                            System.setOut(dummyStream);
                            System.setErr(dummyStream);
                        }
                        SecurityManager sm = System.getSecurityManager();
                        System.setSecurityManager(new SecurityManager(){

                            public void checkExit(int status) {
                                throw new SystemExitSecurityException(status);
                            }

                            public void checkPermission(Permission perm) {
                            }
                        });
                        try {
                            try {
                                Compiler.main((String[])new String[]{"-library-path+=" + (this.libraryPath == null ? "" : this.libraryPath), "-use-network=" + this.isUseNetwork, "-load-config=" + this.flexSdkHome + "/frameworks/flex-config.xml", "-local-fonts-snapshot=" + this.flexSdkHome + "/frameworks/" + (System.getProperty("os.name").toLowerCase().startsWith("mac") ? "mac" : "win") + "Fonts.ser", "-o=" + tmpSwfFile.getAbsolutePath(), tmpMxmlFile.getAbsolutePath()});
                            }
                            catch (SystemExitSecurityException e) {
                                if (e.getStatus() != 0) {
                                    throw new JRException("Flex SDK compiler error. Check the log for details.");
                                }
                                Object var10_10 = null;
                                System.setSecurityManager(sm);
                                if (this.isSuppressFlexCompilerMessages) {
                                    System.setErr(err);
                                    System.setOut(out);
                                }
                                break block15;
                            }
                            Object var10_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            System.setSecurityManager(sm);
                            if (!this.isSuppressFlexCompilerMessages) throw throwable;
                            System.setErr(err);
                            System.setOut(out);
                            throw throwable;
                        }
                        System.setSecurityManager(sm);
                        if (this.isSuppressFlexCompilerMessages) {
                            System.setErr(err);
                            System.setOut(out);
                        }
                    }
                    JRStreamUtil.copy(tmpSwfFile, os);
                }
                catch (IOException e) {
                    throw new JRException((Throwable)e);
                }
                Object var12_14 = null;
                if (tmpMxmlFile == null) break block16;
                tmpMxmlFile.delete();
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (tmpMxmlFile != null) {
                    tmpMxmlFile.delete();
                }
                if (tmpSwfFile == null) throw throwable;
                tmpSwfFile.delete();
                throw throwable;
            }
        }
        if (tmpSwfFile == null) return;
        tmpSwfFile.delete();
    }

    class SystemExitSecurityException
    extends SecurityException {
        private static final long serialVersionUID = 10200L;
        int status = 0;

        SystemExitSecurityException(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

