/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.dom;

import flex2.compiler.mxml.Parser;
import flex2.compiler.mxml.Token;
import flex2.compiler.mxml.TokenManager;
import flex2.compiler.mxml.dom.ApplicationNode;
import flex2.compiler.mxml.dom.ArgumentsNode;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BindingNode;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.ClassNode;
import flex2.compiler.mxml.dom.FunctionNode;
import flex2.compiler.mxml.dom.HTTPServiceNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.MetaDataNode;
import flex2.compiler.mxml.dom.MethodNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.OperationNode;
import flex2.compiler.mxml.dom.RemoteObjectNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.dom.ScannerError;
import flex2.compiler.mxml.dom.ScriptNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.StyleNode;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.dom.WebServiceNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class Scanner
extends DefaultHandler
implements TokenManager {
    private static final String CUSTOM_ATTRIBUTES_CLASS = "org.apache.xerces.parsers.AbstractSAXParserMMImpl$AttributesProxy";
    private static Class CustomAttributeClass = null;
    public static String MarkupNotRecognizedInContent;
    public static String ReservedPITarget;
    public static String MarkupNotRecognizedInMisc;
    public static String ETagRequired;
    private List saxEvents = new ArrayList(100);
    private CDATAHandler cdataHandler = new CDATAHandler();
    private int beginLine;
    private int beginColumn;
    private int pos = 0;
    private int kind;
    private static final int LEX_FLEX2 = 0;
    private static final int LEX_FLEX1_WEBSERVICE = 1;
    private static final int LEX_FLEX1_HTTPSERVICE = 2;
    private static final int LEX_FLEX1_REMOTEOBJECT = 3;
    private int state = 0;
    private Locator locator;
    private Map prefixMappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scanner(InputStream in) {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(false);
            saxFactory.setNamespaceAware(true);
            SAXParser parser = saxFactory.newSAXParser();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", this.cdataHandler);
            parser.parse(in, (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
        }
        catch (SAXException ex) {
            Throwable t = ex.getCause();
            if (t instanceof ScannerError) {
                throw (ScannerError)t;
            }
        }
        catch (IOException iOException) {
        }
    }

    public Token getNextToken() throws ScannerError {
        Object evt;
        if (this.pos >= this.saxEvents.size()) {
            Object evt2 = this.saxEvents.get(this.saxEvents.size() - 1);
            if (evt2 instanceof Token) {
                int line = ((Token)evt2).beginLine;
                int col = ((Token)evt2).beginColumn;
                String msg = ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new UnexpectedEndOfTokenStream(((Token)evt2).image));
                throw new ScannerError(line, col, msg);
            }
            int line = ((ScannerError)evt2).getLineNumber();
            int col = ((ScannerError)evt2).getColumnNumber();
            String msg = ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new UnexpectedEndOfSAXStream(((ScannerError)evt2).getReason()));
            throw new ScannerError(line, col, msg);
        }
        if ((evt = this.saxEvents.get(this.pos++)) instanceof Token) {
            return (Token)evt;
        }
        throw (ScannerError)evt;
    }

    private int findElementType(String uri, String localName, boolean start) {
        int kind = Parser.findElementType(uri, localName, start);
        block0 : switch (this.state) {
            case 0: {
                switch (kind) {
                    case 37: {
                        this.state = 1;
                        break;
                    }
                    case 43: {
                        this.state = 2;
                        break;
                    }
                    case 31: {
                        this.state = 3;
                        break;
                    }
                    case 33: 
                    case 35: 
                    case 39: 
                    case 41: {
                        kind = 47;
                        break;
                    }
                    case 34: 
                    case 36: 
                    case 40: 
                    case 42: {
                        kind = 48;
                    }
                }
                break;
            }
            case 1: {
                switch (kind) {
                    case 38: {
                        this.state = 0;
                        break;
                    }
                    case 33: 
                    case 35: {
                        kind = 47;
                        break;
                    }
                    case 34: 
                    case 36: {
                        kind = 48;
                    }
                }
                break;
            }
            case 2: {
                switch (kind) {
                    case 44: {
                        this.state = 0;
                        break;
                    }
                    case 33: 
                    case 35: 
                    case 39: {
                        kind = 47;
                        break;
                    }
                    case 34: 
                    case 36: 
                    case 40: {
                        kind = 48;
                    }
                }
                break;
            }
            case 3: {
                switch (kind) {
                    case 32: {
                        this.state = 0;
                        break block0;
                    }
                    case 39: 
                    case 41: {
                        kind = 47;
                        break block0;
                    }
                    case 40: 
                    case 42: {
                        kind = 48;
                    }
                }
            }
        }
        return kind;
    }

    protected Node createNode(int kind, String uri, String localName, Attributes attributes) {
        int numAttributes = attributes.getLength();
        Node node = null;
        switch (kind) {
            case 1: {
                node = new StyleNode(uri, localName, numAttributes);
                break;
            }
            case 3: {
                node = new ScriptNode(uri, localName, numAttributes);
                break;
            }
            case 5: {
                node = new MetaDataNode(uri, localName, numAttributes);
                break;
            }
            case 7: {
                node = new ModelNode(uri, localName, numAttributes);
                break;
            }
            case 9: {
                node = new XMLNode(uri, localName, numAttributes);
                break;
            }
            case 11: {
                node = new XMLListNode(uri, localName, numAttributes);
                break;
            }
            case 13: {
                node = new ArrayNode(uri, localName, numAttributes);
                break;
            }
            case 17: {
                node = new StringNode(uri, localName, numAttributes);
                break;
            }
            case 19: {
                node = new NumberNode(uri, localName, numAttributes);
                break;
            }
            case 21: {
                node = new IntNode(uri, localName, numAttributes);
                break;
            }
            case 23: {
                node = new UIntNode(uri, localName, numAttributes);
                break;
            }
            case 25: {
                node = new BooleanNode(uri, localName, numAttributes);
                break;
            }
            case 27: {
                node = new ClassNode(uri, localName, numAttributes);
                break;
            }
            case 29: {
                node = new FunctionNode(uri, localName, numAttributes);
                break;
            }
            case 37: {
                node = new WebServiceNode(uri, localName, numAttributes);
                break;
            }
            case 43: {
                node = new HTTPServiceNode(uri, localName, numAttributes);
                break;
            }
            case 31: {
                node = new RemoteObjectNode(uri, localName, numAttributes);
                break;
            }
            case 39: {
                node = new OperationNode(uri, localName, numAttributes);
                break;
            }
            case 41: {
                if ("xml".equals(attributes.getValue("", "format"))) {
                    node = new XMLNode(uri, localName, numAttributes);
                    break;
                }
                node = new RequestNode(uri, localName, numAttributes);
                break;
            }
            case 33: {
                node = new MethodNode(uri, localName, numAttributes);
                break;
            }
            case 35: {
                node = new ArgumentsNode(uri, localName, numAttributes);
                break;
            }
            case 15: {
                node = new BindingNode(uri, localName, numAttributes);
                break;
            }
            case 47: {
                if (this.saxEvents.size() == 0) {
                    node = new ApplicationNode(uri, localName, numAttributes);
                    break;
                }
                node = new Node(uri, localName, numAttributes);
                break;
            }
            case 45: {
                node = new InlineComponentNode(uri, localName, numAttributes);
            }
        }
        return node;
    }

    private void assignTokenPosition(Token t) {
        if (this.saxEvents.size() == 0) {
            this.beginLine = this.locator.getLineNumber();
            this.beginColumn = this.locator.getColumnNumber();
        }
        t.beginLine = this.beginLine;
        t.beginColumn = this.beginColumn;
        t.endLine = this.locator.getLineNumber();
        t.endColumn = this.locator.getColumnNumber();
    }

    public void close() {
        this.saxEvents.clear();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.prefixMappings = new HashMap();
    }

    public void endDocument() throws SAXException {
        Token t = new Token();
        t.kind = 0;
        this.assignTokenPosition(t);
        t.image = "";
        this.saxEvents.add(t);
        this.kind = 0;
        this.locator = null;
        this.prefixMappings = null;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMappings.put(uri, prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.kind = this.findElementType(uri, localName, true);
        int numAttributes = attributes.getLength();
        Node n = this.createNode(this.kind, uri, localName, attributes);
        n.addPrefixMapping(uri, (String)this.prefixMappings.get(uri));
        this.assignTokenPosition(n);
        Method lineNumMethod = null;
        if (numAttributes > 0 && CustomAttributeClass != null && attributes.getClass().isAssignableFrom(CustomAttributeClass)) {
            try {
                lineNumMethod = attributes.getClass().getMethod("getLineNumber", Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        for (int i = 0; i < numAttributes; ++i) {
            int line = n.beginLine;
            try {
                if (lineNumMethod != null) {
                    line = Integer.parseInt(lineNumMethod.invoke((Object)attributes, new Integer(i)).toString());
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            String attrUri = attributes.getURI(i);
            n.addAttribute(attrUri, attributes.getLocalName(i), attributes.getValue(i), line);
            n.addPrefixMapping(attrUri, (String)this.prefixMappings.get(attrUri));
        }
        n.kind = this.kind;
        n.image = "<" + qName + ">";
        this.saxEvents.add(n);
        this.beginLine = this.locator.getLineNumber();
        this.beginColumn = this.locator.getColumnNumber();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Token n = new Token();
        n.kind = this.findElementType(uri, localName, false);
        this.assignTokenPosition(n);
        n.image = "</" + qName + ">";
        this.saxEvents.add(n);
        this.kind = n.kind;
        this.beginLine = this.locator.getLineNumber();
        this.beginColumn = this.locator.getColumnNumber();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        CDATANode cdata;
        String image = new String(ch, start, length);
        Object obj = this.saxEvents.get(this.saxEvents.size() - 1);
        boolean wasInCDATA = obj instanceof CDATANode && ((CDATANode)obj).inCDATA;
        boolean skip = false;
        CDATANode cDATANode = cdata = obj instanceof CDATANode ? (CDATANode)obj : null;
        if (!wasInCDATA || !this.cdataHandler.inCDATA) {
            if (wasInCDATA && !this.cdataHandler.inCDATA) {
                if (image.trim().length() > 0) {
                    cdata = null;
                } else {
                    skip = true;
                }
            } else if (!wasInCDATA && this.cdataHandler.inCDATA) {
                cdata = null;
            } else if (this.kind != 49 && image.trim().length() == 0) {
                skip = true;
            }
        }
        if (!skip && cdata == null) {
            cdata = new CDATANode();
            cdata.kind = 49;
            this.assignTokenPosition(cdata);
            cdata.image = image;
            cdata.inCDATA = this.cdataHandler.inCDATA;
            this.saxEvents.add(cdata);
        } else if (!skip) {
            cdata.image = cdata.image + image;
            cdata.endLine = this.locator.getLineNumber();
            cdata.endColumn = this.locator.getColumnNumber();
        }
        if (!skip) {
            this.kind = 49;
        }
        this.beginLine = this.locator.getLineNumber();
        this.beginColumn = this.locator.getColumnNumber();
    }

    public void warning(SAXParseException e) throws SAXException {
        int line = this.locator != null ? this.locator.getLineNumber() : 1;
        int col = this.locator != null ? this.locator.getColumnNumber() : 1;
        ScannerError err = new ScannerError(line, col, e.getMessage());
        this.saxEvents.add(err);
    }

    public void error(SAXParseException e) throws SAXException {
        int line = this.locator != null ? this.locator.getLineNumber() : 1;
        int col = this.locator != null ? this.locator.getColumnNumber() : 1;
        ScannerError err = new ScannerError(line, col, e.getMessage());
        this.saxEvents.add(err);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        int line = this.locator != null ? this.locator.getLineNumber() : 1;
        int col = this.locator != null ? this.locator.getColumnNumber() : 1;
        ScannerError err = new ScannerError(line, col, e.getMessage());
        this.saxEvents.add(err);
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            CustomAttributeClass = Class.forName(CUSTOM_ATTRIBUTES_CLASS, true, contextClassLoader);
        }
        catch (Exception ex) {
            ThreadLocalToolkit.log(new XMLTagAttributeLineNumber());
        }
        ResourceBundle rb = null;
        try {
            block9: {
                try {
                    rb = ResourceBundle.getBundle("org.apache.xerces.impl.msg.XMLMessages");
                    if (rb == null) break block9;
                    MarkupNotRecognizedInContent = rb.getString("MarkupNotRecognizedInContent");
                    ReservedPITarget = rb.getString("ReservedPITarget");
                    MarkupNotRecognizedInMisc = rb.getString("MarkupNotRecognizedInMisc");
                    ETagRequired = rb.getString("ETagRequired");
                }
                catch (Exception exception) {
                    Object var3_3 = null;
                    if (rb == null) {
                        MarkupNotRecognizedInContent = "The content of elements must consist of well-formed character data or markup.";
                        ReservedPITarget = "The processing instruction target matching \"[xX][mM][lL]\" is not allowed.";
                        MarkupNotRecognizedInMisc = "The markup in the document following the root element must be well-formed.";
                        ETagRequired = "The element type \"{0}\" must be terminated by the matching end-tag \"</{0}>\".";
                    }
                }
            }
            Object var3_2 = null;
            if (rb == null) {
                MarkupNotRecognizedInContent = "The content of elements must consist of well-formed character data or markup.";
                ReservedPITarget = "The processing instruction target matching \"[xX][mM][lL]\" is not allowed.";
                MarkupNotRecognizedInMisc = "The markup in the document following the root element must be well-formed.";
                ETagRequired = "The element type \"{0}\" must be terminated by the matching end-tag \"</{0}>\".";
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (rb == null) {
                MarkupNotRecognizedInContent = "The content of elements must consist of well-formed character data or markup.";
                ReservedPITarget = "The processing instruction target matching \"[xX][mM][lL]\" is not allowed.";
                MarkupNotRecognizedInMisc = "The markup in the document following the root element must be well-formed.";
                ETagRequired = "The element type \"{0}\" must be terminated by the matching end-tag \"</{0}>\".";
            }
            throw throwable;
        }
    }

    public static class UnexpectedEndOfSAXStream
    extends CompilerMessage.CompilerError {
        public final String reason;

        public UnexpectedEndOfSAXStream(String reason) {
            this.reason = reason;
        }
    }

    public static class UnexpectedEndOfTokenStream
    extends CompilerMessage.CompilerError {
        public final String token;

        public UnexpectedEndOfTokenStream(String token) {
            this.token = token;
        }
    }

    public static class XMLTagAttributeLineNumber
    extends CompilerMessage.CompilerWarning {
        public XMLTagAttributeLineNumber() {
            this.noPath();
        }
    }

    private class CDATAHandler
    implements LexicalHandler {
        boolean inCDATA = false;

        private CDATAHandler() {
        }

        public void startCDATA() throws SAXException {
            this.inCDATA = true;
        }

        public void endCDATA() throws SAXException {
            this.inCDATA = false;
        }

        public void startDTD(String s, String s1, String s2) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String s) throws SAXException {
        }

        public void endEntity(String s) throws SAXException {
        }

        public void comment(char[] chars, int i, int i1) throws SAXException {
        }
    }
}

