/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.pdf508;

import com.jaspersoft.ireport.designer.IReportManager;
import javax.swing.JMenu;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.openide.util.Mutex;

/**
 *
 * @author gtoffoli
 */
public class Pdf508TagMenuUtility extends javax.swing.JPanel {

    private JRDesignElement element = null;
    /** Creates new form NewJPanel */
    public Pdf508TagMenuUtility() {
        initComponents();
    }

    public JMenu getMenu()
    {
        return jMenu1;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jMenu1 = new javax.swing.JMenu();
        jMenuHeading = new javax.swing.JMenu();
        jMenuHeading1 = new javax.swing.JMenu();
        jRadioButtonMenuItemHeadingFull1 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingStart1 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingEnd1 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingNone1 = new javax.swing.JRadioButtonMenuItem();
        jMenuHeading2 = new javax.swing.JMenu();
        jRadioButtonMenuItemHeadingFull2 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingStart2 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingEnd2 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingNone2 = new javax.swing.JRadioButtonMenuItem();
        jMenuHeading3 = new javax.swing.JMenu();
        jRadioButtonMenuItemHeadingFull3 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingStart3 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingEnd3 = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemHeadingNone3 = new javax.swing.JRadioButtonMenuItem();
        jMenuTable = new javax.swing.JMenu();
        jRadioButtonMenuItemTableFull = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableStart = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableEnd = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableNone = new javax.swing.JRadioButtonMenuItem();
        jMenuTableRow = new javax.swing.JMenu();
        jRadioButtonMenuItemTableRowFull = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableRowStart = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableRowEnd = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableRowNone = new javax.swing.JRadioButtonMenuItem();
        jMenuTableHeader = new javax.swing.JMenu();
        jRadioButtonMenuItemTableHeaderFull = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableHeaderStart = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableHeaderEnd = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableHeaderNone = new javax.swing.JRadioButtonMenuItem();
        jMenuTableDetail = new javax.swing.JMenu();
        jRadioButtonMenuItemTableDetailFull = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableDetailStart = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableDetailEnd = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemTableDetailNone = new javax.swing.JRadioButtonMenuItem();
        buttonGroupHeading1 = new javax.swing.ButtonGroup();
        buttonGroupHeading2 = new javax.swing.ButtonGroup();
        buttonGroupHeading3 = new javax.swing.ButtonGroup();
        buttonGroupTable = new javax.swing.ButtonGroup();
        buttonGroupTableHeader = new javax.swing.ButtonGroup();
        buttonGroupTableDetail = new javax.swing.ButtonGroup();
        buttonGroupTableRow = new javax.swing.ButtonGroup();

        jMenu1.setText("PDF 508タグ");

        jMenuHeading.setText("ヘッディング");

        jMenuHeading1.setText("ヘッディング1");

        buttonGroupHeading1.add(jRadioButtonMenuItemHeadingFull1);
        jRadioButtonMenuItemHeadingFull1.setText("Full");
        jRadioButtonMenuItemHeadingFull1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingFull1ActionPerformed(evt);
            }
        });
        jMenuHeading1.add(jRadioButtonMenuItemHeadingFull1);

        buttonGroupHeading1.add(jRadioButtonMenuItemHeadingStart1);
        jRadioButtonMenuItemHeadingStart1.setText("開始");
        jRadioButtonMenuItemHeadingStart1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingStart1ActionPerformed(evt);
            }
        });
        jMenuHeading1.add(jRadioButtonMenuItemHeadingStart1);

        buttonGroupHeading1.add(jRadioButtonMenuItemHeadingEnd1);
        jRadioButtonMenuItemHeadingEnd1.setText("終了");
        jRadioButtonMenuItemHeadingEnd1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingEnd1ActionPerformed(evt);
            }
        });
        jMenuHeading1.add(jRadioButtonMenuItemHeadingEnd1);

        buttonGroupHeading1.add(jRadioButtonMenuItemHeadingNone1);
        jRadioButtonMenuItemHeadingNone1.setText("なし");
        jRadioButtonMenuItemHeadingNone1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingNone1ActionPerformed(evt);
            }
        });
        jMenuHeading1.add(jRadioButtonMenuItemHeadingNone1);

        jMenuHeading.add(jMenuHeading1);

        jMenuHeading2.setText("ヘッディング2");

        buttonGroupHeading2.add(jRadioButtonMenuItemHeadingFull2);
        jRadioButtonMenuItemHeadingFull2.setText("Full");
        jRadioButtonMenuItemHeadingFull2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingFull2ActionPerformed(evt);
            }
        });
        jMenuHeading2.add(jRadioButtonMenuItemHeadingFull2);

        buttonGroupHeading2.add(jRadioButtonMenuItemHeadingStart2);
        jRadioButtonMenuItemHeadingStart2.setText("開始");
        jRadioButtonMenuItemHeadingStart2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingStart2ActionPerformed(evt);
            }
        });
        jMenuHeading2.add(jRadioButtonMenuItemHeadingStart2);

        buttonGroupHeading2.add(jRadioButtonMenuItemHeadingEnd2);
        jRadioButtonMenuItemHeadingEnd2.setText("終了");
        jRadioButtonMenuItemHeadingEnd2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingEnd2ActionPerformed(evt);
            }
        });
        jMenuHeading2.add(jRadioButtonMenuItemHeadingEnd2);

        buttonGroupHeading2.add(jRadioButtonMenuItemHeadingNone2);
        jRadioButtonMenuItemHeadingNone2.setText("なし");
        jRadioButtonMenuItemHeadingNone2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingNone2ActionPerformed(evt);
            }
        });
        jMenuHeading2.add(jRadioButtonMenuItemHeadingNone2);

        jMenuHeading.add(jMenuHeading2);

        jMenuHeading3.setText("ヘッディング3");

        buttonGroupHeading3.add(jRadioButtonMenuItemHeadingFull3);
        jRadioButtonMenuItemHeadingFull3.setText("Full");
        jRadioButtonMenuItemHeadingFull3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingFull3ActionPerformed(evt);
            }
        });
        jMenuHeading3.add(jRadioButtonMenuItemHeadingFull3);

        buttonGroupHeading3.add(jRadioButtonMenuItemHeadingStart3);
        jRadioButtonMenuItemHeadingStart3.setText("開始");
        jRadioButtonMenuItemHeadingStart3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingStart3ActionPerformed(evt);
            }
        });
        jMenuHeading3.add(jRadioButtonMenuItemHeadingStart3);

        buttonGroupHeading3.add(jRadioButtonMenuItemHeadingEnd3);
        jRadioButtonMenuItemHeadingEnd3.setText("終了");
        jRadioButtonMenuItemHeadingEnd3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingEnd3ActionPerformed(evt);
            }
        });
        jMenuHeading3.add(jRadioButtonMenuItemHeadingEnd3);

        buttonGroupHeading3.add(jRadioButtonMenuItemHeadingNone3);
        jRadioButtonMenuItemHeadingNone3.setText("なし");
        jRadioButtonMenuItemHeadingNone3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemHeadingNone3ActionPerformed(evt);
            }
        });
        jMenuHeading3.add(jRadioButtonMenuItemHeadingNone3);

        jMenuHeading.add(jMenuHeading3);

        jMenu1.add(jMenuHeading);

        jMenuTable.setText("テーブル");

        buttonGroupTable.add(jRadioButtonMenuItemTableFull);
        jRadioButtonMenuItemTableFull.setText("Full");
        jRadioButtonMenuItemTableFull.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableFullActionPerformed(evt);
            }
        });
        jMenuTable.add(jRadioButtonMenuItemTableFull);

        buttonGroupTable.add(jRadioButtonMenuItemTableStart);
        jRadioButtonMenuItemTableStart.setText("開始");
        jRadioButtonMenuItemTableStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableStartActionPerformed(evt);
            }
        });
        jMenuTable.add(jRadioButtonMenuItemTableStart);

        buttonGroupTable.add(jRadioButtonMenuItemTableEnd);
        jRadioButtonMenuItemTableEnd.setText("終了");
        jRadioButtonMenuItemTableEnd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableEndActionPerformed(evt);
            }
        });
        jMenuTable.add(jRadioButtonMenuItemTableEnd);

        buttonGroupTable.add(jRadioButtonMenuItemTableNone);
        jRadioButtonMenuItemTableNone.setText("なし");
        jRadioButtonMenuItemTableNone.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableNoneActionPerformed(evt);
            }
        });
        jMenuTable.add(jRadioButtonMenuItemTableNone);

        jMenu1.add(jMenuTable);

        jMenuTableRow.setText("テーブル行");

        buttonGroupTableRow.add(jRadioButtonMenuItemTableRowFull);
        jRadioButtonMenuItemTableRowFull.setText("完全");
        jRadioButtonMenuItemTableRowFull.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableRowFullActionPerformed(evt);
            }
        });
        jMenuTableRow.add(jRadioButtonMenuItemTableRowFull);

        buttonGroupTableRow.add(jRadioButtonMenuItemTableRowStart);
        jRadioButtonMenuItemTableRowStart.setText("開始");
        jRadioButtonMenuItemTableRowStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableRowStartActionPerformed(evt);
            }
        });
        jMenuTableRow.add(jRadioButtonMenuItemTableRowStart);

        buttonGroupTableRow.add(jRadioButtonMenuItemTableRowEnd);
        jRadioButtonMenuItemTableRowEnd.setText("終了");
        jRadioButtonMenuItemTableRowEnd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableRowEndActionPerformed(evt);
            }
        });
        jMenuTableRow.add(jRadioButtonMenuItemTableRowEnd);

        buttonGroupTableRow.add(jRadioButtonMenuItemTableRowNone);
        jRadioButtonMenuItemTableRowNone.setText("なし");
        jRadioButtonMenuItemTableRowNone.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableRowNoneActionPerformed(evt);
            }
        });
        jMenuTableRow.add(jRadioButtonMenuItemTableRowNone);

        jMenu1.add(jMenuTableRow);

        jMenuTableHeader.setText("テーブルヘッダ");

        buttonGroupTableHeader.add(jRadioButtonMenuItemTableHeaderFull);
        jRadioButtonMenuItemTableHeaderFull.setText("Full");
        jRadioButtonMenuItemTableHeaderFull.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableHeaderFullActionPerformed(evt);
            }
        });
        jMenuTableHeader.add(jRadioButtonMenuItemTableHeaderFull);

        buttonGroupTableHeader.add(jRadioButtonMenuItemTableHeaderStart);
        jRadioButtonMenuItemTableHeaderStart.setText("開始");
        jRadioButtonMenuItemTableHeaderStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableHeaderStartActionPerformed(evt);
            }
        });
        jMenuTableHeader.add(jRadioButtonMenuItemTableHeaderStart);

        buttonGroupTableHeader.add(jRadioButtonMenuItemTableHeaderEnd);
        jRadioButtonMenuItemTableHeaderEnd.setText("終了");
        jRadioButtonMenuItemTableHeaderEnd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableHeaderEndActionPerformed(evt);
            }
        });
        jMenuTableHeader.add(jRadioButtonMenuItemTableHeaderEnd);

        buttonGroupTableHeader.add(jRadioButtonMenuItemTableHeaderNone);
        jRadioButtonMenuItemTableHeaderNone.setSelected(true);
        jRadioButtonMenuItemTableHeaderNone.setText("なし");
        jRadioButtonMenuItemTableHeaderNone.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableHeaderNoneActionPerformed(evt);
            }
        });
        jMenuTableHeader.add(jRadioButtonMenuItemTableHeaderNone);

        jMenu1.add(jMenuTableHeader);

        jMenuTableDetail.setText("テーブル詳細");

        buttonGroupTableDetail.add(jRadioButtonMenuItemTableDetailFull);
        jRadioButtonMenuItemTableDetailFull.setText("Full");
        jRadioButtonMenuItemTableDetailFull.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableDetailFullActionPerformed(evt);
            }
        });
        jMenuTableDetail.add(jRadioButtonMenuItemTableDetailFull);

        buttonGroupTableDetail.add(jRadioButtonMenuItemTableDetailStart);
        jRadioButtonMenuItemTableDetailStart.setText("開始");
        jRadioButtonMenuItemTableDetailStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableDetailStartActionPerformed(evt);
            }
        });
        jMenuTableDetail.add(jRadioButtonMenuItemTableDetailStart);

        buttonGroupTableDetail.add(jRadioButtonMenuItemTableDetailEnd);
        jRadioButtonMenuItemTableDetailEnd.setText("終了");
        jRadioButtonMenuItemTableDetailEnd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableDetailEndActionPerformed(evt);
            }
        });
        jMenuTableDetail.add(jRadioButtonMenuItemTableDetailEnd);

        buttonGroupTableDetail.add(jRadioButtonMenuItemTableDetailNone);
        jRadioButtonMenuItemTableDetailNone.setText("なし");
        jRadioButtonMenuItemTableDetailNone.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemTableDetailNoneActionPerformed(evt);
            }
        });
        jMenuTableDetail.add(jRadioButtonMenuItemTableDetailNone);

        jMenu1.add(jMenuTableDetail);

        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents

    private void jRadioButtonMenuItemHeadingFull1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingFull1ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h1","full");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingFull1ActionPerformed

    private void jRadioButtonMenuItemHeadingStart1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingStart1ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h1","start");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingStart1ActionPerformed

    private void jRadioButtonMenuItemHeadingEnd1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingEnd1ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h1","end");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingEnd1ActionPerformed

    private void jRadioButtonMenuItemHeadingNone1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingNone1ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h1",null);
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingNone1ActionPerformed

    private void jRadioButtonMenuItemHeadingFull2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingFull2ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h2","full");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingFull2ActionPerformed

    private void jRadioButtonMenuItemHeadingStart2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingStart2ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h2","start");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingStart2ActionPerformed

    private void jRadioButtonMenuItemHeadingEnd2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingEnd2ActionPerformed
       setPropertyValue("net.sf.jasperreports.export.pdf.tag.h2","end");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingEnd2ActionPerformed

    private void jRadioButtonMenuItemHeadingNone2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingNone2ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h2",null);
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingNone2ActionPerformed

    private void jRadioButtonMenuItemHeadingFull3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingFull3ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h3","full");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingFull3ActionPerformed

    private void jRadioButtonMenuItemHeadingStart3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingStart3ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h3","start");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingStart3ActionPerformed

    private void jRadioButtonMenuItemHeadingEnd3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingEnd3ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h3","end");
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingEnd3ActionPerformed

    private void jRadioButtonMenuItemHeadingNone3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemHeadingNone3ActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.h3",null);
    }//GEN-LAST:event_jRadioButtonMenuItemHeadingNone3ActionPerformed

    private void jRadioButtonMenuItemTableFullActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableFullActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.table","full");
}//GEN-LAST:event_jRadioButtonMenuItemTableFullActionPerformed

    private void jRadioButtonMenuItemTableStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableStartActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.table","start");
}//GEN-LAST:event_jRadioButtonMenuItemTableStartActionPerformed

    private void jRadioButtonMenuItemTableEndActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableEndActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.table","end");
}//GEN-LAST:event_jRadioButtonMenuItemTableEndActionPerformed

    private void jRadioButtonMenuItemTableNoneActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableNoneActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.table",null);
}//GEN-LAST:event_jRadioButtonMenuItemTableNoneActionPerformed

    private void jRadioButtonMenuItemTableHeaderFullActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableHeaderFullActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.th","full");
}//GEN-LAST:event_jRadioButtonMenuItemTableHeaderFullActionPerformed

    private void jRadioButtonMenuItemTableHeaderStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableHeaderStartActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.th","start");
}//GEN-LAST:event_jRadioButtonMenuItemTableHeaderStartActionPerformed

    private void jRadioButtonMenuItemTableHeaderEndActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableHeaderEndActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.th","end");
}//GEN-LAST:event_jRadioButtonMenuItemTableHeaderEndActionPerformed

    private void jRadioButtonMenuItemTableHeaderNoneActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableHeaderNoneActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.th",null);
}//GEN-LAST:event_jRadioButtonMenuItemTableHeaderNoneActionPerformed

    private void jRadioButtonMenuItemTableDetailFullActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableDetailFullActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.td","full");
}//GEN-LAST:event_jRadioButtonMenuItemTableDetailFullActionPerformed

    private void jRadioButtonMenuItemTableDetailStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableDetailStartActionPerformed
       setPropertyValue("net.sf.jasperreports.export.pdf.tag.td","start");
}//GEN-LAST:event_jRadioButtonMenuItemTableDetailStartActionPerformed

    private void jRadioButtonMenuItemTableDetailEndActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableDetailEndActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.td","end");
}//GEN-LAST:event_jRadioButtonMenuItemTableDetailEndActionPerformed

    private void jRadioButtonMenuItemTableDetailNoneActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableDetailNoneActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.td",null);
}//GEN-LAST:event_jRadioButtonMenuItemTableDetailNoneActionPerformed

    private void jRadioButtonMenuItemTableRowFullActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableRowFullActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.tr","full");
}//GEN-LAST:event_jRadioButtonMenuItemTableRowFullActionPerformed

    private void jRadioButtonMenuItemTableRowStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableRowStartActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.tr","start");
}//GEN-LAST:event_jRadioButtonMenuItemTableRowStartActionPerformed

    private void jRadioButtonMenuItemTableRowEndActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableRowEndActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.tr","end");
}//GEN-LAST:event_jRadioButtonMenuItemTableRowEndActionPerformed

    private void jRadioButtonMenuItemTableRowNoneActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemTableRowNoneActionPerformed
        setPropertyValue("net.sf.jasperreports.export.pdf.tag.tr",null);
}//GEN-LAST:event_jRadioButtonMenuItemTableRowNoneActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupHeading1;
    private javax.swing.ButtonGroup buttonGroupHeading2;
    private javax.swing.ButtonGroup buttonGroupHeading3;
    private javax.swing.ButtonGroup buttonGroupTable;
    private javax.swing.ButtonGroup buttonGroupTableDetail;
    private javax.swing.ButtonGroup buttonGroupTableHeader;
    private javax.swing.ButtonGroup buttonGroupTableRow;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenuHeading;
    private javax.swing.JMenu jMenuHeading1;
    private javax.swing.JMenu jMenuHeading2;
    private javax.swing.JMenu jMenuHeading3;
    private javax.swing.JMenu jMenuTable;
    private javax.swing.JMenu jMenuTableDetail;
    private javax.swing.JMenu jMenuTableHeader;
    private javax.swing.JMenu jMenuTableRow;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingEnd1;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingEnd2;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingEnd3;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingFull1;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingFull2;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingFull3;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingNone1;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingNone2;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingNone3;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingStart1;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingStart2;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemHeadingStart3;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableDetailEnd;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableDetailFull;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableDetailNone;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableDetailStart;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableEnd;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableFull;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableHeaderEnd;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableHeaderFull;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableHeaderNone;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableHeaderStart;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableNone;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableRowEnd;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableRowFull;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableRowNone;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableRowStart;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemTableStart;
    // End of variables declaration//GEN-END:variables

    private void setPropertyValue(String propName, String val) {
        setPropertyValue(getElement(), propName, val);
    }

    private String getPropertyValue(String propName) {
        return getPropertyValue(getElement(), propName);
    }


    public static void setPropertyValue(JRDesignElement element, String propName, String val) {
        if (element != null)
        {
            element.getPropertiesMap().setProperty(propName, val);
            Mutex.EVENT.readAccess(new Runnable() {

                public void run() {
                    IReportManager.getInstance().notifyReportChange();
                    if (IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getActiveScene() != null)
                    {
                        IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getActiveScene().repaint();
                    }
                }
            });
        }
    }

    public static String getPropertyValue(JRDesignElement element, String propName) {
        String val =  "";
        if (element != null)
        {
            val = element.getPropertiesMap().getProperty(propName);
            if (val == null) val ="";
        }
        return val;
    }

    /**
     * @return the element
     */
    public

    JRDesignElement getElement() {
        return element;
    }

    /**
     * @param element the element to set
     */
    public void setElement(JRDesignElement element) {
        this.element = element;
        // Update the menu status...
        String val = getPropertyValue("net.sf.jasperreports.export.pdf.tag.h1");
        jRadioButtonMenuItemHeadingNone1.setSelected(val.equals(""));
        jRadioButtonMenuItemHeadingFull1.setSelected(val.equals("full"));
        jRadioButtonMenuItemHeadingStart1.setSelected(val.equals("start"));
        jRadioButtonMenuItemHeadingEnd1.setSelected(val.equals("end"));

        val = getPropertyValue("net.sf.jasperreports.export.pdf.tag.h2");
        jRadioButtonMenuItemHeadingNone2.setSelected(val.equals(""));
        jRadioButtonMenuItemHeadingFull2.setSelected(val.equals("full"));
        jRadioButtonMenuItemHeadingStart2.setSelected(val.equals("start"));
        jRadioButtonMenuItemHeadingEnd2.setSelected(val.equals("end"));

        val = getPropertyValue("net.sf.jasperreports.export.pdf.tag.h3");
        jRadioButtonMenuItemHeadingNone3.setSelected(val.equals(""));
        jRadioButtonMenuItemHeadingFull3.setSelected(val.equals("full"));
        jRadioButtonMenuItemHeadingStart3.setSelected(val.equals("start"));
        jRadioButtonMenuItemHeadingEnd3.setSelected(val.equals("end"));

        val = getPropertyValue("net.sf.jasperreports.export.pdf.tag.table");
        jRadioButtonMenuItemTableNone.setSelected(val.equals(""));
        jRadioButtonMenuItemTableFull.setSelected(val.equals("full"));
        jRadioButtonMenuItemTableStart.setSelected(val.equals("start"));
        jRadioButtonMenuItemTableEnd.setSelected(val.equals("end"));

        val = getPropertyValue("net.sf.jasperreports.export.pdf.tag.tr");
        jRadioButtonMenuItemTableRowNone.setSelected(val.equals(""));
        jRadioButtonMenuItemTableRowFull.setSelected(val.equals("full"));
        jRadioButtonMenuItemTableRowStart.setSelected(val.equals("start"));
        jRadioButtonMenuItemTableRowEnd.setSelected(val.equals("end"));

        val = getPropertyValue("net.sf.jasperreports.export.pdf.tag.th");
        jRadioButtonMenuItemTableHeaderNone.setSelected(val.equals(""));
        jRadioButtonMenuItemTableHeaderFull.setSelected(val.equals("full"));
        jRadioButtonMenuItemTableHeaderStart.setSelected(val.equals("start"));
        jRadioButtonMenuItemTableHeaderEnd.setSelected(val.equals("end"));

        val = getPropertyValue("net.sf.jasperreports.export.pdf.tag.td");
        jRadioButtonMenuItemTableDetailNone.setSelected(val.equals(""));
        jRadioButtonMenuItemTableDetailFull.setSelected(val.equals("full"));
        jRadioButtonMenuItemTableDetailStart.setSelected(val.equals("start"));
        jRadioButtonMenuItemTableDetailEnd.setSelected(val.equals("end"));
    }


}
