/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ReportNode;
import com.jaspersoft.ireport.designer.undo.AddDatasetUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.DatasetWizardIterator;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class AddDatasetAction
extends NodeAction {
    private static AddDatasetAction instance = null;

    public static synchronized AddDatasetAction getInstance() {
        if (instance == null) {
            instance = new AddDatasetAction();
        }
        return instance;
    }

    private AddDatasetAction() {
    }

    public String getName() {
        return I18n.getString("AddDatasetAction.Name.CTL_AddDatasetAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length > 0 && activatedNodes[0] instanceof ReportNode) {
            try {
                boolean cancelled;
                ReportNode node = (ReportNode)activatedNodes[0];
                DatasetWizardIterator iterator = new DatasetWizardIterator();
                WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
                iterator.initialize(wizardDescriptor, node.getJasperDesign());
                wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
                wizardDescriptor.setTitle("New Dataset");
                Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
                dialog.setVisible(true);
                dialog.toFront();
                boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
                if (!cancelled) {
                    JRDesignDataset newDataset = new JRDesignDataset(false);
                    newDataset.setName((String)wizardDescriptor.getProperty("dataset_name"));
                    ArrayList selectedFields = (ArrayList)wizardDescriptor.getProperty("selectedFields");
                    ArrayList groupFields = (ArrayList)wizardDescriptor.getProperty("groupFields");
                    String query = (String)wizardDescriptor.getProperty("query");
                    String queryLanguage = (String)wizardDescriptor.getProperty("queryLanguage");
                    if (selectedFields == null) {
                        selectedFields = new ArrayList();
                    }
                    if (groupFields == null) {
                        groupFields = new ArrayList();
                    }
                    for (JRDesignField f : selectedFields) {
                        newDataset.addField((JRField)f);
                    }
                    if (query != null) {
                        JRDesignQuery designQuery = new JRDesignQuery();
                        designQuery.setText(query);
                        if (queryLanguage != null) {
                            designQuery.setLanguage(queryLanguage);
                        }
                        newDataset.setQuery(designQuery);
                    }
                    for (int i = 0; i < groupFields.size(); ++i) {
                        JRDesignGroup g = new JRDesignGroup();
                        g.setName(((JRDesignField)groupFields.get(i)).getName());
                        g.setExpression((JRExpression)Misc.createExpression(((JRDesignField)groupFields.get(i)).getValueClassName(), "$F{" + ((JRDesignField)groupFields.get(i)).getName() + "}"));
                        newDataset.addGroup(g);
                    }
                    node.getJasperDesign().addDataset(newDataset);
                    AddDatasetUndoableEdit edit = new AddDatasetUndoableEdit(newDataset, node.getJasperDesign());
                    IReportManager.getInstance().addUndoableEdit(edit);
                }
            }
            catch (JRException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        return activatedNodes.length > 0 && activatedNodes[0] instanceof ReportNode;
    }
}

