/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.CustomHTTPAuthenticator;
import com.jaspersoft.ireport.designer.connection.JRXMLADataSourceConnection;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import rex.graphics.datasourcetree.elements.CatalogElement;
import rex.graphics.datasourcetree.elements.CubeElement;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.metadata.ServerMetadata;

public class XMLADataSourceConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private JButton jButtonGetXMLAMetadata;
    private JCheckBox jCheckBoxSavePassword1;
    private JComboBox jComboBoxXMLACatalog;
    private JComboBox jComboBoxXMLACube;
    private JComboBox jComboBoxXMLADatasource;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabelAttention;
    private JLabel jLabelXMLACatalog;
    private JLabel jLabelXMLACube;
    private JLabel jLabelXMLADatasource;
    private JLabel jLabelXMLAUrl;
    private JPanel jPanel16;
    private JPanel jPanelXMLA;
    private JSeparator jSeparator10;
    private JSeparator jSeparator8;
    private JPasswordField jTextFieldPassword1;
    private JTextField jTextFieldUsername1;
    private JTextField jTextFieldXMLAUrl;
    jComboBoxCatListener catListener = new jComboBoxCatListener();
    jComboBoxdsListener dsListener = new jComboBoxdsListener();

    public XMLADataSourceConnectionEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanelXMLA = new JPanel();
        this.jLabelXMLAUrl = new JLabel();
        this.jTextFieldXMLAUrl = new JTextField();
        this.jButtonGetXMLAMetadata = new JButton();
        this.jLabelXMLADatasource = new JLabel();
        this.jComboBoxXMLADatasource = new JComboBox();
        this.jLabelXMLACatalog = new JLabel();
        this.jComboBoxXMLACatalog = new JComboBox();
        this.jSeparator8 = new JSeparator();
        this.jLabelXMLACube = new JLabel();
        this.jComboBoxXMLACube = new JComboBox();
        this.jSeparator10 = new JSeparator();
        this.jPanel16 = new JPanel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jTextFieldUsername1 = new JTextField();
        this.jTextFieldPassword1 = new JPasswordField();
        this.jCheckBoxSavePassword1 = new JCheckBox();
        this.jLabelAttention = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanelXMLA.setLayout(new GridBagLayout());
        this.jLabelXMLAUrl.setText(I18n.getString("XMLADataSourceConnectionEditor.Label.UrlXML"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelXMLA.add((Component)this.jLabelXMLAUrl, gridBagConstraints);
        this.jTextFieldXMLAUrl.setText("http://localhost:8080/mondrian/xmla");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jTextFieldXMLAUrl, gridBagConstraints);
        this.jButtonGetXMLAMetadata.setText(I18n.getString("XMLADataSourceConnectionEditor.Button.Get_metadata"));
        this.jButtonGetXMLAMetadata.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLADataSourceConnectionEditor.this.jButtonGetXMLAMetadataActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jButtonGetXMLAMetadata, gridBagConstraints);
        this.jLabelXMLADatasource.setText(I18n.getString("XMLADataSourceConnectionEditor.Label.Datasource"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelXMLA.add((Component)this.jLabelXMLADatasource, gridBagConstraints);
        this.jComboBoxXMLADatasource.setMinimumSize(new Dimension(23, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jComboBoxXMLADatasource, gridBagConstraints);
        this.jLabelXMLACatalog.setText(I18n.getString("XMLADataSourceConnectionEditor.Label.Catalog"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelXMLA.add((Component)this.jLabelXMLACatalog, gridBagConstraints);
        this.jComboBoxXMLACatalog.setMinimumSize(new Dimension(23, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jComboBoxXMLACatalog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jSeparator8, gridBagConstraints);
        this.jLabelXMLACube.setText(I18n.getString("XMLADataSourceConnectionEditor.Label.Cube"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelXMLA.add((Component)this.jLabelXMLACube, gridBagConstraints);
        this.jComboBoxXMLACube.setMinimumSize(new Dimension(23, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jComboBoxXMLACube, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jSeparator10, gridBagConstraints);
        this.jPanel16.setLayout(new GridBagLayout());
        this.jLabel26.setText(I18n.getString("Global.Label.Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel16.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setText(I18n.getString("Global.Label.Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel16.add((Component)this.jLabel27, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel16.add((Component)this.jTextFieldUsername1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel16.add((Component)this.jTextFieldPassword1, gridBagConstraints);
        this.jCheckBoxSavePassword1.setText(I18n.getString("Global.CheckBox.Save_password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanel16.add((Component)this.jCheckBoxSavePassword1, gridBagConstraints);
        this.jLabelAttention.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/connection/gui/warning.png")));
        this.jLabelAttention.setText(I18n.getString("XMLADataSourceConnectionEditor.Label.Warning"));
        this.jLabelAttention.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel16.add((Component)this.jLabelAttention, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelXMLA.add((Component)this.jPanel16, gridBagConstraints);
        this.add((Component)this.jPanelXMLA, "North");
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JRXMLADataSourceConnection) {
            JRXMLADataSourceConnection con = (JRXMLADataSourceConnection)this.iReportConnection;
            this.jTextFieldXMLAUrl.setText(con.getUrl());
            this.jComboBoxXMLADatasource.removeAllItems();
            this.jComboBoxXMLADatasource.addItem(con.getDatasource());
            this.jComboBoxXMLACatalog.removeAllItems();
            this.jComboBoxXMLACatalog.addItem(con.getCatalog());
            this.jComboBoxXMLACube.removeAllItems();
            this.jComboBoxXMLACube.addItem(con.getCube());
            this.jTextFieldUsername1.setText(con.getUsername());
            if (con.isSavePassword()) {
                this.jTextFieldPassword1.setText(con.getPassword());
            } else {
                this.jTextFieldPassword1.setText("");
            }
            this.jCheckBoxSavePassword1.setSelected(con.isSavePassword());
        }
    }

    public IReportConnection getIReportConnection() {
        JRXMLADataSourceConnection irConn = new JRXMLADataSourceConnection();
        if (this.jTextFieldXMLAUrl.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Label.Url"), I18n.getString("XMLADataSourceConnectionEditor.Label.InvalidProperty"), 2);
            return null;
        }
        irConn.setUrl(this.jTextFieldXMLAUrl.getText().trim());
        if (this.jComboBoxXMLADatasource.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Label.Datasource"), I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"), 2);
            return null;
        }
        irConn.setDatasource(((String)this.jComboBoxXMLADatasource.getSelectedItem()).trim());
        if (this.jComboBoxXMLACatalog.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.Catalog"), I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"), 2);
            return null;
        }
        irConn.setCatalog(((String)this.jComboBoxXMLACatalog.getSelectedItem()).trim());
        if (this.jComboBoxXMLACube.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.Cube"), I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"), 2);
            return null;
        }
        irConn.setCube(((String)this.jComboBoxXMLACube.getSelectedItem()).trim());
        irConn.setUsername(this.jTextFieldUsername1.getText().trim());
        if (this.jCheckBoxSavePassword1.isSelected()) {
            irConn.setPassword(new String(this.jTextFieldPassword1.getPassword()));
        } else {
            irConn.setPassword("");
        }
        irConn.setSavePassword(this.jCheckBoxSavePassword1.isSelected());
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }

    private void jComboBoxDatasourceActionPerformed(ActionEvent evt) {
        this.jComboBoxXMLACatalog.removeActionListener(this.catListener);
        if (this.jComboBoxXMLADatasource.getItemCount() == 0 || this.jComboBoxXMLADatasource.getSelectedIndex() == -1) {
            return;
        }
        String urlstr = this.jTextFieldXMLAUrl.getText().trim();
        ServerMetadata smd = new ServerMetadata(urlstr, (Component)this);
        if (!smd.isValidUrl()) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoXMLA"), "", 1);
            return;
        }
        this.jComboBoxXMLACatalog.removeAllItems();
        this.jComboBoxXMLACube.removeAllItems();
        DataSourceTreeElement[] dste = smd.discoverDataSources();
        if (dste == null || dste.length == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoDatasources"), "", 1);
            return;
        }
        boolean found = false;
        int intI = 0;
        while (!found && intI < dste.length) {
            if (dste[intI].getDataSourceInfo().compareTo((String)this.jComboBoxXMLADatasource.getSelectedItem()) == 0) {
                found = true;
                continue;
            }
            ++intI;
        }
        if (!found) {
            return;
        }
        DataSourceTreeElement[] catalogs = dste[intI].getChildren();
        if (catalogs == null || catalogs.length == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoCatalogs"), "", 1);
            return;
        }
        this.jComboBoxXMLACatalog.removeAllItems();
        for (intI = 0; intI < catalogs.length; ++intI) {
            this.jComboBoxXMLACatalog.addItem(((CatalogElement)catalogs[intI]).toString());
        }
        found = false;
        intI = 0;
        while (!found && intI < catalogs.length) {
            if (catalogs[intI].toString().trim().compareTo((String)this.jComboBoxXMLACatalog.getSelectedItem()) == 0) {
                found = true;
                continue;
            }
            ++intI;
        }
        if (!found) {
            return;
        }
        DataSourceTreeElement[] cubes = catalogs[intI].getChildren();
        if (cubes == null || cubes.length == 0) {
            return;
        }
        this.jComboBoxXMLACube.removeAllItems();
        for (intI = 0; intI < cubes.length; ++intI) {
            this.jComboBoxXMLACube.addItem(((CubeElement)cubes[intI]).toString());
        }
        this.jComboBoxXMLACatalog.addActionListener(this.catListener);
    }

    private void jComboBoxCatActionPerformed(ActionEvent evt) {
        this.jComboBoxXMLADatasource.removeActionListener(this.dsListener);
        if (this.jComboBoxXMLACatalog.getItemCount() == 0 || this.jComboBoxXMLACatalog.getSelectedIndex() == -1) {
            return;
        }
        String urlstr = this.jTextFieldXMLAUrl.getText().trim();
        ServerMetadata smd = new ServerMetadata(urlstr, (Component)this);
        if (!smd.isValidUrl()) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoXMLA"), "", 1);
            return;
        }
        this.jComboBoxXMLACube.removeAllItems();
        DataSourceTreeElement[] dste = smd.discoverDataSources();
        if (dste == null || dste.length == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoDatasources"), "", 1);
            return;
        }
        boolean found = false;
        int intI = 0;
        while (!found && intI < dste.length) {
            if (dste[intI].getDataSourceInfo().compareTo((String)this.jComboBoxXMLADatasource.getSelectedItem()) == 0) {
                found = true;
                continue;
            }
            ++intI;
        }
        if (!found) {
            return;
        }
        DataSourceTreeElement[] catalogs = dste[intI].getChildren();
        if (catalogs == null || catalogs.length == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoCatalogs"), "", 1);
            return;
        }
        this.jComboBoxXMLACatalog.removeAllItems();
        for (intI = 0; intI < catalogs.length; ++intI) {
            this.jComboBoxXMLACatalog.addItem(((CatalogElement)catalogs[intI]).toString());
        }
        found = false;
        intI = 0;
        while (!found && intI < catalogs.length) {
            if (catalogs[intI].toString().compareTo((String)this.jComboBoxXMLACatalog.getSelectedItem()) == 0) {
                found = true;
                continue;
            }
            ++intI;
            found = false;
        }
        if (!found) {
            return;
        }
        DataSourceTreeElement[] cubes = catalogs[intI].getChildren();
        if (cubes == null || cubes.length == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoCubes"), "", 1);
            return;
        }
        this.jComboBoxXMLACube.removeAllItems();
        for (intI = 0; intI < cubes.length; ++intI) {
            this.jComboBoxXMLACube.addItem(((CubeElement)cubes[intI]).toString());
        }
        this.jComboBoxXMLADatasource.addActionListener(this.dsListener);
    }

    private void jButtonGetXMLAMetadataActionPerformed(ActionEvent evt) {
        this.jComboBoxXMLADatasource.removeActionListener(this.dsListener);
        this.jComboBoxXMLACatalog.removeActionListener(this.catListener);
        String urlstr = this.jTextFieldXMLAUrl.getText().trim();
        Authenticator.setDefault(new CustomHTTPAuthenticator(this.jTextFieldUsername1.getText(), new String(this.jTextFieldPassword1.getPassword())));
        ServerMetadata smd = new ServerMetadata(urlstr, (Component)this);
        if (!smd.isValidUrl()) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoXMLA"), "", 1);
            return;
        }
        this.jComboBoxXMLADatasource.removeAllItems();
        this.jComboBoxXMLACatalog.removeAllItems();
        this.jComboBoxXMLACube.removeAllItems();
        DataSourceTreeElement[] dste = smd.discoverDataSources();
        if (dste == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoDatasources"), "", 1);
            return;
        }
        for (int i = 0; i < dste.length; ++i) {
            this.jComboBoxXMLADatasource.addItem(dste[i].getDataSourceInfo());
        }
        DataSourceTreeElement[] catalogs = dste[0].getChildren();
        if (catalogs == null || catalogs.length == 0) {
            return;
        }
        this.jComboBoxXMLACatalog.removeAllItems();
        for (int i = 0; i < catalogs.length; ++i) {
            this.jComboBoxXMLACatalog.addItem(((CatalogElement)catalogs[i]).toString());
        }
        DataSourceTreeElement[] cubes = catalogs[0].getChildren();
        if (cubes == null || cubes.length == 0) {
            return;
        }
        this.jComboBoxXMLACube.removeAllItems();
        for (int i = 0; i < cubes.length; ++i) {
            this.jComboBoxXMLACube.addItem(((CubeElement)cubes[i]).toString());
        }
        this.jComboBoxXMLADatasource.addActionListener(this.dsListener);
        this.jComboBoxXMLACatalog.addActionListener(this.catListener);
    }

    private class jComboBoxdsListener
    implements ActionListener {
        private jComboBoxdsListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            XMLADataSourceConnectionEditor.this.jComboBoxDatasourceActionPerformed(evt);
        }
    }

    private class jComboBoxCatListener
    implements ActionListener {
        private jComboBoxCatListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            XMLADataSourceConnectionEditor.this.jComboBoxCatActionPerformed(evt);
        }
    }
}

