/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml;

import java.io.IOException;
import org.netbeans.modules.xml.XMLDataObjectLook;
import org.netbeans.modules.xml.cookies.DataObjectCookieManager;
import org.netbeans.modules.xml.sync.EntitySyncSupport;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.netbeans.modules.xml.text.TextEditorSupport;
import org.netbeans.modules.xml.util.Util;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.actions.EditAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.xml.sax.InputSource;

public final class EntityDataObject
extends MultiDataObject
implements XMLDataObjectLook {
    private static final long serialVersionUID = 2909112365229995364L;
    public static final String MIME_TYPE = "text/xml-external-parsed-entity";
    private transient Synchronizator synchronizator;
    private final transient DataObjectCookieManager cookieManager;

    public EntityDataObject(FileObject fileObject, UniFileLoader uniFileLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)uniFileLoader);
        CookieSet cookieSet = this.getCookieSet();
        this.cookieManager = new DataObjectCookieManager((DataObject)this, cookieSet);
        cookieSet.add((Node.Cookie)this.cookieManager);
        final TextEditorSupport.TextEditorSupportFactory textEditorSupportFactory = new TextEditorSupport.TextEditorSupportFactory(this, MIME_TYPE);
        textEditorSupportFactory.registerCookies(cookieSet);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        cookieSet.add((Node.Cookie)new CheckXMLSupport(inputSource, 1));
        cookieSet.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                textEditorSupportFactory.createEditor().saveAs(fileObject, string);
            }
        }});
    }

    public final Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    protected Node createNodeDelegate() {
        return new EntityDataNode(this);
    }

    public synchronized Synchronizator getSyncInterface() {
        if (this.synchronizator == null) {
            this.synchronizator = new EntitySyncSupport(this);
        }
        return this.synchronizator;
    }

    public DataObjectCookieManager getCookieManager() {
        return this.cookieManager;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static class EntityDataNode
    extends DataNode {
        public EntityDataNode(EntityDataObject entityDataObject) {
            super((DataObject)entityDataObject, Children.LEAF);
            this.setDefaultAction(SystemAction.get(EditAction.class));
            this.setIconBase("org/netbeans/modules/xml/resources/entObject");
            this.setShortDescription(Util.THIS.getString(EntityDataObject.class, "PROP_EntityDataNode_desc"));
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }
}

