/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.server.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.server.properties.InstanceProperties;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstancePropertiesManager {
    private static final Logger LOGGER = Logger.getLogger(InstancePropertiesManager.class.getName());
    private static InstancePropertiesManager manager;
    private final Map<Preferences, InstanceProperties> cache = new WeakHashMap<Preferences, InstanceProperties>();
    private final Random random = new Random();

    private InstancePropertiesManager() {
    }

    public static synchronized InstancePropertiesManager getInstance() {
        if (manager == null) {
            manager = new InstancePropertiesManager();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceProperties createProperties(String string) {
        Preferences preferences = NbPreferences.forModule(InstancePropertiesManager.class);
        try {
            preferences = preferences.node(string);
            boolean bl = true;
            String string2 = null;
            InstancePropertiesManager instancePropertiesManager = this;
            synchronized (instancePropertiesManager) {
                while (bl) {
                    string2 = Integer.toString(this.random.nextInt(Integer.MAX_VALUE));
                    bl = preferences.nodeExists(string2);
                }
                preferences = preferences.node(string2);
                preferences.flush();
                DefaultInstanceProperties defaultInstanceProperties = new DefaultInstanceProperties(string2, this, preferences);
                this.cache.put(preferences, defaultInstanceProperties);
                return defaultInstanceProperties;
            }
        }
        catch (BackingStoreException backingStoreException) {
            LOGGER.log(Level.INFO, null, backingStoreException);
            throw new IllegalStateException(backingStoreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InstanceProperties> getProperties(String string) {
        Preferences preferences = NbPreferences.forModule(InstancePropertiesManager.class);
        try {
            preferences = preferences.node(string);
            preferences.flush();
            ArrayList<InstanceProperties> arrayList = new ArrayList<InstanceProperties>();
            InstancePropertiesManager instancePropertiesManager = this;
            synchronized (instancePropertiesManager) {
                for (String string2 : preferences.childrenNames()) {
                    Preferences preferences2 = preferences.node(string2);
                    InstanceProperties instanceProperties = this.cache.get(preferences2);
                    if (instanceProperties == null) {
                        instanceProperties = new DefaultInstanceProperties(string2, this, preferences2);
                        this.cache.put(preferences2, instanceProperties);
                    }
                    arrayList.add(instanceProperties);
                }
            }
            return arrayList;
        }
        catch (BackingStoreException backingStoreException) {
            LOGGER.log(Level.INFO, null, backingStoreException);
            throw new IllegalStateException(backingStoreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Preferences preferences) throws BackingStoreException {
        InstancePropertiesManager instancePropertiesManager = this;
        synchronized (instancePropertiesManager) {
            this.cache.remove(preferences);
            preferences.removeNode();
        }
    }

    private static class DefaultInstanceProperties
    extends InstanceProperties {
        private final InstancePropertiesManager manager;
        private Preferences prefs;

        public DefaultInstanceProperties(String string, InstancePropertiesManager instancePropertiesManager, Preferences preferences) {
            super(string);
            this.manager = instancePropertiesManager;
            this.prefs = preferences;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getBoolean(String string, boolean bl) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getBoolean(string, bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getDouble(String string, double d) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getDouble(string, d);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getFloat(String string, float f) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getFloat(string, f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getInt(String string, int n) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getInt(string, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLong(String string, long l) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getLong(string, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getString(String string, String string2) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.get(string, string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putBoolean(String string, boolean bl) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putBoolean(string, bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putDouble(String string, double d) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putDouble(string, d);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putFloat(String string, float f) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putFloat(string, f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putInt(String string, int n) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putInt(string, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putLong(String string, long l) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putLong(string, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putString(String string, String string2) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.put(string, string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeKey(String string) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.remove(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            try {
                DefaultInstanceProperties defaultInstanceProperties = this;
                synchronized (defaultInstanceProperties) {
                    if (this.prefs != null) {
                        this.manager.remove(this.prefs);
                        this.prefs = null;
                    }
                }
            }
            catch (BackingStoreException backingStoreException) {
                LOGGER.log(Level.INFO, null, backingStoreException);
            }
        }
    }
}

