/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.core;

import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SQLOptions {
    private static SQLOptions INSTANCE = new SQLOptions();
    private static final String PROP_FETCH_STEP = "fetchStep";
    private static final int DEFAULT_FETCH_STEP = 200;
    private static final String PROP_MAX_ROWS = "maxRows";
    private static final int DEFAULT_MAX_ROWS = 200000;
    public static final String PROP_KEEP_OLD_RESULT_TABS = "keepOldResultTabs";

    public static SQLOptions getDefault() {
        return INSTANCE;
    }

    public String displayName() {
        return NbBundle.getMessage(SQLOptions.class, (String)"LBL_SQLOptions");
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(SQLOptions.class);
    }

    public int getFetchStep() {
        return SQLOptions.getPreferences().getInt(PROP_FETCH_STEP, 200);
    }

    public void setFetchStep(int n) {
        SQLOptions.getPreferences().putInt(PROP_FETCH_STEP, n);
    }

    public int getMaxRows() {
        return SQLOptions.getPreferences().getInt(PROP_MAX_ROWS, 200000);
    }

    public void setMaxRows(int n) {
        SQLOptions.getPreferences().putInt(PROP_MAX_ROWS, n);
    }

    public boolean isKeepOldResultTabs() {
        return SQLOptions.getPreferences().getBoolean(PROP_KEEP_OLD_RESULT_TABS, false);
    }

    public void setKeepOldResultTabs(boolean bl) {
        SQLOptions.getPreferences().putBoolean(PROP_KEEP_OLD_RESULT_TABS, bl);
    }
}

