/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.List;
import java.util.Stack;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class NodeByPositionVisitor
implements XMLNodeVisitor {
    private int currentPos = 0;
    private Node rootNode;
    private boolean found;
    private int position;
    private Node foundNode;
    private Stack<Element> stack = new Stack();

    public NodeByPositionVisitor(Node node) {
        this.rootNode = node;
    }

    public Element getContainingElement(int n) {
        Node node = this.getContainingNode(n);
        if (node instanceof Attribute || node instanceof Text) {
            if (this.stack.isEmpty()) {
                return null;
            }
            return this.stack.peek();
        }
        return (Element)node;
    }

    public Node getContainingNode(int n) {
        this.reset();
        this.position = n;
        this.rootNode.accept(this);
        return this.foundNode;
    }

    public void reset() {
        this.currentPos = 0;
        this.found = false;
        this.foundNode = null;
    }

    public void visit(Document document) {
        this.currentPos += this.getLengthOfTokens(document);
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = (Node)nodeList.item(i);
            node.accept(this);
            if (!this.found) continue;
            return;
        }
    }

    public void visit(Element element) {
        int n;
        Object object;
        int n2;
        this.stack.push(element);
        int n3 = this.currentPos;
        this.currentPos += this.getTokenLength(element, TokenType.TOKEN_WHITESPACE);
        this.currentPos += this.getElementStartTokenLength(element, true);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
            object = (Node)namedNodeMap.item(n2);
            object.accept(this);
            if (!this.found) continue;
            return;
        }
        ++this.currentPos;
        n2 = this.currentPos;
        if (this.position >= n3 && this.position < n2) {
            this.foundNode = element;
            this.found = true;
        }
        object = element.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            Node node = (Node)object.item(n);
            node.accept(this);
            if (!this.found) continue;
            return;
        }
        this.stack.pop();
        n = this.currentPos;
        this.currentPos += this.getElementStartTokenLength(element, false);
        ++this.currentPos;
        int n4 = this.currentPos;
        if (this.position >= n && this.position < n4) {
            this.foundNode = element;
            this.found = true;
        }
    }

    public void visit(Text text) {
        int n = this.currentPos;
        this.currentPos += this.getLengthOfTokens(text);
        int n2 = this.currentPos;
        if (this.position >= n && this.position < n2) {
            this.foundNode = text;
            this.found = true;
        }
    }

    public void visit(Attribute attribute) {
        int n = this.currentPos;
        this.currentPos += this.getLengthOfTokens(attribute);
        int n2 = this.currentPos;
        if (this.position >= n && this.position < n2) {
            this.foundNode = attribute;
            this.found = true;
        }
    }

    private int getElementStartTokenLength(Element element, boolean bl) {
        String string = "";
        List<Token> list = element.getTokens();
        for (Token token : list) {
            if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
            String string2 = token.getValue();
            if (bl) {
                if (string2.startsWith("</")) continue;
                string = string2;
                continue;
            }
            if (!string2.startsWith("</")) continue;
            string = string2;
        }
        return string.length();
    }

    private int getTokenLength(NodeImpl nodeImpl, TokenType tokenType) {
        StringBuffer stringBuffer = new StringBuffer("");
        List<Token> list = nodeImpl.getTokens();
        for (Token token : list) {
            if (token.getType() != tokenType) continue;
            stringBuffer.append(token.getValue());
        }
        return stringBuffer.toString().length();
    }

    private int getLeadingWhiteSpaces(Attribute attribute) {
        Token token = attribute.getTokens().get(0);
        if (token.getType() == TokenType.TOKEN_WHITESPACE) {
            return token.getValue().length();
        }
        return 0;
    }

    private int getLengthOfTokens(NodeImpl nodeImpl) {
        StringBuffer stringBuffer = new StringBuffer();
        List<Token> list = nodeImpl.getTokens();
        for (Token token : list) {
            stringBuffer.append(token.getValue());
        }
        return stringBuffer.length();
    }
}

