/**	@file
	@author		nezumi
	@since		2004.06.06
	@todo		ou\[gŎGG
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "qsort.h"

void 
qsort( void *base, size_t nmemb, size_t size, int(*compar)(const void *, const void *) )
{
	unsigned int i, j;
	char* p1;
	char* p2;
	int f;
	char* temp;

	if( nmemb < 2 )
		return;
	temp = malloc( size );
	if( temp == NULL )
		return;
	
	for( i = 0; i < nmemb - 1; i++ ){
		p1 = (char*)base + i * size;
		for( j = i; j < nmemb; j++ ){
			p2 = (char*)base + j * size;
			f = compar( p1, p2 );
			if( f > 0 ) {		// *p1 > *p2
				// swap
				memcpy( temp, p1, size );
				memcpy( p1, p2, size );
				memcpy( p2, temp, size );
			}
		}
	}
}
