      program main
      use indata
      use index_np
      use kernel_params
      implicit real*8(a-h,o-z)

c       parameter (tolerance=1.d-4,eps=1.d-9)
c       parameter (MAXitr=10000,Nq0=600,rq=1.d0)
      real*8  tolerance,eps,rq
      integer MAXitr,Nq0,Nq,vKKT

c     file names
      character*99 input_file,model_file

c     for time
      integer time0,time1,count_rate,count_max

c     for subQP calculation
      real*8 Kernel,Kernel_s
      real*8,allocatable::Ker(:,:),aa(:),yy(:),qq(:),yg(:)
      real*8,allocatable::Qmat(:,:)
      real*8 ay,tt
      integer,allocatable::is(:),is0(:),ix(:)
      integer mk_index

c     other parameters
      integer NN2,NN3,sw_prob
      real*8  b0
      integer,allocatable::seed(:)

c     ---------- end of declaration ----------

      call system_clock(time0,count_rate,count_max)
      call random_seed(size=n)
      allocate (seed(n))
      seed=time0+37*(/(i-1,i=1,n)/)
      call random_seed(put=seed)

      call parse_option(input_file,model_file,Nq0,NB,rq,MAXitr,
     &     tolerance,eps)

c     file analysis & allocate
      call analysis(input_file,NN,MM)
      allocate (y(NN),x(MM,NN),alpha(NN),ss(NN))
      allocate (pt(MM,NN),nd(NN))

c     reading data   NN(# of data) MM(# of descriptor)
      if (is_sparse .eq. 0) then
        call read_df(input_file,y,x)
      else if (is_sparse .eq. 1) then
        call read_sf(input_file,y,x,pt,nd,NN,MM,imax)
      end if

c     initialize
      allocate (yg(NN),ix(NN),is(NN),is0(NN))
      do i=1,NN
        is(i)=0
        is0(i)=0
        alpha(i)=0.d0
        ss(i)=0.d0
      end do

c     initial selection
      Nq=Nq0
      call initial_working_set(NN,Nq,y,ix,is,is0)

c     START!
      write(*,'(a8,a10,a10,a26)') 'itr','nSV','vKKT','Objective'
      do itr=1,MAXitr

        MS=mk_index(NN,ix,is)

        allocate (Ker(MS,NN),Qmat(MS,MS),aa(MS),yy(MS),qq(MS))

        call mk_Kmat(NN,MM,MS,ix,Ker)

        call mk_subQP(NN,MM,MS,y,alpha,ss,ix,Ker,Qmat,qq,yy,ay)

        call solve_QP(MS,Qmat,yy,qq,ay,aa,Cost,
     &       1.d-1, 1.d-11, 1.d-14)

        call update(NN,MM,MS,Ker,y,x,alpha,ss,ix,aa)

        deallocate (Ker,Qmat,aa,yy,qq)

        write(*,'(I8$)') itr
        call calc_b_KKT(NN,Cost,tolerance,eps,y,alpha,ss,b,vKKT,yg)
        if (vKKT .eq. 0) exit

c     calc Nq
        Nq=Nq0*exp(-rq*(1.d0-dble(vKKT)/dble(NN)))
       
        call select_wset(NN,Nq,Cost,eps,y,alpha,yg,ix,is,is0)

      end do      
      deallocate (yg,ix,is,is0)

      ii=0
!$omp parallel do reduction(+:ii) private(Fx)
      do i=1,NN
        Fx=ss(i)+b
        if (y(i)*Fx .gt. 0.d0) then
          ii=ii+1
        end if
      end do
      write(*,*) 'Accuracy=',dble(ii)/dble(NN),'miss',NN-ii

      call system_clock(time1,count_rate,count_max)
      write(*,'(f18.3,a4)') dble(time1-time0)/dble(count_rate),' [s]'
      call flush(6)

c     save b
      b0=b

c     NB=1 or not
      if (NB .le. 1) then
        probA=0.d0; probB=0.d0
        goto 9000
      end if

c     randomize
      allocate (ix0(NN))
      do i=1,NN
        ix0(i)=i
      end do
      call random_number(ss)
      call hsort(NN,ss,ix0)
      call init_PN()

c     START!
      do itr2=1,NB

        ii=1
        do k=1,NB
          if (k .ne. itr2) then
            do i=1,npset(k)+nnset(k)
              y(ii)=yt(i,k)
              alpha(ii)=at(i,k)
              nd(ii)=ndt(i,k)
              do j=1,MM
                x(j,ii)=xt(j,i,k)
                pt(j,ii)=ptt(j,i,k)
              end do
              ii=ii+1
            end do
          end if
        end do
        NN2=ii-1

c     calculate s vector
        if (is_sparse .eq. 0) then
!$omp parallel do schedule(dynamic) private(j)
          do i=1,NN2
            ss(i)=0.d0
            do j=1,NN2
              ss(i)=ss(i)+alpha(j)*y(j)*Kernel(MM,x(1,i),x(1,j))
            end do
          end do
        else if (is_sparse .eq. 1) then
!$omp parallel do schedule(dynamic) private(j)
          do i=1,NN2
            ss(i)=0.d0
            do j=1,NN2
              ss(i)=ss(i)+alpha(j)*y(j)
     &             *Kernel_s(MM,x(1,i),pt(1,i),nd(i)
     &             ,MM,x(1,j),pt(1,j),nd(j),imax)
            end do
          end do
        end if

c     initialize
        allocate (yg(NN2),ix(NN2),is(NN2),is0(NN2))
        do i=1,NN2
          is(i)=0
          is0(i)=0
        end do
        
c     initial selection
        Nq=Nq0
        call initial_working_set(NN2,Nq,y,ix,is,is0)
        
c     training
        write(*,'(a8,a8,a10,a10,a26)') 'subset','itr','nSV'
     &       ,'vKKT','Objective'
        do itr=1,MAXitr
          
          MS=mk_index(NN2,ix,is)
          
          allocate (Ker(MS,NN),Qmat(MS,MS),aa(MS),yy(MS),qq(MS))
          
          call mk_Kmat(NN2,MM,MS,ix,Ker)

          call mk_subQP(NN2,MM,MS,y,alpha,ss,ix,Ker,Qmat,qq,yy,ay)
          
          call solve_QP(MS,Qmat,yy,qq,ay,aa,Cost,
     &         1.d-1, 1.d-11, 1.d-14)
          
          call update(NN2,MM,MS,Ker,y,x,alpha,ss,ix,aa)
          
          deallocate (Ker,Qmat,aa,yy,qq)
          
          write(*,'(I8,I8$)') itr2,itr
          call calc_b_KKT(NN2,Cost,tolerance,eps,y,alpha,ss,b,vKKT,yg)
          if (vKKT .eq. 0) exit
          
c     calc Nq
          Nq=Nq0*exp(-rq*(1.d0-dble(vKKT)/dble(NN2)))
          
          call select_wset(NN2,Nq,Cost,eps,y,alpha,yg,ix,is,is0)
          
        end do      
        deallocate (yg,ix,is,is0)
        
        ii=0
        Ntest=npset(itr2)+nnset(itr2)
        do i=1,Ntest
          dist=0.d0
          if (is_sparse .eq. 0) then
!$omp parallel do reduction(+:dist)
            do j=1,NN2
              dist=dist+alpha(j)*y(j)*Kernel(MM,x(1,j),xt(1,i,itr2))
            end do
          else if (is_sparse .eq. 1) then
!$omp parallel do reduction(+:dist)
            do j=1,NN2
              dist=dist+alpha(j)*y(j)
     &             *Kernel_s(MM,x(1,j),pt(1,j),nd(j)
     &             ,MM,xt(1,i,itr2),ptt(1,i,itr2),ndt(i,itr2),imax)
            end do
          end if
          ff(i,itr2)=dist+b
          if (ff(i,itr2)*yt(i,itr2) .gt. 0.d0) ii=ii+1
        end do
        xr(itr2)=dble(ii)/dble(Ntest)
        write(*,*) 'Accuracy=',xr(itr2),'miss',Ntest-ii

        call system_clock(time1,count_rate,count_max)
        write(*,'(f18.3,a4)') dble(time1-time0)/dble(count_rate),' [s]'
        call flush(6)

      end do
      
      d=0.d0
      do i=1,NB
        d=d+xr(i)
      end do
      d=100.d0*d/dble(NB)
      write(*,*) NB,'fold cross-validation [%] =',d

c      do k=1,NB
c        do i=1,npset(k)+nnset(k)
c          write(20,'(F4.1,ES24.15)') yt(i,k),ff(i,k)
c        end do
c      end do

      call calc_sigmoid(probA, probB)

c     copy xt->x, yt->y, at->alpha 
      ii=0
      do k=1,NB
        do i=1,npset(k)+nnset(k)
          ii=ii+1
          y(ii)=yt(i,k)
          alpha(ii)=at(i,k)
          nd(ii)=ndt(i,k)
          do j=1,MM
            x(j,ii)=xt(j,i,k)
            pt(j,ii)=ptt(j,i,k)
          end do
        end do
      end do

 9000 continue
c     write model
      write(*,*) 'writing model file'
      if (is_sparse .eq. 0) then
        call write_model_df(model_file,y,alpha,x,b0,NN,MM
     &       ,eps,Cost,gamma,u1,u2,u3,probA,probB)
      else if (is_sparse .eq. 1) then
        call write_model_sf(model_file,y,alpha,x,pt,nd,b0,NN,MM
     &       ,eps,Cost,gamma,u1,u2,u3,probA,probB)
      end if
      
c     write elapsed time
      call system_clock(time1,count_rate,count_max)
      write(*,'(f18.3,a4)') dble(time1-time0)/dble(count_rate),' [s]'

      end
