      subroutine calc_b_KKT(N,Cost,tolerance,eps,y,alpha,ss,b,vKKT,yg)

      implicit real*8(a-h,o-z)

      integer N,vKKT,nSV
      real*8  y(N),alpha(N),ss(N),yg(N)
      real*8  Cost,tolerance,eps,b

c     calculate b
      NS=0; S1=0.d0; b=0.d0;
!$omp parallel do reduction(+:NS,S1)
      do i=1,N
        if (alpha(i) .ge. eps .and. alpha(i) .le. Cost-eps) then
          S1=S1+y(i)-ss(i)
          NS=NS+1
        end if
      end do
      if (NS .ne. 0) then
        b=S1/dble(NS)
      end if
        
c     check KKT
      vKKT=0; S1=0.d0; S2=0.d0; nSV=0
!$omp parallel do reduction(+:vKKT,S1,S2,nSV) private(rr)
      do i=1,N
        yg(i)=y(i)*(1.d0-y(i)*ss(i))
        rr=y(i)*(ss(i)+b)-1.d0
        if ( (rr .lt. -tolerance .and. alpha(i) .le. Cost-eps)
     &       .or. (rr .gt. tolerance .and. alpha(i) .ge. eps) ) then
          vKKT=vKKT+1
        end if
        S1=S1+y(i)*alpha(i)*ss(i)
        S2=S2+alpha(i)
        if (alpha(i) .ge. eps) then
          nSV=nSV+1
        end if
      end do
      
      write(*,'(I10,I10,ES26.15)') nSV,vKKT,0.5d0*S1-S2
      call flush(6)
      
      return
      end
