/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.beans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

import jp.sf.pal.myfaces.portlet.MyFacesPortletParameters;

public class ConfigBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(ConfigBean.class);

    private static String DEFAULT_URI = "default-uri";

    private static String ACCEPT_PATHS = "accept-paths";

    private static String DENY_PATHS = "deny-paths";

    private String loadConfig(String key)
    {

        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext exContext = context.getExternalContext();
        PortletRequest request = (PortletRequest) exContext.getRequest();
        PortletConfig portletConfig = (PortletConfig) request.getAttribute(MyFacesPortletParameters.PORTLET_CONFIG);

        if (log.isDebugEnabled())
        {
            log.debug("loadConfig() - TEST: init: portletConfig.getPortletName()=" + portletConfig.getPortletName());
        }
        return portletConfig.getInitParameter(key);
    }

    public boolean checkPath(String path)
    {
        if (log.isDebugEnabled())
        {
            log.debug("checkPath() - TEST: checkPath: path=" + path);
        }
        String acceptPaths[] = getAcceptPaths();
        String denyPaths[] = getDenyPaths();
        if (acceptPaths.length > 0)
        {
            if (log.isDebugEnabled())
            {
                log.debug("checkPath() - TEST: checkPath: acceptPaths.length=" + acceptPaths.length);
            }
            for (int i = 0; i < acceptPaths.length; i++)
            {
                if (log.isDebugEnabled())
                {
                    log.debug("checkPath() - TEST: checkPath: acceptPaths[i]=" + acceptPaths[i]);
                }
                if (path.matches(acceptPaths[i]))
                {
                    if (log.isDebugEnabled())
                    {
                        log.debug("checkPath() - TEST: checkPath: true");
                    }
                    return true;
                }
            }
            if (log.isDebugEnabled())
            {
                log.debug("checkPath() - TEST: checkPath: false");
            }
            return false;
        }
        else
        {
            if (denyPaths.length > 0)
            {
                if (log.isDebugEnabled())
                {
                    log.debug("checkPath() - TEST: checkPath: denyPaths.length=" + denyPaths.length);
                }
                for (int i = 0; i < denyPaths.length; i++)
                {
                    if (log.isDebugEnabled())
                    {
                        log.debug("checkPath() - TEST: checkPath: denyPaths[i]=" + denyPaths[i]);
                    }
                    if (path.matches(denyPaths[i]))
                    {
                        if (log.isDebugEnabled())
                        {
                            log.debug("checkPath() - TEST: checkPath: false");
                        }
                        return false;
                    }
                }
                if (log.isDebugEnabled())
                {
                    log.debug("checkPath() - TEST: checkPath: true");
                }
                return true;
            }
            else
            {
                if (log.isDebugEnabled())
                {
                    log.debug("checkPath() - TEST: checkPath: not defined true");
                }
                // accept-paths and deny-paths are not defined
                return true;
            }
        }
    }

    /**
     * @return Returns the acceptPath.
     */
    public String[] getAcceptPaths()
    {
        String acceptPathString = loadConfig(ACCEPT_PATHS);
        if (acceptPathString == null)
        {
            return new String[0];
        }
        else
        {
            return acceptPathString.split(",");
        }
    }

    /**
     * @param acceptPath The acceptPath to set.
     */
    public void setAcceptPaths(String[] acceptPath)
    {
    }

    /**
     * @return Returns the defualtUrl.
     */
    public String getDefaultUri()
    {
        String defaultUri = loadConfig(DEFAULT_URI);
        if (defaultUri == null)
        {
            defaultUri = "file:///";
        }
        return defaultUri;
    }

    /**
     * @param defualtUrl The defualtUrl to set.
     */
    public void setDefaultUri(String defualtUrl)
    {
    }

    /**
     * @return Returns the denyPaths.
     */
    public String[] getDenyPaths()
    {
        String denyPathString = loadConfig(DENY_PATHS);
        if (denyPathString == null)
        {
            return new String[0];
        }
        else
        {
            return denyPathString.split(",");
        }
    }

    /**
     * @param denyPaths The denyPaths to set.
     */
    public void setDenyPaths(String[] denyPaths)
    {
    }
}
