/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.beans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

public class DeleteFileBean extends AbstractPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(DeleteFileBean.class);

    public String go()
    {
        // TODO
        if (log.isDebugEnabled())
        {
            log.debug("go() - TEST: DeleteFileBean: go: 1");
        }
        return "listview";
    }

    public String selectAction()
    {
        if (log.isDebugEnabled())
        {
            log.debug("selectAction() - TEST: DeleteFileBean: selectAction: 1");
        }

        if (getSelectedAction().equals("listview"))
        {
            return "listview";
        }
        return null;

    }

    public String delete()
    {
        if (log.isDebugEnabled())
        {
            log.debug("delete() - TEST: DeleteFileBean: delete: 1");
        }
        try
        {
            FileSystemManager fsManager = VFS.getManager();
            FileObject fileObject = fsManager.resolveFile(getFileSystem().getTargetUri());

            if (fileObject.delete())
            {
                getSessionInfo().setMessage("Deleted "+getFileSystem().getTargetUri());
            }
            else
            {
                getSessionInfo().setMessage("Failed delete action.");
            }
        }
        catch (FileSystemException e)
        {
            // TODO Auto-generated catch block
            log.error("delete()", e);
        }
        getFileSystem().setTargetUri(null);

        return "listview";
    }

    public String cancel()
    {
        if (log.isDebugEnabled())
        {
            log.debug("cancel() - TEST: DeleteFileBean: cancel: 1");
        }
        // TODO I18N
        getSessionInfo().setMessage("Canceled delete action.");
        getFileSystem().setTargetUri(null);

        return "listview";

    }
}
