/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.beans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;

import jp.sf.pal.vfs.FileParameter;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.VFS;

public class FileSystemBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(FileSystemBean.class);

    private String uri;
    
    private String targetUri;

    private ConfigBean config;

    public List getObjects()
    {
        // Get File System
        ArrayList objects = new ArrayList();
        if (log.isDebugEnabled())
        {
            log.debug("getObjects() - TEST: FileSystemBean: uri=" + uri);
        }
        if (config.checkPath(getUri()))
        {
            try
            {
                FileSystemManager fsManager = VFS.getManager();
                FileObject currentDirectory = fsManager.resolveFile(getUri());

                FileObject[] children = currentDirectory.getChildren();
                ArrayList folders = new ArrayList();
                ArrayList files = new ArrayList();
                for (int i = 0; i < children.length; i++)
                {
                    try
                    {
                        if (children[i].getType() == FileType.FOLDER)
                        {
                            folders.add(new FileParameter(children[i]));
                        }
                        else
                        {
                            files.add(new FileParameter(children[i]));
                        }
                    }
                    catch (FileSystemException e)
                    {
                        files.add(new FileParameter(children[i]));
                    }
                }
                objects.addAll(folders);
                objects.addAll(files);
            }
            catch (FileSystemException e)
            {
                // TODO Auto-generated catch block
                log.error("getObjects()", e);
            }
        }
        else
        {
            // TODO I18N
            //setMessage("access denied.");
        }
        return (List) objects;

    }



    /**
     * @return Returns the uri.
     */
    public String getUri()
    {
        if (uri == null)
        {
            uri = getConfig().getDefaultUri();
        }
        return uri;
    }

    /**
     * @param uri The uri to set.
     */
    public void setUri(String uri)
    {
        if (!uri.substring(uri.length() - 1).equals("/"))
        {
            this.uri = uri + "/";
        }
        else
        {
            this.uri = uri;
        }
    }

    /**
     * @return Returns the config.
     */
    public ConfigBean getConfig()
    {
        return config;
    }

    /**
     * @param config The config to set.
     */
    public void setConfig(ConfigBean config)
    {
        this.config = config;
    }



    /**
     * @return Returns the targetUri.
     */
    public String getTargetUri()
    {
        return targetUri;
    }



    /**
     * @param targetUri The targetUri to set.
     */
    public void setTargetUri(String targetUri)
    {
        this.targetUri = targetUri;
    }
}
