/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.beans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Enumeration;
import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import jp.sf.pal.vfs.FileParameter;
import jp.sf.pal.vfs.container.SessionContainer;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

public class ListViewBean extends AbstractPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(ListViewBean.class);

    public String go()
    {
        // TODO
        if (log.isDebugEnabled())
        {
            log.debug("go() - TEST: ListViewBean: go: 1");
        }

        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext exContext = context.getExternalContext();
        PortletRequest request = (PortletRequest) exContext.getRequest();
        for (Enumeration e = request.getPortletSession().getAttributeNames(); e.hasMoreElements();)
        {
            String key = (String) e.nextElement();
            if (log.isDebugEnabled())
            {
                log.debug("go() - TEST: Session PORTLET_SCOPE " + key);
            }
            if (key.matches(".*fileSystemBean"))
            {
                FileSystemBean bean = (FileSystemBean) request.getPortletSession().getAttribute(key);
                if (log.isDebugEnabled())
                {
                    log.debug("go() - TEST: uri=" + bean.getUri());
                }
            }
        }
        for (Enumeration e = request.getPortletSession().getAttributeNames(PortletSession.APPLICATION_SCOPE); e
                .hasMoreElements();)
        {
            String key = (String) e.nextElement();
            if (log.isDebugEnabled())
            {
                log.debug("go() - TEST: Session APPLICATION_SCOPE " + key);
            }
            if (key.matches(".*fileSystemBean"))
            {
                FileSystemBean bean = (FileSystemBean) request.getPortletSession().getAttribute(key,
                        PortletSession.APPLICATION_SCOPE);
                if (log.isDebugEnabled())
                {
                    log.debug("go() - TEST: uri=" + bean.getUri());
                }
            }
        }
        return null;
    }

    public String selectAction()
    {
        if (log.isDebugEnabled())
        {
            log.debug("selectAction() - TEST: ListViewBean: selectAction: 1");
        }

        if (getSelectedAction().equals("open_parent"))
        {
            return openParent();
        }
        else if (getSelectedAction().equals("upload"))
        {
            return "upload";
        }
        else if (getSelectedAction().equals("newfile"))
        {
            return "newfile";
        }
        else if (getSelectedAction().equals("newfolder"))
        {
            return "newfolder";
        }
        return null;

    }

    public String openParent()
    {
        try
        {
            FileSystemManager fsManager = VFS.getManager();
            FileObject currentDirectory = fsManager.resolveFile(getFileSystem().getUri());
            FileObject parent = currentDirectory.getParent();
            if (parent != null)
            {
                getFileSystem().setUri(parent.getName().getURI());
            }
        }
        catch (FileSystemException e)
        {
            // TODO Auto-generated catch block
            log.error("openParent()", e);
        }

        return null;
    }

    public String select()
    {
        if (log.isDebugEnabled())
        {
            log.debug("select() - TEST: ListViewBean: selectObject: 1");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (log.isDebugEnabled())
        {
            log.debug("select() - TEST: ListViewBean: selectObject: 2");
        }
        ExternalContext exContext = context.getExternalContext();
        if (log.isDebugEnabled())
        {
            log.debug("select() - TEST: ListViewBean: selectObject: 3");
        }
        PortletRequest request = (PortletRequest) exContext.getRequest();
        Map map = exContext.getRequestMap();
        if (log.isDebugEnabled())
        {
            log.debug("select() - TEST: ListViewBean: selectObject: 4");
        }
        FileParameter fileParam = (FileParameter) map.get("item");
        if (log.isDebugEnabled())
        {
            log.debug("select() - TEST: ListViewBean: selectObject: 5");
        }
        if (fileParam != null)
        {
            if (log.isDebugEnabled())
            {
                log.debug("select() - TEST: ListViewBean: selectObject: 6");
            }
            if (fileParam.isFolder())
            {
                if (log.isDebugEnabled())
                {
                    log.debug("select() - TEST: ListViewBean: filePram.getURI()=" + fileParam.getURI());
                }
                getFileSystem().setUri(fileParam.getURI());
            }
            else if (fileParam.isFile())
            {
                // TODO I18N
                // getSessionInfo().setMessage(
                // "<script language=\"javascript\">\n<!--\nlocation.href=\"" + request.getContextPath()
                // + "/FileServlet?uri=" + fileParam.getURI() + "\";\n//--></script>");
                if (log.isDebugEnabled())
                {
                    log.debug("select() - TEST: ListViewBean: session id=" + request.getPortletSession().getId());
                }
                getFileSystem().setTargetUri(fileParam.getURI());
                SessionContainer.addSession(request.getPortletSession().getId(), request.getPortletSession());
                getSessionInfo().setMessage(
                        "<script language=\"javascript\">\n<!--\nlocation.href=\"" + request.getContextPath()
                                + "/FileServlet?id=" + request.getPortletSession().getId() + "\";\n//--></script>");
            }
            else
            {
                // TODO I18N
                getSessionInfo().setMessage("The selected object is not FOLDER or FILE.");
            }
        }
        else
        {
            // TODO
            if (log.isDebugEnabled())
            {
                log.debug("select() - TEST: ListViewBean: object is not found.");
            }
        }
        return null;
    }

    public String delete()
    {
        if (log.isDebugEnabled())
        {
            log.debug("delete() - TEST: ListViewBean: delete: 1");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext exContext = context.getExternalContext();
        Map map = exContext.getRequestMap();
        FileParameter fileParam = (FileParameter) map.get("item");
        if (log.isDebugEnabled())
        {
            log.debug("delete() - TEST: ListViewBean: delete: 5");
        }
        if (fileParam != null)
        {
            if (log.isDebugEnabled())
            {
                log.debug("delete() - TEST: ListViewBean: delete: 6");
            }
            if (fileParam.isFolder())
            {
                getFileSystem().setTargetUri(fileParam.getURI());
                return "deleteFolder";
            }
            else if (fileParam.isFile())
            {
                getFileSystem().setTargetUri(fileParam.getURI());
                return "deleteFile";
            }
            else
            {
                // TODO I18N
                getSessionInfo().setMessage("The selected object is not FOLDER or FILE.");
            }
        }
        else
        {
            // TODO
            if (log.isDebugEnabled())
            {
                log.debug("delete() - TEST: ListViewBean: object is not found.");
            }
        }
        return null;
    }
}
