/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.beans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

public class NewFolderBean extends AbstractPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(NewFolderBean.class);

    private String newFolder;

    public String go()
    {
        // TODO
        return "listview";
    }

    public String selectAction()
    {
        if (log.isDebugEnabled())
        {
            log.debug("selectAction() - TEST: NewFolderBean: selectAction: 1");
        }

        if (getSelectedAction().equals("listview"))
        {
            return "listview";
        }
        return null;

    }

    public String create()
    {
        try
        {
            FileSystemManager fsManager = VFS.getManager();
            FileObject newFileObject = fsManager.resolveFile(getFileSystem().getUri() + "/" + getNewFolder());
            // TODO add confirmation
            // if (!newFileObject.exists())
            // {
            // TODO should catch exception to check if it's created
            newFileObject.createFolder();
            
            // TODO I18N
            getSessionInfo().setMessage("Created new folder: " + getNewFolder());
            return "listview";
            // }
        }
        catch (FileSystemException e)
        {
            // TODO Auto-generated catch block
            log.error("create()", e);
        }
        return null;
    }

    /**
     * @return Returns the newFolder.
     */
    public String getNewFolder()
    {
        return newFolder;
    }

    /**
     * @param newFolder The newFolder to set.
     */
    public void setNewFolder(String newFolder)
    {
        this.newFolder = newFolder;
    }
}
