/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.beans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.myfaces.custom.fileupload.UploadedFile;

public class UploadBean extends AbstractPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(UploadBean.class);

    private static final int BLOCK_SIZE = 4096;

    private UploadedFile uploadedFile;

    public String go()
    {
        // TODO
        if (log.isDebugEnabled())
        {
            log.debug("go() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("go() - end");
        }
        return "listview";
    }

    public String selectAction()
    {
        if (log.isDebugEnabled())
        {
            log.debug("selectAction() - start");
        }

        if (getSelectedAction().equals("listview"))
        {
            if (log.isDebugEnabled())
            {
                log.debug("selectAction() - end");
            }
            return "listview";
        }

        if (log.isDebugEnabled())
        {
            log.debug("selectAction() - end");
        }
        return null;

    }

    public String upload()
    {
        if (log.isDebugEnabled())
        {
            log.debug("upload() - start");
            log.debug("upload() - TEST: upload: getUploadedFile()=" + getUploadedFile());
            log.debug("upload() - TEST: upload: filename=" + getUploadedFile().getName());
        }
        try
        {
            FileSystemManager fsManager = VFS.getManager();
            FileObject newFileObject = fsManager.resolveFile(getFileSystem().getUri() + "/"
                    + getUploadedFile().getName());
            // TODO add confirmation
            // if (!newFileObject.exists())
            // {
            // TODO should catch exception to check if it's created
            newFileObject.createFile();
            drain(getUploadedFile().getInputStream(), newFileObject.getContent().getOutputStream());

            // TODO I18N
            getSessionInfo().setMessage("Uploaded file: " + getUploadedFile().getName());

            if (log.isDebugEnabled())
            {
                log.debug("upload() - end");
            }
            return "listview";
            // }
        }
        catch (FileSystemException e)
        {
            // TODO Auto-generated catch block
            log.error("upload()", e);
        }
        catch (IOException e)
        {
            // TODO Auto-generated catch block
            log.error("upload()", e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("upload() - end");
        }
        return null;
    }

    private void drain(InputStream r, OutputStream w) throws IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("drain(InputStream, OutputStream) - start");
        }

        byte[] bytes = new byte[BLOCK_SIZE];
        try
        {
            int length = r.read(bytes);
            while (length != -1)
            {
                if (length != 0)
                {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally
        {
            bytes = null;
        }

        if (log.isDebugEnabled())
        {
            log.debug("drain(InputStream, OutputStream) - end");
        }
    }

    /**
     * @return Returns the uploadedFile.
     */
    public UploadedFile getUploadedFile()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getUploadedFile() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getUploadedFile() - end");
        }
        return uploadedFile;
    }

    /**
     * @param uploadedFile The uploadedFile to set.
     */
    public void setUploadedFile(UploadedFile uploadedFile)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUploadedFile(UploadedFile) - start");
        }

        this.uploadedFile = uploadedFile;

        if (log.isDebugEnabled())
        {
            log.debug("setUploadedFile(UploadedFile) - end");
        }
    }
}
