/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.container;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;

import javax.portlet.PortletSession;

public class SessionContainer
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(SessionContainer.class);

    private static HashMap map;

    public static void addSession(String id, PortletSession session)
    {
        if (map == null)
        {
            map = new HashMap();
        }
        synchronized (map)
        {
            map.put(id, session);
        }
    }

    public static PortletSession getSession(String id)
    {
        if (map == null)
        {
            return null;
        }
        synchronized (map)
        {
            try
            {
                PortletSession session = (PortletSession) map.get(id);
                map.remove(id);
                return session;
            }
            catch (Exception e)
            {
                if (log.isDebugEnabled())
                {
                    log.debug("getSession() - TEST: getSession exception.");
                }
                return null;
            }
        }
    }
}
