/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.servlets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

import javax.portlet.PortletSession;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.pal.vfs.beans.FileSystemBean;
import jp.sf.pal.vfs.container.SessionContainer;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

public class FileServlet extends HttpServlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(FileServlet.class);

    private static final int BLOCK_SIZE = 4096;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
    {
        // String uri = request.getParameter("uri");
        String id = (String) request.getParameter("id");
        if (log.isDebugEnabled())
        {
            log.debug("doGet() - TEST: FileServlet: id=" + id);
        }

        PortletSession session = SessionContainer.getSession(id);

        if (session != null)
        {
            if (log.isDebugEnabled())
            {
                Enumeration en = session.getAttributeNames(PortletSession.APPLICATION_SCOPE);
                while (en.hasMoreElements())
                {
                    log.debug("doGet() - TEST: FileServlet: session key=" + en.nextElement());
                }
                en = session.getAttributeNames(PortletSession.PORTLET_SCOPE);
                while (en.hasMoreElements())
                {
                    log.debug("doGet() - TEST: FileServlet: session key=" + en.nextElement());
                }
            }
            FileSystemBean fileSystemBean = (FileSystemBean) session.getAttribute("fileSystemBean");

            if (fileSystemBean != null)
            {
                FileSystemManager fsManager = VFS.getManager();
                FileObject currentObject = fsManager.resolveFile(fileSystemBean.getTargetUri());

                if (currentObject.exists())
                {
                    drain(currentObject.getContent().getInputStream(), response.getOutputStream());
                }
            }
        }
    }

    public static void drain(InputStream r, OutputStream w) throws IOException
    {
        byte[] bytes = new byte[BLOCK_SIZE];
        try
        {
            int length = r.read(bytes);
            while (length != -1)
            {
                if (length != 0)
                {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally
        {
            bytes = null;
        }

    }

}
