/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.faces.model.DataModel;

import com.marevol.utils.hibernate.HibernateUtil;
import com.marevol.utils.hibernate.faces.model.HibernateDataModel;
import com.marevol.utils.portlet.faces.RenderResponseUtil;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogMessage;
import jp.sf.pal.blog.util.BlogMessaging;

public class BlogViewPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogViewPageBean.class);

    private BlogViewPortletBean viewPortlet;

    private BlogMessage blogMessage;

    private String mode;

    public BlogViewPageBean()
    {
        mode = BlogConstants.BLOG_LIST_VIEW;

        Long id = null;
        try
        {
            id = (Long) BlogMessaging.receiveForView(BlogConstants.BLOG_MESSAGE_ID);
            if (log.isDebugEnabled())
            {
                log.debug("BlogViewPageBean() -  : id=" + id);
            }

            if (id != null)
            {
                blogMessage = (BlogMessage) HibernateUtil.get(BlogMessage.class, id);
                mode = BlogConstants.BLOG_CONTENT_VIEW;
            }
        }
        catch (ClassCastException e)
        {
            log.warn(e);
        }

    }

    public String listView()
    {
        if (log.isDebugEnabled())
        {
            log.debug("listView() - start");
        }

        BlogMessaging.cancelForView(BlogConstants.BLOG_MESSAGE_ID);

        if (log.isDebugEnabled())
        {
            log.debug("listView() - end");
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the blogMessages.
     */
    public DataModel getBlogMessages()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getBlogMessages()");
        }
        Object[] params = { getViewPortlet().getOwner() };
        return new HibernateDataModel(
                "select msg from BlogMessage msg where msg.owner = ? order by msg.updatedtime desc", params);
    }

    /**
     * @return Returns the viewPortlet.
     */
    public BlogViewPortletBean getViewPortlet()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getViewPortlet() - end");
        }
        return viewPortlet;
    }

    /**
     * @param viewPortlet The viewPortlet to set.
     */
    public void setViewPortlet(BlogViewPortletBean viewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setViewPortlet(BlogViewPortletBean) - start");
        }

        this.viewPortlet = viewPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setViewPortlet(BlogViewPortletBean) - end");
        }
    }

    /**
     * @return Returns the blogMessage.
     */
    public BlogMessage getBlogMessage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getBlogMessage() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getBlogMessage() - end");
        }

        return blogMessage;
    }

    /**
     * @param blogMessage The blogMessage to set.
     */
    public void setBlogMessage(BlogMessage blogMessage)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setBlogMessage(BlogMessage) - start");
        }

        this.blogMessage = blogMessage;

        if (log.isDebugEnabled())
        {
            log.debug("setBlogMessage(BlogMessage) - end");
        }
    }

    /**
     * @return Returns the mode.
     */
    public String getMode()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getMode() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getMode() - end");
        }
        return mode;
    }

    /**
     * @param mode The mode to set.
     */
    public void setMode(String mode)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setMode(String) - start");
        }

        this.mode = mode;

        if (log.isDebugEnabled())
        {
            log.debug("setMode(String) - end");
        }
    }

    public String actionUrl()
    {
        return RenderResponseUtil.createActionURL().toString();
    }
}
