/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;

import org.apache.commons.lang.StringUtils;

import com.marevol.utils.portlet.faces.RenderResponseUtil;

/**
 * BlogMessage generated by hbm2java
 */
public class BlogMessage implements java.io.Serializable
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogMessage.class);

    public static final String ID = "id";

    public static final String OWNER = "owner";

    public static final String TITLE = "title";

    public static final String MESSAGE = "message";

    public static final String CREATEDTIME = "createdtime";

    public static final String UPDATEDTIME = "updatedtime";

    // Fields    

    private Long id;

    private String owner;

    private String title;

    private String message;

    private String formattype;

    private Long blogcategoryid;

    private Date createdtime;

    private Date updatedtime;

    // Constructors

    /** default constructor */
    public BlogMessage()
    {
    }

    /** constructor with id */
    public BlogMessage(Long id)
    {
        this.id = id;
    }

    // for view
    private String getFormattedDate(Date d)
    {
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        Locale locale = null;
        if (viewRoot != null)
        {
            locale = viewRoot.getLocale();
        }
        else
        {
            locale = Locale.ENGLISH;
        }

        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, locale);
        return df.format(getUpdatedtime());
    }

    public String getFormattedUpdatedtime()
    {
        return getFormattedDate(getUpdatedtime());
    }

    public String getFormattedCreatedtime()
    {
        return getFormattedDate(getCreatedtime());
    }

    // Property accessors

    /**
     * 
     */
    public Long getId()
    {
        return this.id;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * 
     */
    public String getOwner()
    {
        return this.owner;
    }

    public void setOwner(String owner)
    {
        this.owner = owner;
    }

    /**
     * 
     */
    public String getTitle()
    {
        return this.title;
    }

    public String getAbbreviatedTitle()
    {
        return getAbbreviatedTitle(BlogConstants.DEFAULT_TITLE_MAX_LENGTH);
    }

    public String getAbbreviatedTitle(int maxLength)
    {
        return StringUtils.abbreviate(getTitle(), maxLength);
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public void setAbbreviatedTitle(String title)
    {
        setTitle(title);
    }

    /**
     * 
     */
    public String getMessage()
    {
        return this.message;
    }

    public void setMessage(String message)
    {
        this.message = message;
    }

    /**
     * 
     */
    public String getFormattype()
    {
        return this.formattype;
    }

    public void setFormattype(String formattype)
    {
        this.formattype = formattype;
    }

    /**
     * 
     */
    public Long getBlogcategoryid()
    {
        return this.blogcategoryid;
    }

    public void setBlogcategoryid(Long blogcategoryid)
    {
        this.blogcategoryid = blogcategoryid;
    }

    /**
     * 
     */
    public Date getCreatedtime()
    {
        return this.createdtime;
    }

    public void setCreatedtime(Date createdtime)
    {
        this.createdtime = createdtime;
    }

    /**
     * 
     */
    public Date getUpdatedtime()
    {
        return this.updatedtime;
    }

    public void setUpdatedtime(Date updatedtime)
    {
        this.updatedtime = updatedtime;
    }

    public String getRedirectUrl()
    {
        StringBuffer redirectUrl = new StringBuffer();
        String url = RenderResponseUtil.createRenderURL().toString();
        redirectUrl.append(url);
        if (url.indexOf("?") < 0)
        {
            redirectUrl.append("?");
        }
        else
        {
            redirectUrl.append("&");
        }
        redirectUrl.append("blogid");
        redirectUrl.append("=");
        redirectUrl.append(getId().toString());

        return redirectUrl.toString();
    }

    public void setRedirectUrl(String url)
    {
        // NONE
    }

    public String getFormattedMessage()
    {
        if (getFormattype().equals(BlogConstants.TEXT_FORMAT_TYPE))
        {
            String msg = getMessage();
            return msg.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n",
                    "<br/>");
        }
        return getMessage();
    }

}