package jp.sf.pal.yahoosearch.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;

import com.marevol.utils.portlet.faces.PortletPreferencesUtil;
import com.marevol.utils.portlet.faces.bean.FacesPortletBean;

public class EditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(EditPageBean.class);

    private SearchSessionBean searchSession;

    private FacesPortletBean facesPortlet;

    public String save()
    {
        try
        {
            searchSession.storeApplicationId();
            searchSession.storeMaxResults();
            PortletPreferencesUtil.store();
            facesPortlet.addMsgSuccess("Save the parameters.");
        }
        catch (IOException e)
        {
            facesPortlet.addMsgError("I/O exception occurs on saving parameters.");
            log.error("I/O exception occurs on saving parameters.", e);
        }

        return null;
    } // Setter and Getter

    /**
     * @return Returns the searchSession.
     */
    public SearchSessionBean getSearchSession()
    {
        return searchSession;
    }

    /**
     * @param searchSession The searchSession to set.
     */
    public void setSearchSession(SearchSessionBean searchSession)
    {
        this.searchSession = searchSession;
    }

    /**
     * @return Returns the facesPortlet.
     */
    public FacesPortletBean getFacesPortlet()
    {
        return facesPortlet;
    }

    /**
     * @param facesPortlet The facesPortlet to set.
     */
    public void setFacesPortlet(FacesPortletBean facesPortlet)
    {
        this.facesPortlet = facesPortlet;
    }
}
