package jp.sf.pal.yahoosearch.bean;

import java.io.IOException;

import jp.sf.pal.yahoosearch.YahooWebSearchConstants;

import com.marevol.utils.portlet.faces.PortletPreferencesUtil;

public class SearchSessionBean
{
    private String applicationId;

    private String query;

    private Integer startPosition;

    private Integer maxResults;

    public void storeApplicationId() throws IOException
    {
        PortletPreferencesUtil.setValue(YahooWebSearchConstants.APPLICATION_ID, applicationId);
        applicationId = null;
    }

    /**
     * @return Returns the applicationId.
     */
    public String getApplicationId()
    {
        if (applicationId == null)
        {
            applicationId = PortletPreferencesUtil.getValue(YahooWebSearchConstants.APPLICATION_ID,
                    YahooWebSearchConstants.DEFAULT_APPLICATION_ID);
        }
        return applicationId;
    }

    /**
     * @param applicationId The applicationId to set.
     */
    public void setApplicationId(String applicationId)
    {
        this.applicationId = applicationId;
    }

    public void storeMaxResults() throws IOException
    {
        PortletPreferencesUtil.setValue(YahooWebSearchConstants.MAX_RESULTS, maxResults.toString());
        maxResults = null;
    }

    /**
     * @return Returns the maxResults.
     */
    public Integer getMaxResults()
    {
        if (maxResults == null)
        {
            try
            {
                maxResults = new Integer(Integer.parseInt(PortletPreferencesUtil.getValue(
                        YahooWebSearchConstants.MAX_RESULTS, "10")));
            }
            catch (NumberFormatException e)
            {
                maxResults = new Integer(10);
            }
        }
        return maxResults;
    }

    /**
     * @param maxResults The maxResults to set.
     */
    public void setMaxResults(Integer maxResults)
    {
        this.maxResults = maxResults;
    }

    /**
     * @return Returns the startPosition.
     */
    public Integer getStartPosition()
    {
        if (startPosition == null)
        {
            startPosition = new Integer(1);
        }
        return startPosition;
    }

    /**
     * @param startPosition The startPosition to set.
     */
    public void setStartPosition(Integer startPosition)
    {
        this.startPosition = startPosition;
    }

    /**
     * @return Returns the query.
     */
    public String getQuery()
    {
        return query;
    }

    /**
     * @param query The query to set.
     */
    public void setQuery(String query)
    {
        this.query = query;
    }
}
