<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
    <h:form>
        <h:outputText value="#{facesPortlet.msgSuccess}" styleClass="portlet-msg-success" escape="false" rendered="#{facesPortlet.isMsgSuccess}"/>
        <h:outputText value="#{facesPortlet.msgError}" styleClass="portlet-msg-error" escape="false" rendered="#{facesPortlet.isMsgError}"/>
        <h:outputText value="#{facesPortlet.msgAlert}" styleClass="portlet-msg-alert" escape="false" rendered="#{facesPortlet.isMsgAlert}"/>
        <h:outputText value="#{facesPortlet.msgInfo}" styleClass="portlet-msg-info" escape="false" rendered="#{facesPortlet.isMsgInfo}"/>

        <t:div styleClass="portlet-section-header" style="width:100%;">
            <h:outputText value="Parameters"/>
        </t:div>
        <t:panelGrid 
            columns="3"
            >
            <h:outputLabel for="appid">
                <h:outputText value="Application ID:"/>
            </h:outputLabel>
            <h:inputText id="appid" value="#{searchSession.applicationId}"/>
            <h:message for="appid" errorClass="portlet-msg-error" fatalClass="portlet-msg-error" infoClass="portlet-msg-info" warnClass="portlet-msg-alert"/>

            <h:outputLabel for="maxResults">
                <h:outputText value="The number of result on page:"/>
            </h:outputLabel>
            <h:inputText id="maxResults" value="#{searchSession.maxResults}" converter="javax.faces.Integer">
                <f:validateLongRange minimum="1" maximum="100"/>
            </h:inputText>
            <h:message for="maxResults" errorClass="portlet-msg-error" fatalClass="portlet-msg-error" infoClass="portlet-msg-info" warnClass="portlet-msg-alert"/>
            
        </t:panelGrid>
        <t:panelGrid 
            columns="1"
            >
            <h:commandButton value="Save" action="#{editPage.save}"/>
        </t:panelGrid>
    </h:form>
</f:view>

