<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
    <h:form>
        <h:panelGrid columns="2">
            <h:inputText value="#{searchSession.query}"/>
            <h:commandButton action="#{searchPage.search}" value="Search"/>
            <f:facet name="footer">
                <h:outputLink value="http://developer.yahoo.co.jp/">
                    <f:verbatim>
                        <h:outputText value="Web Services by Yahoo! JAPAN"/>
                    </f:verbatim>
                </h:outputLink>
            </f:facet>
        </h:panelGrid>
        <br/>

        <h:outputText value="#{facesPortlet.msgSuccess}" styleClass="portlet-msg-success" escape="false" rendered="#{facesPortlet.isMsgSuccess}"/>
        <h:outputText value="#{facesPortlet.msgError}" styleClass="portlet-msg-error" escape="false" rendered="#{facesPortlet.isMsgError}"/>
        <h:outputText value="#{facesPortlet.msgAlert}" styleClass="portlet-msg-alert" escape="false" rendered="#{facesPortlet.isMsgAlert}"/>
        <h:outputText value="#{facesPortlet.msgInfo}" styleClass="portlet-msg-info" escape="false" rendered="#{facesPortlet.isMsgInfo}"/>

        <t:div styleClass="portlet-section-header" style="width:100%;">
            <h:outputText value="Result"/>
        </t:div>
        <t:dataTable
            var="result"
            value="#{searchPage.results}"
            style="width:100%;"
            >
            <t:column>
                <t:panelGrid 
                    style="width:100%;"
                    columns="1"
                    >
                    <h:outputLink value="#{result.clickUrl}">
                        <f:verbatim>
                            <h:outputText value="#{result.title}"/>
                        </f:verbatim>
                    </h:outputLink>
                    <t:panelGrid
                        columns="2"
                        >
                        <h:outputText value="  "/>
                        <h:outputText value="#{result.summary}"/>
                    </t:panelGrid>
                    <t:panelGrid
                        columns="7">
                        <h:outputText value="  "/>
                        <h:outputText value="#{result.url}"/>
                        <h:outputText value="-" rendered="#{result.cache!=null}"/>
                        <h:outputText value="#{result.cache.size}" rendered="#{result.cache!=null}"/>
                        <h:outputText value="byte" rendered="#{result.cache!=null}"/>
                        <h:outputText value="-" rendered="#{result.cache!=null}"/>
                        <h:outputLink value="#{result.cache.url}" rendered="#{result.cache!=null}">
                            <f:verbatim>
                                <h:outputText value="Cache"/>
                            </f:verbatim>
                        </h:outputLink>
                    </t:panelGrid>
                </t:panelGrid>
            </t:column>
        </t:dataTable>
        <h:panelGrid columns="2">
            <t:commandLink action="#{searchPage.previousPage}" rendered="#{searchPage.previousPage}">
                <t:outputText value="<<Previous"/>
            </t:commandLink>
            <t:commandLink action="#{searchPage.nextPage}" rendered="#{searchPage.nextPage}">
                <t:outputText value="Next>>"/>
            </t:commandLink>
        </h:panelGrid>
        <t:htmlTag value="br"/>

    </h:form>
</f:view>

