/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.portlet.faces.PortletPreferencesUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;

import java.io.IOException;
import java.util.ArrayList;

import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogMessage;

public class BlogTitleViewEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogTitleViewEditPageBean.class);

    private String owner;

    private String sortColumn;

    private Integer pageSize;

    private Object[] displayedItems;

    private BlogTitleViewPortletBean titleViewPortlet;

    public String save()
    {
        if (log.isDebugEnabled())
        {
            log.debug("save() - start");
        }

        try
        {
            getTitleViewPortlet().setOwner(owner);
            getTitleViewPortlet().setPageSize(pageSize);
            getTitleViewPortlet().setSortColumn(sortColumn);

            if (displayedItems != null)
            {
                String createdtime = BlogConstants.FALSE;
                String updatedtime = BlogConstants.FALSE;
                for (int i = 0; i < displayedItems.length; i++)
                {
                    if (displayedItems[i].equals(BlogMessage.CREATEDTIME))
                    {
                        createdtime = BlogConstants.TRUE;
                    }
                    else if (displayedItems[i].equals(BlogMessage.UPDATEDTIME))
                    {
                        updatedtime = BlogConstants.TRUE;
                    }
                }

                if (!getTitleViewPortlet().getDisplayCreatedtime().equals(createdtime))
                {
                    getTitleViewPortlet().setDisplayCreatedtime(new Boolean(createdtime));
                }
                if (!getTitleViewPortlet().getDisplayUpdatedtime().equals(updatedtime))
                {
                    getTitleViewPortlet().setDisplayUpdatedtime(new Boolean(updatedtime));
                }

                PortletPreferencesUtil.store();

                // i18n
                titleViewPortlet.addMsgSuccess(PortletResourceBundleUtil.getString("blogtitleview.UpdatedParameters"));

            }
            else
            {
                // i18n
                titleViewPortlet.addMsgError(PortletResourceBundleUtil
                        .getString("blogtitleview.TheSpecifiedItemsAreInvalid"));
                if (log.isDebugEnabled())
                {
                    log.debug("setDisplayedItems(Object[]) - items is null.");
                }
            }

        }
        catch (IOException e)
        {
            // i18n
            titleViewPortlet.addMsgError(PortletResourceBundleUtil.getString("blogtitleview.SystemErrorOccurs"));
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("save() - end");
        }
        return null;
    }

    public String reset()
    {
        if (log.isDebugEnabled())
        {
            log.debug("reset() - start");
        }

        try
        {
            getTitleViewPortlet().setOwner(FacesContext.getCurrentInstance().getExternalContext().getRemoteUser());
            getTitleViewPortlet().setPageSize(new Integer(BlogConstants.DEFAULT_PAGE_SIZE));
            getTitleViewPortlet().setSortColumn(BlogMessage.CREATEDTIME);
            getTitleViewPortlet().setDisplayCreatedtime(new Boolean(BlogConstants.FALSE));
            getTitleViewPortlet().setDisplayUpdatedtime(new Boolean(BlogConstants.FALSE));

            PortletPreferencesUtil.store();

            // i18n
            titleViewPortlet.addMsgSuccess(PortletResourceBundleUtil
                    .getString("blogtitleview.UpdatedToDefaultParameters"));
        }
        catch (IOException e)
        {
            // i18n
            titleViewPortlet.addMsgError(PortletResourceBundleUtil.getString("blogtitleview.SystemErrorOccurs"));
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("reset() - end");
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - end");
        }
        //        return pageSize;
        return titleViewPortlet.getPageSize();
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer number)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - start");
        }

        this.pageSize = number;

        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - end");
        }
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - end");
        }
        //return owner;
        return titleViewPortlet.getOwner();
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String targetUser)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - start");
        }

        this.owner = targetUser;

        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - end");
        }
    }

    /**
     * @return Returns the titleViewPortlet.
     */
    public BlogTitleViewPortletBean getTitleViewPortlet()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - end");
        }
        return titleViewPortlet;
    }

    /**
     * @param titleViewPortlet The titleViewPortlet to set.
     */
    public void setTitleViewPortlet(BlogTitleViewPortletBean titleViewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewPortletBean) - start");
        }

        this.titleViewPortlet = titleViewPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewPortletBean) - end");
        }
    }

    /**
     * @return Returns the sortColumn.
     */
    public String getSortColumn()
    {
        return getTitleViewPortlet().getSortColumn();
    }

    /**
     * @param sortColumn The sortColumn to set.
     */
    public void setSortColumn(String sortColumn)
    {
        this.sortColumn = sortColumn;
    }

    public Object[] getDisplayedItems()
    {
        ArrayList items = new ArrayList();
        if (getTitleViewPortlet().getDisplayCreatedtime().booleanValue())
        {
            items.add(BlogMessage.CREATEDTIME);
        }
        if (getTitleViewPortlet().getDisplayUpdatedtime().booleanValue())
        {
            items.add(BlogMessage.UPDATEDTIME);
        }
        return items.toArray();
    }

    public void setDisplayedItems(Object[] items)
    {
        displayedItems = items;
    }

}
