/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;

import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;

import com.marevol.utils.portlet.faces.PortletPreferencesUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;

public class BlogViewEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogViewEditPageBean.class);

    private String owner;

    private Integer pageSize;

    private BlogViewPortletBean viewPortlet;

    public String save()
    {
        if (log.isDebugEnabled())
        {
            log.debug("save() - start");
        }

        try
        {
            getViewPortlet().setOwner(owner);
            getViewPortlet().setPageSize(pageSize);

            PortletPreferencesUtil.store();

            // i18n
            viewPortlet.addMsgSuccess(PortletResourceBundleUtil.getString("blogview.UpdatedParameters"));
        }
        catch (IOException e)
        {
            // i18n
            viewPortlet.addMsgError(PortletResourceBundleUtil.getString("blogview.SystemErrorOccurs"));
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("save() - end");
        }
        return null;
    }

    public String reset()
    {
        if (log.isDebugEnabled())
        {
            log.debug("reset() - start");
        }

        try
        {
            getViewPortlet().setOwner(FacesContext.getCurrentInstance().getExternalContext().getRemoteUser());
            getViewPortlet().setPageSize(new Integer(BlogConstants.DEFAULT_PAGE_SIZE));

            PortletPreferencesUtil.store();

            // i18n
            viewPortlet.addMsgSuccess(PortletResourceBundleUtil.getString("blogview.UpdatedToDefaultParameters"));
        }
        catch (IOException e)
        {
            // i18n
            viewPortlet.addMsgError(PortletResourceBundleUtil.getString("blogview.SystemErrorOccurs"));
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("reset() - end");
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - end");
        }
        //        return pageSize;
        return viewPortlet.getPageSize();
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer number)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - start");
        }

        this.pageSize = number;

        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - end");
        }
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - end");
        }
        //return owner;
        return viewPortlet.getOwner();
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String targetUser)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - start");
        }

        this.owner = targetUser;

        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - end");
        }
    }

    /**
     * @return Returns the viewPortlet.
     */
    public BlogViewPortletBean getViewPortlet()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - end");
        }
        return viewPortlet;
    }

    /**
     * @param viewPortlet The viewPortlet to set.
     */
    public void setViewPortlet(BlogViewPortletBean viewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewPortletBean) - start");
        }

        this.viewPortlet = viewPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewPortletBean) - end");
        }
    }

}
