/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import java.io.IOException;

import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;

import com.marevol.utils.portlet.faces.PortletPreferencesUtil;
import com.marevol.utils.portlet.faces.bean.FacesPortletBean;

public class BlogViewPortletBean extends FacesPortletBean
{

    public BlogViewPortletBean()
    {
        super();
    }

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {

        return new Integer(PortletPreferencesUtil.getValue(BlogConstants.VIEW_PAGE_SIZE, Integer
                .toString(BlogConstants.DEFAULT_PAGE_SIZE)));
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer maxResults) throws IOException
    {

        PortletPreferencesUtil.setValue(BlogConstants.VIEW_PAGE_SIZE, maxResults.toString());

    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {

        return PortletPreferencesUtil.getValue(BlogConstants.VIEW_OWNER, FacesContext.getCurrentInstance()
                .getExternalContext().getRemoteUser());
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String owner) throws IOException
    {

        PortletPreferencesUtil.setValue(BlogConstants.VIEW_OWNER, owner);

    }
}
