/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

/**
 * BlogComment generated by hbm2java
 */
public class BlogComment implements java.io.Serializable
{

    // Fields    

    /**
     * 
     */
    private static final long serialVersionUID = 562524292609035239L;

    private Long id;

    private BlogMessage blogMessage;

    private String name;

    private String email;

    private String url;

    private String message;

    private Date createdtime;

    // Constructors

    /** default constructor */
    public BlogComment()
    {
    }

    /** constructor with id */
    public BlogComment(Long id)
    {
        this.id = id;
    }

    // Property accessors

    /**
     * 
     */
    public Long getId()
    {
        return this.id;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * 
     */
    public BlogMessage getBlogMessage()
    {
        return this.blogMessage;
    }

    public void setBlogMessage(BlogMessage blogMessage)
    {
        this.blogMessage = blogMessage;
    }

    /**
     * 
     */
    public String getName()
    {
        return this.name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * 
     */
    public String getEmail()
    {
        return this.email;
    }

    public void setEmail(String email)
    {
        this.email = email;
    }

    /**
     * 
     */
    public String getUrl()
    {
        if (url.startsWith("http://") || url.startsWith("https://"))
        {
            return this.url;
        }
        return "";
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    /**
     * 
     */
    public String getMessage()
    {
        return this.message;
    }

    public void setMessage(String message)
    {
        this.message = message;
    }

    /**
     * 
     */
    public Date getCreatedtime()
    {
        return this.createdtime;
    }

    public void setCreatedtime(Date createdtime)
    {
        this.createdtime = createdtime;
    }

    // for view
    private String getFormattedDate(Date d)
    {
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        Locale locale = null;
        if (viewRoot != null)
        {
            locale = viewRoot.getLocale();
        }
        else
        {
            locale = Locale.ENGLISH;
        }

        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, locale);
        return df.format(d);
    }

    public String getFormattedCreatedtime()
    {
        return getFormattedDate(getCreatedtime());
    }

    public Boolean getDeleteEnabled()
    {
        String user = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        if (user == null)
        {
            return Boolean.FALSE;
        }

        if (user.equals(getBlogMessage().getOwner()))
        {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;

    }
}
