/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.util.BlogCommentComparator;
import jp.sf.pal.blog.util.BlogTrackbackComparator;

import org.apache.commons.lang.StringUtils;

import com.marevol.utils.portlet.faces.RenderResponseUtil;

/**
 * BlogMessage generated by hbm2java
 */
public class BlogMessage implements java.io.Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = -5551793167782445984L;

    public static final String ID = "id";

    public static final String OWNER = "owner";

    public static final String TITLE = "title";

    public static final String MESSAGE = "message";

    public static final String CREATEDTIME = "createdtime";

    public static final String UPDATEDTIME = "updatedtime";

    // Fields    

    private Long id;

    private BlogCategory blogcategory;

    private String owner;

    private String title;

    private String message;

    private String formattype;

    private Date createdtime;

    private Date updatedtime;

    private Set blogcomments;

    private Set blogtrackbacks;

    // Constructors

    /** default constructor */
    public BlogMessage()
    {
    }

    /** constructor with id */
    public BlogMessage(Long id)
    {
        this.id = id;
    }

    // Property accessors

    /**
     * 
     */
    public Long getId()
    {
        return this.id;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * 
     */
    public BlogCategory getBlogCategory()
    {
        return this.blogcategory;
    }

    public void setBlogCategory(BlogCategory blogcategory)
    {
        this.blogcategory = blogcategory;
    }

    /**
     * 
     */
    public String getOwner()
    {
        return this.owner;
    }

    public void setOwner(String owner)
    {
        this.owner = owner;
    }

    /**
     * 
     */
    public String getTitle()
    {
        return this.title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * 
     */
    public String getMessage()
    {
        return this.message;
    }

    public void setMessage(String message)
    {
        this.message = message;
    }

    /**
     * 
     */
    public String getFormattype()
    {
        return this.formattype;
    }

    public void setFormattype(String formattype)
    {
        this.formattype = formattype;
    }

    /**
     * 
     */
    public Date getCreatedtime()
    {
        return this.createdtime;
    }

    public void setCreatedtime(Date createdtime)
    {
        this.createdtime = createdtime;
    }

    /**
     * 
     */
    public Date getUpdatedtime()
    {
        return this.updatedtime;
    }

    public void setUpdatedtime(Date updatedtime)
    {
        this.updatedtime = updatedtime;
    }

    /**
     * 
     */
    public Set getBlogComments()
    {
        return this.blogcomments;
    }

    public void setBlogComments(Set blogcomments)
    {
        this.blogcomments = blogcomments;
    }

    /**
     * 
     */
    public Set getBlogTrackbacks()
    {
        return this.blogtrackbacks;
    }

    public void setBlogTrackbacks(Set blogtrackbacks)
    {
        this.blogtrackbacks = blogtrackbacks;
    }

    public String getRedirectUrl()
    {
        StringBuffer redirectUrl = new StringBuffer();
        String url = RenderResponseUtil.createRenderURL().toString();
        redirectUrl.append(url);
        if (url.indexOf("?") < 0)
        {
            redirectUrl.append("?");
        }
        else
        {
            redirectUrl.append("&");
        }
        redirectUrl.append("blogid");
        redirectUrl.append("=");
        redirectUrl.append(getId().toString());

        return redirectUrl.toString();
    }

    public void setRedirectUrl(String url)
    {
        // NONE
    }

    public String getFormattedMessage()
    {
        if (getFormattype().equals(BlogConstants.TEXT_FORMAT_TYPE))
        {
            String msg = getMessage();
            return msg.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n",
                    "<br/>");
        }
        return getMessage();
    }

    // for view
    private String getFormattedDate(Date d)
    {
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        Locale locale = null;
        if (viewRoot != null)
        {
            locale = viewRoot.getLocale();
        }
        else
        {
            locale = Locale.ENGLISH;
        }

        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, locale);
        return df.format(d);
    }

    public String getFormattedUpdatedtime()
    {
        return getFormattedDate(getUpdatedtime());
    }

    public String getFormattedCreatedtime()
    {
        return getFormattedDate(getCreatedtime());
    }

    public String getAbbreviatedTitle()
    {
        return getAbbreviatedTitle(BlogConstants.DEFAULT_TITLE_MAX_LENGTH);
    }

    public String getAbbreviatedTitle(int maxLength)
    {
        return StringUtils.abbreviate(getTitle(), maxLength);
    }

    public void setAbbreviatedTitle(String title)
    {
        setTitle(title);
    }

    public int getBlogCommentSize()
    {
        return getBlogComments().size();
    }

    public int getBlogTrackbackSize()
    {
        return getBlogTrackbacks().size();
    }

    public String getTrackbackUrl()
    {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath() + "/trackback/" + getId();
    }

    public Set getSortedBlogComments()
    {
        TreeSet ts = new TreeSet(new BlogCommentComparator(BlogCommentComparator.ASC));
        ts.addAll(getBlogComments());
        return (Set) ts;
    }

    public Set getSortedBlogTrackbacks()
    {
        TreeSet ts = new TreeSet(new BlogTrackbackComparator(BlogTrackbackComparator.ASC));
        ts.addAll(getBlogTrackbacks());
        return (Set) ts;
    }
}
