package jp.sf.pal.blog.util;

import java.util.Comparator;

import jp.sf.pal.blog.model.BlogComment;

public class BlogCommentComparator implements Comparator
{
    public static final int ASC = 1;

    public static final int DESC = -1;

    private int order = 0;

    public BlogCommentComparator(int order)
    {
        this.order = order;
    }

    public int compare(Object o1, Object o2)
    {
        if (o1 instanceof BlogComment && o2 instanceof BlogComment)
        {
            BlogComment bc1 = (BlogComment) o1;
            BlogComment bc2 = (BlogComment) o2;
            return bc1.getCreatedtime().compareTo(bc2.getCreatedtime()) * order;
        }
        return 0;
    }

}
