package jp.sf.pal.blog.util;

import java.util.Comparator;

import jp.sf.pal.blog.model.BlogTrackback;

public class BlogTrackbackComparator implements Comparator
{
    public static final int ASC = 1;

    public static final int DESC = -1;

    private int order = 0;

    public BlogTrackbackComparator(int order)
    {
        this.order = order;
    }

    public int compare(Object o1, Object o2)
    {
        if (o1 instanceof BlogTrackback && o2 instanceof BlogTrackback)
        {
            BlogTrackback bt1 = (BlogTrackback) o1;
            BlogTrackback bt2 = (BlogTrackback) o2;
            return bt1.getCreatedtime().compareTo(bt2.getCreatedtime()) * order;
        }
        return 0;
    }

}
