<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
    <h:form>
    <f:loadBundle basename="jp.sf.pal.blog.resources.BlogViewResources" var="msgs"/>
        <h:outputText value="#{viewPortlet.msgSuccess}" styleClass="portlet-msg-success" escape="false" rendered="#{viewPortlet.isMsgSuccess}"/>
        <h:outputText value="#{viewPortlet.msgError}" styleClass="portlet-msg-error" escape="false" rendered="#{viewPortlet.isMsgError}"/>
        <h:outputText value="#{viewPortlet.msgAlert}" styleClass="portlet-msg-alert" escape="false" rendered="#{viewPortlet.isMsgAlert}"/>
        <h:outputText value="#{viewPortlet.msgInfo}" styleClass="portlet-msg-info" escape="false" rendered="#{viewPortlet.isMsgInfo}"/>
        <h:panelGrid border="0" columns="2">
            <h:outputLabel for="owner">
                <h:outputText value="#{msgs['blogview.TargetUserName']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:inputText id="owner" value="#{viewEditPage.owner}" size="30" styleClass="portlet-form-field-label"/>
            
            <h:outputLabel for="number">
                <h:outputText value="#{msgs['blogview.TheNumberOfBlogItem']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:inputText id="number" value="#{viewEditPage.pageSize}" size="30" styleClass="portlet-form-field-label" converter="javax.faces.Integer" required="true">
                <f:validateLongRange minimum="1"/>
            </h:inputText>

            <h:commandButton action="#{viewEditPage.save}" value="#{msgs['blogview.Save']}" styleClass="portlet-form-button"/>
            <h:commandButton action="#{viewEditPage.reset}" value="#{msgs['blogview.Reset']}" styleClass="portlet-form-button"/>
        </h:panelGrid>
    </h:form>
</f:view>
