package jp.sf.pal.todolist.bean;

import java.util.Date;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import jp.sf.pal.todolist.TodoListConstants;
import jp.sf.pal.todolist.model.Todo;
import jp.sf.pal.todolist.util.TodoListDaoUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.util.DateFormatUtil;
import com.marevol.utils.portlet.faces.PortletConfigUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;
import com.marevol.utils.util.DateUtil;

public class TodoListEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(TodoListEditPageBean.class);

    private String title;

    private String description;

    private String owner;

    private Date dueDate;

    private Integer dueHour;

    private Integer dueMin;

    private boolean publicView;

    private Date createdtime;

    private String status;

    private TodoListViewSessionBean todoListViewSession;

    private Long id;

    private Boolean validUser;

    public String update()
    {

        if (id != null)
        {
            Todo todo = TodoListDaoUtil.getTodoDao().getTodoById(id.longValue());
            todo.setTitle(getTitle());
            todo.setDescription(getDescription());
            todo.setOwner(getOwner());
            if (isPublicView())
            {
                todo.setViewmode(TodoListConstants.PUBLIC_VIEW_MODE);
            }
            else
            {
                todo.setViewmode(TodoListConstants.PRIVATE_VIEW_MODE);
            }
            todo.setStatus(getStatus());
            todo.setDuedate(DateUtil.get(DateUtil.getYear(dueDate), DateUtil.getMonth(dueDate), DateUtil
                    .getDate(dueDate), getDueHour().intValue(), getDueMin().intValue(), 0, 0));

            TodoListDaoUtil.getTodoDao().saveOrUpdate(todo);

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                    .getString("todolisteditpagebean.UpdatedTheToDoTask"));

            return TodoListConstants.TODOLISTVIEW_VIEW_ID;
        }
        else
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString("todolisteditpagebean.TheTaskIsNull"));

            return TodoListConstants.TODOLISTVIEW_VIEW_ID;
        }
    }

    public String delete()
    {

        if (id != null)
        {
            Todo todo = TodoListDaoUtil.getTodoDao().getTodoById(id.longValue());
            TodoListDaoUtil.getTodoDao().delete(todo);

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                    .getString("todolisteditpagebean.DeletedTheToDoTask"));

            return TodoListConstants.TODOLISTVIEW_VIEW_ID;
        }
        else
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString("todolisteditpagebean.TheTaskIsNull"));

            return TodoListConstants.TODOLISTVIEW_VIEW_ID;
        }
    }
    public String back()
    {
        return TodoListConstants.TODOLISTVIEW_VIEW_ID;

    }

    public SelectItem[] getDueHourItems()
    {
        return TodoListConstants.HOURS_FOR_MENU;
    }

    public SelectItem[] getDueMinItems()
    {
        return TodoListConstants.MINUTES_FOR_MENU;
    }

    public SelectItem[] getStatusItems()
    {
        return new SelectItem[] { new SelectItem(TodoListConstants.STATUS_0, TodoListConstants.PROGRESS_0),
                new SelectItem(TodoListConstants.STATUS_10, TodoListConstants.PROGRESS_10),
                new SelectItem(TodoListConstants.STATUS_20, TodoListConstants.PROGRESS_20),
                new SelectItem(TodoListConstants.STATUS_30, TodoListConstants.PROGRESS_30),
                new SelectItem(TodoListConstants.STATUS_40, TodoListConstants.PROGRESS_40),
                new SelectItem(TodoListConstants.STATUS_50, TodoListConstants.PROGRESS_50),
                new SelectItem(TodoListConstants.STATUS_60, TodoListConstants.PROGRESS_60),
                new SelectItem(TodoListConstants.STATUS_70, TodoListConstants.PROGRESS_70),
                new SelectItem(TodoListConstants.STATUS_80, TodoListConstants.PROGRESS_80),
                new SelectItem(TodoListConstants.STATUS_90, TodoListConstants.PROGRESS_90),
                new SelectItem(TodoListConstants.STATUS_100, TodoListConstants.PROGRESS_100), };
    }

    /**
     * @return Returns the createdtime.
     */
    public Date getCreatedtime()
    {
        return createdtime;
    }

    /**
     * @param createdtime The createdtime to set.
     */
    public void setCreatedtime(Date createdtime)
    {
        this.createdtime = createdtime;
    }

    /**
     * @return Returns the description.
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @param description The description to set.
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * @return Returns the dueDate.
     */
    public Date getDueDate()
    {
        return dueDate;
    }

    /**
     * @param dueDate The dueDate to set.
     */
    public void setDueDate(Date dueDate)
    {
        this.dueDate = dueDate;
    }

    /**
     * @return Returns the dueHour.
     */
    public Integer getDueHour()
    {
        return dueHour;
    }

    /**
     * @param dueHour The dueHour to set.
     */
    public void setDueHour(Integer dueHour)
    {
        this.dueHour = dueHour;
    }

    /**
     * @return Returns the dueMin.
     */
    public Integer getDueMin()
    {
        return dueMin;
    }

    /**
     * @param dueMin The dueMin to set.
     */
    public void setDueMin(Integer dueMin)
    {
        this.dueMin = dueMin;
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        return owner;
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String owner)
    {
        this.owner = owner;
    }

    /**
     * @return Returns the publicView.
     */
    public boolean isPublicView()
    {
        return publicView;
    }

    /**
     * @param publicView The publicView to set.
     */
    public void setPublicView(boolean publicView)
    {
        this.publicView = publicView;
    }

    /**
     * @return Returns the status.
     */
    public String getStatus()
    {
        return status;
    }

    /**
     * @param status The status to set.
     */
    public void setStatus(String status)
    {
        this.status = status;
    }

    /**
     * @return Returns the title.
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * @param title The title to set.
     */
    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * @return Returns the todoListViewSession.
     */
    public TodoListViewSessionBean getTodoListViewSession()
    {
        return todoListViewSession;
    }

    /**
     * @param todoListViewSession The todoListViewSession to set.
     */
    public void setTodoListViewSession(TodoListViewSessionBean todoListViewSession)
    {
        this.todoListViewSession = todoListViewSession;
        if (todoListViewSession != null)
        {
            Todo todo = getTodoListViewSession().getTodo();
            if (todo != null)
            {
                setTitle(todo.getTitle());
                setDescription(todo.getDescription());
                setDueDate(todo.getDuedate());
                if (todo.getDuedate() != null)
                {
                    try
                    {
                        setDueHour(new Integer(DateUtil.getHours(todo.getDuedate())));
                    }
                    catch (RuntimeException e)
                    {
                        log.warn(e);
                        setDueHour(new Integer(0));
                    }
                    try
                    {
                        setDueMin(new Integer(DateUtil.getMinutes(todo.getDuedate())));
                    }
                    catch (RuntimeException e)
                    {
                        log.warn(e);
                        setDueMin(new Integer(0));
                    }
                }
                else
                {
                    setDueHour(new Integer(0));
                    setDueMin(new Integer(0));
                }
                setOwner(todo.getOwner());
                if (todo.getViewmode().equals(TodoListConstants.PUBLIC_VIEW_MODE))
                {
                    setPublicView(true);
                }
                else
                {
                    setPublicView(false);
                }
                setStatus(todo.getStatus());
                setId(new Long(todo.getId()));
            }
            else
            {
                // i18n
                FacesMessageUtil.addWarnMessage(PortletResourceBundleUtil
                        .getString("todolistviewedit.TheSpecifiedToDoTaskIsNotFound"));
            }
        }
    }

    /**
     * @return Returns the id.
     */
    public Long getId()
    {
        return id;
    }

    /**
     * @param id The id to set.
     */
    public void setId(Long id)
    {
        this.id = id;
    }

    public Boolean getValidUser()
    {
        if (validUser == null)
        {
            String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
            if (username != null)
            {
                if (getOwner().equals(""))
                {
                    validUser = Boolean.TRUE;
                }
                else if (username.equals(PortletConfigUtil
                        .getInitParameter(TodoListConstants.ADMIN_USERNAME_INIT_PARAM))
                        || username.equals(getOwner()))
                {
                    validUser = Boolean.TRUE;
                }
                else
                {
                    validUser = Boolean.FALSE;
                }
            }
            else
            {
                validUser = Boolean.FALSE;
            }
        }
        return validUser;
    }

    public String getFormattedDueDate()
    {
        return DateFormatUtil.getShortFormattedDateTime(getDueDate());
    }
}
