<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.todolist.resources.TodoListResources"
		var="msgs" />

	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />
		<h:panelGrid columns="3">
			<h:outputLabel for="title">
				<h:outputText value="#{msgs['todolistadd.Title']}" />
			</h:outputLabel>
			<h:inputText id="title" value="#{todoListAddPage.title}"
				maxlength="64" />
			<h:message for="title"></h:message>

			<h:outputLabel for="description">
				<h:outputText value="#{msgs['todolistadd.Description']}" />
			</h:outputLabel>
			<h:inputText id="description" value="#{todoListAddPage.description}"
				maxlength="255" />
			<h:message for="description"></h:message>

			<h:outputLabel for="duedate">
				<h:outputText value="#{msgs['todolistadd.DueDate']}" />
			</h:outputLabel>
			<h:panelGrid columns="4" id="duedate">
				<t:inputCalendar id="duecal" value="#{todoListAddPage.dueDate}"
					required="true" renderAsPopup="true" popupTodayString="Today"
					popupWeekString="Wk" popupDateFormat="yyyy-MM-dd"
					renderPopupButtonAsImage="true" />
				<h:selectOneMenu value="#{todoListAddPage.dueHour}">
					<f:selectItems value="#{todoListAddPage.dueHourItems}" />
				</h:selectOneMenu>
				<h:outputText value="#{msgs['todolistadd.colon']}" />
				<h:selectOneMenu value="#{todoListAddPage.dueMin}">
					<f:selectItems value="#{todoListAddPage.dueMinItems}" />
				</h:selectOneMenu>
			</h:panelGrid>
			<h:message for="duecal"></h:message>

			<h:outputLabel for="publicview">
				<h:outputText value="#{msgs['todolistadd.Public']}" />
			</h:outputLabel>
			<h:selectBooleanCheckbox id="publicview"
				value="#{todoListAddPage.publicView}" />
			<h:message for="publicview"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="2">
			<h:commandButton action="#{todoListAddPage.save}"
				value="#{msgs['todolistadd.Add']}" />
			<h:commandButton action="#{todoListAddPage.back}"
				value="#{msgs['todolistadd.Back']}" immediate="true" />
		</h:panelGrid>
	</h:form>

</f:view>
