/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Calendar;
import java.util.Date;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import jp.sf.pal.addresslist.AddressListConstants;
import jp.sf.pal.addresslist.model.Custom;
import jp.sf.pal.addresslist.model.Online;
import jp.sf.pal.addresslist.model.Postal;
import jp.sf.pal.addresslist.model.Telecom;
import jp.sf.pal.addresslist.model.User;
import jp.sf.pal.addresslist.util.AddressListDaoUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.portlet.faces.PortletConfigUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;

public class AddressListAddPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(AddressListAddPageBean.class);

    private String familyname;

    private String givenname;

    private String middlename;

    private String nameprefix;

    private String namesuffix;

    private String nickname;

    private Date bdate;

    private String gender;

    private String employer;

    private String department;

    private String jobtitle;

    private String homeEmail1;

    private String homeEmail2;

    private String homeEmail3;

    private String businessEmail1;

    private String businessEmail2;

    private String businessEmail3;

    private String homeUrl1;

    private String homeUrl2;

    private String homeUrl3;

    private String businessUrl1;

    private String businessUrl2;

    private String businessUrl3;

    private String homeCountry;

    private String homePostalcode;

    private String homeStateprov;

    private String homeCity;

    private String homeStreet;

    private String homeName;

    private String homeOrganization;

    private String homeTelephoneIntcode;

    private String homeTelephoneLoccode;

    private String homeTelephoneNumber;

    private String homeTelephoneExt;

    private String homeTelephoneComment;

    private String homeFaxIntcode;

    private String homeFaxLoccode;

    private String homeFaxNumber;

    private String homeFaxExt;

    private String homeFaxComment;

    private String homeMobileIntcode;

    private String homeMobileLoccode;

    private String homeMobileNumber;

    private String homeMobileExt;

    private String homeMobileComment;

    private String homePagerIntcode;

    private String homePagerLoccode;

    private String homePagerNumber;

    private String homePagerExt;

    private String homePagerComment;

    private String businessCountry;

    private String businessPostalcode;

    private String businessStateprov;

    private String businessCity;

    private String businessStreet;

    private String businessName;

    private String businessOrganization;

    private String businessTelephoneIntcode;

    private String businessTelephoneLoccode;

    private String businessTelephoneNumber;

    private String businessTelephoneExt;

    private String businessTelephoneComment;

    private String businessFaxIntcode;

    private String businessFaxLoccode;

    private String businessFaxNumber;

    private String businessFaxExt;

    private String businessFaxComment;

    private String businessMobileIntcode;

    private String businessMobileLoccode;

    private String businessMobileNumber;

    private String businessMobileExt;

    private String businessMobileComment;

    private String businessPagerIntcode;

    private String businessPagerLoccode;

    private String businessPagerNumber;

    private String businessPagerExt;

    private String businessPagerComment;

    private String custom1;

    private String custom2;

    private String custom3;

    private String custom4;

    public String save()
    {
        if (log.isDebugEnabled())
        {
            log.debug("save() - start");
        }

        String publicListString = PortletConfigUtil.getInitParameter(AddressListConstants.PUBLIC_LIST_PARAM);
        String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        if ((publicListString != null && publicListString.equalsIgnoreCase("true")) || username != null)
        {

            if (username == null)
            {
                username = AddressListConstants.GUEST_USERNAME;
            }

            try
            {
                User user = new User();
                if (bdate != null)
                {
                    user.setBdate(bdate);
                }
                else
                {
                    user.setBdate(new Date(1));
                }
                user.setDepartment(department);
                user.setEmployer(employer);
                user.setFamilyname(familyname);
                user.setGender(gender);
                user.setGivenname(givenname);
                user.setJobtitle(jobtitle);
                user.setMiddlename(middlename);
                user.setNameprefix(nameprefix);
                user.setNamesuffix(namesuffix);
                user.setNickname(nickname);
                user.setOwner(username);
                user.setUpdatedtime(Calendar.getInstance().getTime());

                AddressListDaoUtil.getUserDao().save(user);

                Postal hPostal = new Postal();
                hPostal.setCity(homeCity);
                hPostal.setCountry(homeCountry);
                hPostal.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hPostal.setName(homeName);
                hPostal.setNum(new Integer(0));
                hPostal.setOrganization(homeOrganization);
                hPostal.setPostalcode(homePostalcode);
                hPostal.setStateprov(homeStateprov);
                hPostal.setStreet(homeStreet);
                hPostal.setUser(user);

                AddressListDaoUtil.getPostalDao().save(hPostal);

                Postal bPostal = new Postal();
                bPostal.setCity(businessCity);
                bPostal.setCountry(businessCountry);
                bPostal.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bPostal.setName(businessName);
                bPostal.setNum(new Integer(0));
                bPostal.setOrganization(businessOrganization);
                bPostal.setPostalcode(businessPostalcode);
                bPostal.setStateprov(businessStateprov);
                bPostal.setStreet(businessStreet);
                bPostal.setUser(user);

                AddressListDaoUtil.getPostalDao().save(bPostal);

                Telecom hTelephone = new Telecom();
                hTelephone.setComment(homeTelephoneComment);
                hTelephone.setExt(homeTelephoneExt);
                hTelephone.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hTelephone.setIntcode(homeTelephoneIntcode);
                hTelephone.setLoccode(homeTelephoneLoccode);
                hTelephone.setNum(new Integer(0));
                hTelephone.setNumber(homeTelephoneNumber);
                hTelephone.setTelecomtype(AddressListConstants.TELECOMTYPE_TELEPHONE);
                hTelephone.setUser(user);

                AddressListDaoUtil.getTelecomDao().save(hTelephone);

                Telecom hMobile = new Telecom();
                hMobile.setComment(homeMobileComment);
                hMobile.setExt(homeMobileExt);
                hMobile.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hMobile.setIntcode(homeMobileIntcode);
                hMobile.setLoccode(homeMobileLoccode);
                hMobile.setNum(new Integer(0));
                hMobile.setNumber(homeMobileNumber);
                hMobile.setTelecomtype(AddressListConstants.TELECOMTYPE_MOBILE);
                hMobile.setUser(user);

                AddressListDaoUtil.getTelecomDao().save(hMobile);

                Telecom hFax = new Telecom();
                hFax.setComment(homeFaxComment);
                hFax.setExt(homeFaxExt);
                hFax.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hFax.setIntcode(homeFaxIntcode);
                hFax.setLoccode(homeFaxLoccode);
                hFax.setNum(new Integer(0));
                hFax.setNumber(homeFaxNumber);
                hFax.setTelecomtype(AddressListConstants.TELECOMTYPE_FAX);
                hFax.setUser(user);

                AddressListDaoUtil.getTelecomDao().save(hFax);

                Telecom hPager = new Telecom();
                hPager.setComment(homePagerComment);
                hPager.setExt(homePagerExt);
                hPager.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hPager.setIntcode(homePagerIntcode);
                hPager.setLoccode(homePagerLoccode);
                hPager.setNum(new Integer(0));
                hPager.setNumber(homePagerNumber);
                hPager.setTelecomtype(AddressListConstants.TELECOMTYPE_PAGER);
                hPager.setUser(user);

                AddressListDaoUtil.getTelecomDao().save(hPager);

                Telecom bTelephone = new Telecom();
                bTelephone.setComment(businessTelephoneComment);
                bTelephone.setExt(businessTelephoneExt);
                bTelephone.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bTelephone.setIntcode(businessTelephoneIntcode);
                bTelephone.setLoccode(businessTelephoneLoccode);
                bTelephone.setNum(new Integer(0));
                bTelephone.setNumber(businessTelephoneNumber);
                bTelephone.setTelecomtype(AddressListConstants.TELECOMTYPE_TELEPHONE);
                bTelephone.setUser(user);

                AddressListDaoUtil.getTelecomDao().save(bTelephone);

                Telecom bMobile = new Telecom();
                bMobile.setComment(businessMobileComment);
                bMobile.setExt(businessMobileExt);
                bMobile.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bMobile.setIntcode(businessMobileIntcode);
                bMobile.setLoccode(businessMobileLoccode);
                bMobile.setNum(new Integer(0));
                bMobile.setNumber(businessMobileNumber);
                bMobile.setTelecomtype(AddressListConstants.TELECOMTYPE_MOBILE);
                bMobile.setUser(user);

                AddressListDaoUtil.getTelecomDao().save(bMobile);

                Telecom bFax = new Telecom();
                bFax.setComment(businessFaxComment);
                bFax.setExt(businessFaxExt);
                bFax.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bFax.setIntcode(businessFaxIntcode);
                bFax.setLoccode(businessFaxLoccode);
                bFax.setNum(new Integer(0));
                bFax.setNumber(businessFaxNumber);
                bFax.setTelecomtype(AddressListConstants.TELECOMTYPE_FAX);
                bFax.setUser(user);

                AddressListDaoUtil.getTelecomDao().save(bFax);

                Telecom bPager = new Telecom();
                bPager.setComment(businessPagerComment);
                bPager.setExt(businessPagerExt);
                bPager.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bPager.setIntcode(businessPagerIntcode);
                bPager.setLoccode(businessPagerLoccode);
                bPager.setNum(new Integer(0));
                bPager.setNumber(businessPagerNumber);
                bPager.setTelecomtype(AddressListConstants.TELECOMTYPE_PAGER);
                bPager.setUser(user);

                AddressListDaoUtil.getTelecomDao().save(bPager);

                Online hEmail1 = new Online();
                hEmail1.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hEmail1.setNum(new Integer(0));
                hEmail1.setOnlinetype(AddressListConstants.ONLINETYPE_EMAIL);
                hEmail1.setUser(user);
                hEmail1.setValue(homeEmail1);

                AddressListDaoUtil.getOnlineDao().save(hEmail1);

                Online hEmail2 = new Online();
                hEmail2.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hEmail2.setNum(new Integer(1));
                hEmail2.setOnlinetype(AddressListConstants.ONLINETYPE_EMAIL);
                hEmail2.setUser(user);
                hEmail2.setValue(homeEmail2);

                AddressListDaoUtil.getOnlineDao().save(hEmail2);

                Online hEmail3 = new Online();
                hEmail3.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hEmail3.setNum(new Integer(2));
                hEmail3.setOnlinetype(AddressListConstants.ONLINETYPE_EMAIL);
                hEmail3.setUser(user);
                hEmail3.setValue(homeEmail3);

                AddressListDaoUtil.getOnlineDao().save(hEmail3);

                Online bEmail1 = new Online();
                bEmail1.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bEmail1.setNum(new Integer(0));
                bEmail1.setOnlinetype(AddressListConstants.ONLINETYPE_EMAIL);
                bEmail1.setUser(user);
                bEmail1.setValue(businessEmail1);

                AddressListDaoUtil.getOnlineDao().save(bEmail1);

                Online bEmail2 = new Online();
                bEmail2.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bEmail2.setNum(new Integer(1));
                bEmail2.setOnlinetype(AddressListConstants.ONLINETYPE_EMAIL);
                bEmail2.setUser(user);
                bEmail2.setValue(businessEmail2);

                AddressListDaoUtil.getOnlineDao().save(bEmail2);

                Online bEmail3 = new Online();
                bEmail3.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bEmail3.setNum(new Integer(2));
                bEmail3.setOnlinetype(AddressListConstants.ONLINETYPE_EMAIL);
                bEmail3.setUser(user);
                bEmail3.setValue(businessEmail3);

                AddressListDaoUtil.getOnlineDao().save(bEmail3);

                Online hUrl1 = new Online();
                hUrl1.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hUrl1.setNum(new Integer(0));
                hUrl1.setOnlinetype(AddressListConstants.ONLINETYPE_URL);
                hUrl1.setUser(user);
                hUrl1.setValue(homeUrl1);

                AddressListDaoUtil.getOnlineDao().save(hUrl1);

                Online hUrl2 = new Online();
                hUrl2.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hUrl2.setNum(new Integer(1));
                hUrl2.setOnlinetype(AddressListConstants.ONLINETYPE_URL);
                hUrl2.setUser(user);
                hUrl2.setValue(homeUrl2);

                AddressListDaoUtil.getOnlineDao().save(hUrl2);

                Online hUrl3 = new Online();
                hUrl3.setInfotype(AddressListConstants.INFOTYPE_HOME);
                hUrl3.setNum(new Integer(2));
                hUrl3.setOnlinetype(AddressListConstants.ONLINETYPE_URL);
                hUrl3.setUser(user);
                hUrl3.setValue(homeUrl3);

                AddressListDaoUtil.getOnlineDao().save(hUrl3);

                Online bUrl1 = new Online();
                bUrl1.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bUrl1.setNum(new Integer(0));
                bUrl1.setOnlinetype(AddressListConstants.ONLINETYPE_URL);
                bUrl1.setUser(user);
                bUrl1.setValue(businessUrl1);

                AddressListDaoUtil.getOnlineDao().save(bUrl1);

                Online bUrl2 = new Online();
                bUrl2.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bUrl2.setNum(new Integer(1));
                bUrl2.setOnlinetype(AddressListConstants.ONLINETYPE_URL);
                bUrl2.setUser(user);
                bUrl2.setValue(businessUrl2);

                AddressListDaoUtil.getOnlineDao().save(bUrl2);

                Online bUrl3 = new Online();
                bUrl3.setInfotype(AddressListConstants.INFOTYPE_BUSINESS);
                bUrl3.setNum(new Integer(2));
                bUrl3.setOnlinetype(AddressListConstants.ONLINETYPE_URL);
                bUrl3.setUser(user);
                bUrl3.setValue(businessUrl3);

                AddressListDaoUtil.getOnlineDao().save(bUrl3);

                Custom c1 = new Custom();
                c1.setInfotype(AddressListConstants.INFOTYPE_CUSTOM);
                c1.setNum(new Integer(0));
                c1.setUser(user);
                c1.setValue(custom1);

                AddressListDaoUtil.getCustomDao().save(c1);

                Custom c2 = new Custom();
                c2.setInfotype(AddressListConstants.INFOTYPE_CUSTOM);
                c2.setNum(new Integer(1));
                c2.setUser(user);
                c2.setValue(custom2);

                AddressListDaoUtil.getCustomDao().save(c2);

                Custom c3 = new Custom();
                c3.setInfotype(AddressListConstants.INFOTYPE_CUSTOM);
                c3.setNum(new Integer(2));
                c3.setUser(user);
                c3.setValue(custom3);

                AddressListDaoUtil.getCustomDao().save(c3);

                Custom c4 = new Custom();
                c4.setInfotype(AddressListConstants.INFOTYPE_CUSTOM);
                c4.setNum(new Integer(3));
                c4.setUser(user);
                c4.setValue(custom4);

                AddressListDaoUtil.getCustomDao().save(c4);

                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                        .getString("addresslistaddpagebean.AddedAddress"));

                if (log.isDebugEnabled())
                {
                    log.debug("save() - end");
                }
                return AddressListConstants.ADDRESSLISTVIEW_VIEW_ID;
            }
            catch (RuntimeException e)
            {
                log.error("save()", e);

                // i18n
                FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                        .getString("addresslistaddpagebean.FailedToAddIt"), e.toString());

                if (log.isDebugEnabled())
                {
                    log.debug("save() - end");
                }
                return AddressListConstants.ADDRESSLISTVIEW_VIEW_ID;
            }
        }
        else
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString("addresslistaddpagebean.FailedToAddIt"), "Invalid User.");

            if (log.isDebugEnabled())
            {
                log.debug("save() - end");
            }
            return AddressListConstants.ADDRESSLISTVIEW_VIEW_ID;

        }
    }

    public String back()
    {
        return AddressListConstants.ADDRESSLISTVIEW_VIEW_ID;
    }

    public SelectItem[] getGenderItems()
    {
        return new SelectItem[] {
                new SelectItem(AddressListConstants.GENDER_NONE, PortletResourceBundleUtil
                        .getString("addresslistaddpagebean.None")),
                new SelectItem(AddressListConstants.GENDER_MALE, PortletResourceBundleUtil
                        .getString("addresslistaddpagebean.Male")),
                new SelectItem(AddressListConstants.GENDER_FEMALE, PortletResourceBundleUtil
                        .getString("addresslistaddpagebean.Female")) };
    }

    /**
     * @return Returns the bdate.
     */
    public Date getBdate()
    {
        return bdate;
    }

    /**
     * @param bdate The bdate to set.
     */
    public void setBdate(Date bdate)
    {
        this.bdate = bdate;
    }

    /**
     * @return Returns the businessCity.
     */
    public String getBusinessCity()
    {
        return businessCity;
    }

    /**
     * @param businessCity The businessCity to set.
     */
    public void setBusinessCity(String businessCity)
    {
        this.businessCity = businessCity;
    }

    /**
     * @return Returns the businessCountry.
     */
    public String getBusinessCountry()
    {
        return businessCountry;
    }

    /**
     * @param businessCountry The businessCountry to set.
     */
    public void setBusinessCountry(String businessCountry)
    {
        this.businessCountry = businessCountry;
    }

    /**
     * @return Returns the businessFaxComment.
     */
    public String getBusinessFaxComment()
    {
        return businessFaxComment;
    }

    /**
     * @param businessFaxComment The businessFaxComment to set.
     */
    public void setBusinessFaxComment(String businessFaxComment)
    {
        this.businessFaxComment = businessFaxComment;
    }

    /**
     * @return Returns the businessFaxExt.
     */
    public String getBusinessFaxExt()
    {
        return businessFaxExt;
    }

    /**
     * @param businessFaxExt The businessFaxExt to set.
     */
    public void setBusinessFaxExt(String businessFaxExt)
    {
        this.businessFaxExt = businessFaxExt;
    }

    /**
     * @return Returns the businessFaxIntcode.
     */
    public String getBusinessFaxIntcode()
    {
        return businessFaxIntcode;
    }

    /**
     * @param businessFaxIntcode The businessFaxIntcode to set.
     */
    public void setBusinessFaxIntcode(String businessFaxIntcode)
    {
        this.businessFaxIntcode = businessFaxIntcode;
    }

    /**
     * @return Returns the businessFaxLoccode.
     */
    public String getBusinessFaxLoccode()
    {
        return businessFaxLoccode;
    }

    /**
     * @param businessFaxLoccode The businessFaxLoccode to set.
     */
    public void setBusinessFaxLoccode(String businessFaxLoccode)
    {
        this.businessFaxLoccode = businessFaxLoccode;
    }

    /**
     * @return Returns the businessFaxNumber.
     */
    public String getBusinessFaxNumber()
    {
        return businessFaxNumber;
    }

    /**
     * @param businessFaxNumber The businessFaxNumber to set.
     */
    public void setBusinessFaxNumber(String businessFaxNumber)
    {
        this.businessFaxNumber = businessFaxNumber;
    }

    /**
     * @return Returns the businessMobileComment.
     */
    public String getBusinessMobileComment()
    {
        return businessMobileComment;
    }

    /**
     * @param businessMobileComment The businessMobileComment to set.
     */
    public void setBusinessMobileComment(String businessMobileComment)
    {
        this.businessMobileComment = businessMobileComment;
    }

    /**
     * @return Returns the businessMobileExt.
     */
    public String getBusinessMobileExt()
    {
        return businessMobileExt;
    }

    /**
     * @param businessMobileExt The businessMobileExt to set.
     */
    public void setBusinessMobileExt(String businessMobileExt)
    {
        this.businessMobileExt = businessMobileExt;
    }

    /**
     * @return Returns the businessMobileIntcode.
     */
    public String getBusinessMobileIntcode()
    {
        return businessMobileIntcode;
    }

    /**
     * @param businessMobileIntcode The businessMobileIntcode to set.
     */
    public void setBusinessMobileIntcode(String businessMobileIntcode)
    {
        this.businessMobileIntcode = businessMobileIntcode;
    }

    /**
     * @return Returns the businessMobileLoccode.
     */
    public String getBusinessMobileLoccode()
    {
        return businessMobileLoccode;
    }

    /**
     * @param businessMobileLoccode The businessMobileLoccode to set.
     */
    public void setBusinessMobileLoccode(String businessMobileLoccode)
    {
        this.businessMobileLoccode = businessMobileLoccode;
    }

    /**
     * @return Returns the businessMobileNumber.
     */
    public String getBusinessMobileNumber()
    {
        return businessMobileNumber;
    }

    /**
     * @param businessMobileNumber The businessMobileNumber to set.
     */
    public void setBusinessMobileNumber(String businessMobileNumber)
    {
        this.businessMobileNumber = businessMobileNumber;
    }

    /**
     * @return Returns the businessName.
     */
    public String getBusinessName()
    {
        return businessName;
    }

    /**
     * @param businessName The businessName to set.
     */
    public void setBusinessName(String businessName)
    {
        this.businessName = businessName;
    }

    /**
     * @return Returns the businessOrganization.
     */
    public String getBusinessOrganization()
    {
        return businessOrganization;
    }

    /**
     * @param businessOrganization The businessOrganization to set.
     */
    public void setBusinessOrganization(String businessOrganization)
    {
        this.businessOrganization = businessOrganization;
    }

    /**
     * @return Returns the businessPagerComment.
     */
    public String getBusinessPagerComment()
    {
        return businessPagerComment;
    }

    /**
     * @param businessPagerComment The businessPagerComment to set.
     */
    public void setBusinessPagerComment(String businessPagerComment)
    {
        this.businessPagerComment = businessPagerComment;
    }

    /**
     * @return Returns the businessPagerExt.
     */
    public String getBusinessPagerExt()
    {
        return businessPagerExt;
    }

    /**
     * @param businessPagerExt The businessPagerExt to set.
     */
    public void setBusinessPagerExt(String businessPagerExt)
    {
        this.businessPagerExt = businessPagerExt;
    }

    /**
     * @return Returns the businessPagerIntcode.
     */
    public String getBusinessPagerIntcode()
    {
        return businessPagerIntcode;
    }

    /**
     * @param businessPagerIntcode The businessPagerIntcode to set.
     */
    public void setBusinessPagerIntcode(String businessPagerIntcode)
    {
        this.businessPagerIntcode = businessPagerIntcode;
    }

    /**
     * @return Returns the businessPagerLoccode.
     */
    public String getBusinessPagerLoccode()
    {
        return businessPagerLoccode;
    }

    /**
     * @param businessPagerLoccode The businessPagerLoccode to set.
     */
    public void setBusinessPagerLoccode(String businessPagerLoccode)
    {
        this.businessPagerLoccode = businessPagerLoccode;
    }

    /**
     * @return Returns the businessPagerNumber.
     */
    public String getBusinessPagerNumber()
    {
        return businessPagerNumber;
    }

    /**
     * @param businessPagerNumber The businessPagerNumber to set.
     */
    public void setBusinessPagerNumber(String businessPagerNumber)
    {
        this.businessPagerNumber = businessPagerNumber;
    }

    /**
     * @return Returns the businessPostalcode.
     */
    public String getBusinessPostalcode()
    {
        return businessPostalcode;
    }

    /**
     * @param businessPostalcode The businessPostalcode to set.
     */
    public void setBusinessPostalcode(String businessPostalcode)
    {
        this.businessPostalcode = businessPostalcode;
    }

    /**
     * @return Returns the businessStateprov.
     */
    public String getBusinessStateprov()
    {
        return businessStateprov;
    }

    /**
     * @param businessStateprov The businessStateprov to set.
     */
    public void setBusinessStateprov(String businessStateprov)
    {
        this.businessStateprov = businessStateprov;
    }

    /**
     * @return Returns the businessTelephoneComment.
     */
    public String getBusinessTelephoneComment()
    {
        return businessTelephoneComment;
    }

    /**
     * @param businessTelephoneComment The businessTelephoneComment to set.
     */
    public void setBusinessTelephoneComment(String businessTelephoneComment)
    {
        this.businessTelephoneComment = businessTelephoneComment;
    }

    /**
     * @return Returns the businessTelephoneExt.
     */
    public String getBusinessTelephoneExt()
    {
        return businessTelephoneExt;
    }

    /**
     * @param businessTelephoneExt The businessTelephoneExt to set.
     */
    public void setBusinessTelephoneExt(String businessTelephoneExt)
    {
        this.businessTelephoneExt = businessTelephoneExt;
    }

    /**
     * @return Returns the businessTelephoneIntcode.
     */
    public String getBusinessTelephoneIntcode()
    {
        return businessTelephoneIntcode;
    }

    /**
     * @param businessTelephoneIntcode The businessTelephoneIntcode to set.
     */
    public void setBusinessTelephoneIntcode(String businessTelephoneIntcode)
    {
        this.businessTelephoneIntcode = businessTelephoneIntcode;
    }

    /**
     * @return Returns the businessTelephoneLoccode.
     */
    public String getBusinessTelephoneLoccode()
    {
        return businessTelephoneLoccode;
    }

    /**
     * @param businessTelephoneLoccode The businessTelephoneLoccode to set.
     */
    public void setBusinessTelephoneLoccode(String businessTelephoneLoccode)
    {
        this.businessTelephoneLoccode = businessTelephoneLoccode;
    }

    /**
     * @return Returns the businessTelephoneNumber.
     */
    public String getBusinessTelephoneNumber()
    {
        return businessTelephoneNumber;
    }

    /**
     * @param businessTelephoneNumber The businessTelephoneNumber to set.
     */
    public void setBusinessTelephoneNumber(String businessTelephoneNumber)
    {
        this.businessTelephoneNumber = businessTelephoneNumber;
    }

    /**
     * @return Returns the custom1.
     */
    public String getCustom1()
    {
        return custom1;
    }

    /**
     * @param custom1 The custom1 to set.
     */
    public void setCustom1(String custom1)
    {
        this.custom1 = custom1;
    }

    /**
     * @return Returns the custom2.
     */
    public String getCustom2()
    {
        return custom2;
    }

    /**
     * @param custom2 The custom2 to set.
     */
    public void setCustom2(String custom2)
    {
        this.custom2 = custom2;
    }

    /**
     * @return Returns the custom3.
     */
    public String getCustom3()
    {
        return custom3;
    }

    /**
     * @param custom3 The custom3 to set.
     */
    public void setCustom3(String custom3)
    {
        this.custom3 = custom3;
    }

    /**
     * @return Returns the custom4.
     */
    public String getCustom4()
    {
        return custom4;
    }

    /**
     * @param custom4 The custom4 to set.
     */
    public void setCustom4(String custom4)
    {
        this.custom4 = custom4;
    }

    /**
     * @return Returns the department.
     */
    public String getDepartment()
    {
        return department;
    }

    /**
     * @param department The department to set.
     */
    public void setDepartment(String department)
    {
        this.department = department;
    }

    /**
     * @return Returns the homeEmail1.
     */
    public String getHomeEmail1()
    {
        return homeEmail1;
    }

    /**
     * @param homeEmail1 The homeEmail1 to set.
     */
    public void setHomeEmail1(String email)
    {
        this.homeEmail1 = email;
    }

    /**
     * @return Returns the employer.
     */
    public String getEmployer()
    {
        return employer;
    }

    /**
     * @param employer The employer to set.
     */
    public void setEmployer(String employer)
    {
        this.employer = employer;
    }

    /**
     * @return Returns the familyname.
     */
    public String getFamilyname()
    {
        return familyname;
    }

    /**
     * @param familyname The familyname to set.
     */
    public void setFamilyname(String familyname)
    {
        this.familyname = familyname;
    }

    /**
     * @return Returns the gender.
     */
    public String getGender()
    {
        return gender;
    }

    /**
     * @param gender The gender to set.
     */
    public void setGender(String gender)
    {
        this.gender = gender;
    }

    /**
     * @return Returns the givenname.
     */
    public String getGivenname()
    {
        return givenname;
    }

    /**
     * @param givenname The givenname to set.
     */
    public void setGivenname(String givenname)
    {
        this.givenname = givenname;
    }

    /**
     * @return Returns the homeCity.
     */
    public String getHomeCity()
    {
        return homeCity;
    }

    /**
     * @param homeCity The homeCity to set.
     */
    public void setHomeCity(String homeCity)
    {
        this.homeCity = homeCity;
    }

    /**
     * @return Returns the homeCountry.
     */
    public String getHomeCountry()
    {
        return homeCountry;
    }

    /**
     * @param homeCountry The homeCountry to set.
     */
    public void setHomeCountry(String homeCountry)
    {
        this.homeCountry = homeCountry;
    }

    /**
     * @return Returns the homeFaxComment.
     */
    public String getHomeFaxComment()
    {
        return homeFaxComment;
    }

    /**
     * @param homeFaxComment The homeFaxComment to set.
     */
    public void setHomeFaxComment(String homeFaxComment)
    {
        this.homeFaxComment = homeFaxComment;
    }

    /**
     * @return Returns the homeFaxExt.
     */
    public String getHomeFaxExt()
    {
        return homeFaxExt;
    }

    /**
     * @param homeFaxExt The homeFaxExt to set.
     */
    public void setHomeFaxExt(String homeFaxExt)
    {
        this.homeFaxExt = homeFaxExt;
    }

    /**
     * @return Returns the homeFaxIntcode.
     */
    public String getHomeFaxIntcode()
    {
        return homeFaxIntcode;
    }

    /**
     * @param homeFaxIntcode The homeFaxIntcode to set.
     */
    public void setHomeFaxIntcode(String homeFaxIntcode)
    {
        this.homeFaxIntcode = homeFaxIntcode;
    }

    /**
     * @return Returns the homeFaxLoccode.
     */
    public String getHomeFaxLoccode()
    {
        return homeFaxLoccode;
    }

    /**
     * @param homeFaxLoccode The homeFaxLoccode to set.
     */
    public void setHomeFaxLoccode(String homeFaxLoccode)
    {
        this.homeFaxLoccode = homeFaxLoccode;
    }

    /**
     * @return Returns the homeFaxNumber.
     */
    public String getHomeFaxNumber()
    {
        return homeFaxNumber;
    }

    /**
     * @param homeFaxNumber The homeFaxNumber to set.
     */
    public void setHomeFaxNumber(String homeFaxNumber)
    {
        this.homeFaxNumber = homeFaxNumber;
    }

    /**
     * @return Returns the homeMobileComment.
     */
    public String getHomeMobileComment()
    {
        return homeMobileComment;
    }

    /**
     * @param homeMobileComment The homeMobileComment to set.
     */
    public void setHomeMobileComment(String homeMobileComment)
    {
        this.homeMobileComment = homeMobileComment;
    }

    /**
     * @return Returns the homeMobileExt.
     */
    public String getHomeMobileExt()
    {
        return homeMobileExt;
    }

    /**
     * @param homeMobileExt The homeMobileExt to set.
     */
    public void setHomeMobileExt(String homeMobileExt)
    {
        this.homeMobileExt = homeMobileExt;
    }

    /**
     * @return Returns the homeMobileIntcode.
     */
    public String getHomeMobileIntcode()
    {
        return homeMobileIntcode;
    }

    /**
     * @param homeMobileIntcode The homeMobileIntcode to set.
     */
    public void setHomeMobileIntcode(String homeMobileIntcode)
    {
        this.homeMobileIntcode = homeMobileIntcode;
    }

    /**
     * @return Returns the homeMobileLoccode.
     */
    public String getHomeMobileLoccode()
    {
        return homeMobileLoccode;
    }

    /**
     * @param homeMobileLoccode The homeMobileLoccode to set.
     */
    public void setHomeMobileLoccode(String homeMobileLoccode)
    {
        this.homeMobileLoccode = homeMobileLoccode;
    }

    /**
     * @return Returns the homeMobileNumber.
     */
    public String getHomeMobileNumber()
    {
        return homeMobileNumber;
    }

    /**
     * @param homeMobileNumber The homeMobileNumber to set.
     */
    public void setHomeMobileNumber(String homeMobileNumber)
    {
        this.homeMobileNumber = homeMobileNumber;
    }

    /**
     * @return Returns the homeName.
     */
    public String getHomeName()
    {
        return homeName;
    }

    /**
     * @param homeName The homeName to set.
     */
    public void setHomeName(String homeName)
    {
        this.homeName = homeName;
    }

    /**
     * @return Returns the homeOrganization.
     */
    public String getHomeOrganization()
    {
        return homeOrganization;
    }

    /**
     * @param homeOrganization The homeOrganization to set.
     */
    public void setHomeOrganization(String homeOrganization)
    {
        this.homeOrganization = homeOrganization;
    }

    /**
     * @return Returns the homePagerComment.
     */
    public String getHomePagerComment()
    {
        return homePagerComment;
    }

    /**
     * @param homePagerComment The homePagerComment to set.
     */
    public void setHomePagerComment(String homePagerComment)
    {
        this.homePagerComment = homePagerComment;
    }

    /**
     * @return Returns the homePagerExt.
     */
    public String getHomePagerExt()
    {
        return homePagerExt;
    }

    /**
     * @param homePagerExt The homePagerExt to set.
     */
    public void setHomePagerExt(String homePagerExt)
    {
        this.homePagerExt = homePagerExt;
    }

    /**
     * @return Returns the homePagerIntcode.
     */
    public String getHomePagerIntcode()
    {
        return homePagerIntcode;
    }

    /**
     * @param homePagerIntcode The homePagerIntcode to set.
     */
    public void setHomePagerIntcode(String homePagerIntcode)
    {
        this.homePagerIntcode = homePagerIntcode;
    }

    /**
     * @return Returns the homePagerLoccode.
     */
    public String getHomePagerLoccode()
    {
        return homePagerLoccode;
    }

    /**
     * @param homePagerLoccode The homePagerLoccode to set.
     */
    public void setHomePagerLoccode(String homePagerLoccode)
    {
        this.homePagerLoccode = homePagerLoccode;
    }

    /**
     * @return Returns the homePagerNumber.
     */
    public String getHomePagerNumber()
    {
        return homePagerNumber;
    }

    /**
     * @param homePagerNumber The homePagerNumber to set.
     */
    public void setHomePagerNumber(String homePagerNumber)
    {
        this.homePagerNumber = homePagerNumber;
    }

    /**
     * @return Returns the homePostalcode.
     */
    public String getHomePostalcode()
    {
        return homePostalcode;
    }

    /**
     * @param homePostalcode The homePostalcode to set.
     */
    public void setHomePostalcode(String homePostalcode)
    {
        this.homePostalcode = homePostalcode;
    }

    /**
     * @return Returns the homeStateprov.
     */
    public String getHomeStateprov()
    {
        return homeStateprov;
    }

    /**
     * @param homeStateprov The homeStateprov to set.
     */
    public void setHomeStateprov(String homeStateprov)
    {
        this.homeStateprov = homeStateprov;
    }

    /**
     * @return Returns the homeTelephoneComment.
     */
    public String getHomeTelephoneComment()
    {
        return homeTelephoneComment;
    }

    /**
     * @param homeTelephoneComment The homeTelephoneComment to set.
     */
    public void setHomeTelephoneComment(String homeTelephoneComment)
    {
        this.homeTelephoneComment = homeTelephoneComment;
    }

    /**
     * @return Returns the homeTelephoneExt.
     */
    public String getHomeTelephoneExt()
    {
        return homeTelephoneExt;
    }

    /**
     * @param homeTelephoneExt The homeTelephoneExt to set.
     */
    public void setHomeTelephoneExt(String homeTelephoneExt)
    {
        this.homeTelephoneExt = homeTelephoneExt;
    }

    /**
     * @return Returns the homeTelephoneIntcode.
     */
    public String getHomeTelephoneIntcode()
    {
        return homeTelephoneIntcode;
    }

    /**
     * @param homeTelephoneIntcode The homeTelephoneIntcode to set.
     */
    public void setHomeTelephoneIntcode(String homeTelephoneIntcode)
    {
        this.homeTelephoneIntcode = homeTelephoneIntcode;
    }

    /**
     * @return Returns the homeTelephoneLoccode.
     */
    public String getHomeTelephoneLoccode()
    {
        return homeTelephoneLoccode;
    }

    /**
     * @param homeTelephoneLoccode The homeTelephoneLoccode to set.
     */
    public void setHomeTelephoneLoccode(String homeTelephoneLoccode)
    {
        this.homeTelephoneLoccode = homeTelephoneLoccode;
    }

    /**
     * @return Returns the homeTelephoneNumber.
     */
    public String getHomeTelephoneNumber()
    {
        return homeTelephoneNumber;
    }

    /**
     * @param homeTelephoneNumber The homeTelephoneNumber to set.
     */
    public void setHomeTelephoneNumber(String homeTelephoneNumber)
    {
        this.homeTelephoneNumber = homeTelephoneNumber;
    }

    /**
     * @return Returns the jobtitle.
     */
    public String getJobtitle()
    {
        return jobtitle;
    }

    /**
     * @param jobtitle The jobtitle to set.
     */
    public void setJobtitle(String jobtitle)
    {
        this.jobtitle = jobtitle;
    }

    /**
     * @return Returns the middlename.
     */
    public String getMiddlename()
    {
        return middlename;
    }

    /**
     * @param middlename The middlename to set.
     */
    public void setMiddlename(String middlename)
    {
        this.middlename = middlename;
    }

    /**
     * @return Returns the nameprefix.
     */
    public String getNameprefix()
    {
        return nameprefix;
    }

    /**
     * @param nameprefix The nameprefix to set.
     */
    public void setNameprefix(String nameprefix)
    {
        this.nameprefix = nameprefix;
    }

    /**
     * @return Returns the namesuffix.
     */
    public String getNamesuffix()
    {
        return namesuffix;
    }

    /**
     * @param namesuffix The namesuffix to set.
     */
    public void setNamesuffix(String namesuffix)
    {
        this.namesuffix = namesuffix;
    }

    /**
     * @return Returns the nickname.
     */
    public String getNickname()
    {
        return nickname;
    }

    /**
     * @param nickname The nickname to set.
     */
    public void setNickname(String nickname)
    {
        this.nickname = nickname;
    }

    /**
     * @return Returns the homeUrl1.
     */
    public String getHomeUrl1()
    {
        return homeUrl1;
    }

    /**
     * @param homeUrl1 The homeUrl1 to set.
     */
    public void setHomeUrl1(String url)
    {
        this.homeUrl1 = url;
    }

    /**
     * @return Returns the businessStreet.
     */
    public String getBusinessStreet()
    {
        return businessStreet;
    }

    /**
     * @param businessStreet The businessStreet to set.
     */
    public void setBusinessStreet(String businessStreet)
    {
        this.businessStreet = businessStreet;
    }

    /**
     * @return Returns the homeStreet.
     */
    public String getHomeStreet()
    {
        return homeStreet;
    }

    /**
     * @param homeStreet The homeStreet to set.
     */
    public void setHomeStreet(String homeStreet)
    {
        this.homeStreet = homeStreet;
    }

    /**
     * @return Returns the businessEmail1.
     */
    public String getBusinessEmail1()
    {
        return businessEmail1;
    }

    /**
     * @param businessEmail1 The businessEmail1 to set.
     */
    public void setBusinessEmail1(String businessEmail1)
    {
        this.businessEmail1 = businessEmail1;
    }

    /**
     * @return Returns the businessEmail2.
     */
    public String getBusinessEmail2()
    {
        return businessEmail2;
    }

    /**
     * @param businessEmail2 The businessEmail2 to set.
     */
    public void setBusinessEmail2(String businessEmail2)
    {
        this.businessEmail2 = businessEmail2;
    }

    /**
     * @return Returns the businessEmail3.
     */
    public String getBusinessEmail3()
    {
        return businessEmail3;
    }

    /**
     * @param businessEmail3 The businessEmail3 to set.
     */
    public void setBusinessEmail3(String businessEmail3)
    {
        this.businessEmail3 = businessEmail3;
    }

    /**
     * @return Returns the businessUrl1.
     */
    public String getBusinessUrl1()
    {
        return businessUrl1;
    }

    /**
     * @param businessUrl1 The businessUrl1 to set.
     */
    public void setBusinessUrl1(String businessUrl1)
    {
        this.businessUrl1 = businessUrl1;
    }

    /**
     * @return Returns the businessUrl2.
     */
    public String getBusinessUrl2()
    {
        return businessUrl2;
    }

    /**
     * @param businessUrl2 The businessUrl2 to set.
     */
    public void setBusinessUrl2(String businessUrl2)
    {
        this.businessUrl2 = businessUrl2;
    }

    /**
     * @return Returns the businessUrl3.
     */
    public String getBusinessUrl3()
    {
        return businessUrl3;
    }

    /**
     * @param businessUrl3 The businessUrl3 to set.
     */
    public void setBusinessUrl3(String businessUrl3)
    {
        this.businessUrl3 = businessUrl3;
    }

    /**
     * @return Returns the homeEmail2.
     */
    public String getHomeEmail2()
    {
        return homeEmail2;
    }

    /**
     * @param homeEmail2 The homeEmail2 to set.
     */
    public void setHomeEmail2(String homeEmail2)
    {
        this.homeEmail2 = homeEmail2;
    }

    /**
     * @return Returns the homeEmail3.
     */
    public String getHomeEmail3()
    {
        return homeEmail3;
    }

    /**
     * @param homeEmail3 The homeEmail3 to set.
     */
    public void setHomeEmail3(String homeEmail3)
    {
        this.homeEmail3 = homeEmail3;
    }

    /**
     * @return Returns the homeUrl2.
     */
    public String getHomeUrl2()
    {
        return homeUrl2;
    }

    /**
     * @param homeUrl2 The homeUrl2 to set.
     */
    public void setHomeUrl2(String homeUrl2)
    {
        this.homeUrl2 = homeUrl2;
    }

    /**
     * @return Returns the homeUrl3.
     */
    public String getHomeUrl3()
    {
        return homeUrl3;
    }

    /**
     * @param homeUrl3 The homeUrl3 to set.
     */
    public void setHomeUrl3(String homeUrl3)
    {
        this.homeUrl3 = homeUrl3;
    }

}
