/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.bean;

import java.io.IOException;

import jp.sf.pal.addresslist.AddressListConstants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.portlet.faces.PortletPreferencesUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;

public class AddressListViewEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(AddressListViewEditPageBean.class);

    private Integer pageSize;

    private AddressListSessionBean addressListSession;

    public String save()
    {
        try
        {
            getAddressListSession().setPageSize(pageSize);

            PortletPreferencesUtil.store();

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("addresslistviewedit.UpdatedParameters"));
        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString("addresslistviewedit.SystemErrorOccurs"), e
                    .toString());
            log.error(e);
        }
        return null;
    }

    public String reset()
    {
        try
        {
            getAddressListSession().setPageSize(new Integer(AddressListConstants.DEFAULT_PAGE_SIZE));

            PortletPreferencesUtil.store();

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("addresslistviewedit.UpdatedToDefaultParameters"));
        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString("addresslistviewedit.SystemErrorOccurs"), e
                    .toString());
            log.error(e);
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        //        return pageSize;
        return addressListSession.getPageSize();
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer number)
    {
        this.pageSize = number;
    }

    /**
     * @return Returns the todoListViewSession.
     */
    public AddressListSessionBean getAddressListSession()
    {
        return addressListSession;
    }

    /**
     * @param todoListViewSession The todoListViewSession to set.
     */
    public void setAddressListSession(AddressListSessionBean addressListSessionBean)
    {
        this.addressListSession = addressListSessionBean;
    }

}
