<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
	<f:loadBundle
		basename="jp.sf.pal.addresslist.resources.AddressListResources"
		var="msgs" />
		
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid border="0" columns="2">

			<h:outputLabel for="number">
				<h:outputText
					value="#{msgs['addresslistviewedit.TheNumberOfAddressItem']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="number" value="#{addressListViewEditPage.pageSize}"
				size="30" styleClass="portlet-form-field-label"
				converter="javax.faces.Integer" required="true">
				<f:validateLongRange minimum="1" />
			</h:inputText>

			<h:commandButton action="#{addressListViewEditPage.save}"
				value="#{msgs['addresslistviewedit.Save']}"
				styleClass="portlet-form-button" />
			<h:commandButton action="#{addressListViewEditPage.reset}"
				value="#{msgs['addresslistviewedit.Reset']}"
				styleClass="portlet-form-button" />
		</h:panelGrid>
	</h:form>
</f:view>
