/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.notepad.bean;

import java.util.Calendar;

import javax.faces.context.FacesContext;

import jp.sf.pal.notepad.NotepadConstants;
import jp.sf.pal.notepad.NotepadRuntimeException;
import jp.sf.pal.notepad.model.Category;
import jp.sf.pal.notepad.util.NotepadDaoUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;

public class CategoryEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(CategoryEditPageBean.class);

    private NotepadSessionBean notepadSession;

    private String name;

    private String description;

    private Long id;

    public String update()
    {
        if (id != null)
        {
            try
            {
                Category cat = null;
                boolean update = false;
                if (id.longValue() == -1)
                {
                    cat = new Category();
                    cat.setCreatedtime(Calendar.getInstance().getTime());
                    String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
                    if (username == null)
                    {
                        username = NotepadConstants.GUEST_USER;
                    }
                    cat.setOwner(username);
                    cat.setScope(getNotepadSession().getScope());
                }
                else
                {
                    cat = NotepadDaoUtil.getCategoryDao().getCategoryById(id.longValue());
                    update = true;
                }
                cat.setDescription(getDescription());
                cat.setName(getName());

                NotepadDaoUtil.getCategoryDao().saveOrUpdate(cat);

                if (update)
                {
                    // i18n
                    FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("categoryedit.UpdatedTheCategory"));
                }
                else
                {
                    // i18n
                    FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("categoryedit.CreatedTheCategory"));
                }
            }
            catch (NotepadRuntimeException e)
            {
                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("categoryedit.FailedToUpdateTheCategory"), e.toString());
                log.error("Failed to update the category.", e);
            }
            catch (RuntimeException e)
            {
                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("categoryedit.FailedToUpdateTheCategory"), e.toString());
                log.error("Failed to update the category.", e);
            }

            return NotepadConstants.CATEGORY_VIEW_VIEW_ID;
        }
        else
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString("categoryedit.TheSpecifiedItemIsNull"));

            return NotepadConstants.CATEGORY_VIEW_VIEW_ID;
        }
    }

    public String delete()
    {

        if (id != null)
        {
            try
            {
                Category category = NotepadDaoUtil.getCategoryDao().getCategoryById(id.longValue());
                NotepadDaoUtil.getCategoryDao().delete(category);

                getNotepadSession().setCategoryId(new Long(-1));

                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("categoryedit.DeletedTheCategory"));
            }
            catch (NotepadRuntimeException e)
            {
                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("categoryedit.FailedToDeleteTheCategory"), e.toString());
                log.error("Failed to delete the category.", e);
            }
            catch (RuntimeException e)
            {
                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("categoryedit.FailedToDeleteTheCategory"), e.toString());
                log.error("Failed to delete the category.", e);
            }

            return NotepadConstants.CATEGORY_VIEW_VIEW_ID;
        }
        else
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString("categoryedit.TheSpecifiedItemIsNull"));

            return NotepadConstants.CATEGORY_VIEW_VIEW_ID;
        }
    }

    public String back()
    {
        return NotepadConstants.CATEGORY_VIEW_VIEW_ID;
    }

    /**
     * @return Returns the description.
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @param description The description to set.
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * @return Returns the name.
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name The name to set.
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return Returns the notepadSession.
     */
    public NotepadSessionBean getNotepadSession()
    {
        return notepadSession;
    }

    /**
     * @param notepadSession The notepadSession to set.
     */
    public void setNotepadSession(NotepadSessionBean notepadSession)
    {
        this.notepadSession = notepadSession;
        if (notepadSession != null)
        {
            Category cat = notepadSession.getCategory();
            if (cat != null)
            {
                setId(new Long(cat.getId()));
                setName(cat.getName());
                setDescription(cat.getDescription());
            }
            else
            {
                setId(new Long(-1));
                setName("");
                setDescription("");
            }
        }
    }

    /**
     * @return Returns the id.
     */
    public Long getId()
    {
        return id;
    }

    /**
     * @param id The id to set.
     */
    public void setId(Long id)
    {
        this.id = id;
    }
}
