/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.notepad.bean;

import java.io.IOException;

import jp.sf.pal.notepad.NotepadConstants;
import jp.sf.pal.notepad.model.Category;
import jp.sf.pal.notepad.model.Note;
import jp.sf.pal.notepad.util.NotepadDaoUtil;

import com.marevol.utils.portlet.faces.PortletConfigUtil;
import com.marevol.utils.portlet.faces.PortletPreferencesUtil;

public class NotepadSessionBean
{
    private Long categoryId;

    private String scope;

    private Long noteId;

    public NotepadSessionBean()
    {
        scope = PortletConfigUtil.getInitParameter(NotepadConstants.SCOPE_INIT_PARAMETER);
        if (scope == null)
        {
            scope = NotepadConstants.DEFAULT_SCOPE;
        }

        categoryId = new Long(-1);
    }

    public Note getNote()
    {
        if (noteId != null)
        {
            return NotepadDaoUtil.getNoteDao().getNoteById(noteId.longValue());
        }
        return null;
    }

    public void setNote(Note note)
    {
        if (note != null)
        {
            noteId = new Long(note.getId());
        }
        else
        {
            noteId = null;
        }
    }

    /**
     * @return Returns the categoryId.
     */
    public Long getCategoryId()
    {
        return categoryId;
    }

    /**
     * @param categoryId The categoryId to set.
     */
    public void setCategory(Category category)
    {
        if (category == null)
        {
            this.categoryId = new Long(-1);
        }
        else
        {
            this.categoryId = new Long(category.getId());
        }
    }

    /**
     * @return Returns the categoryId.
     */
    public Category getCategory()
    {
        if (categoryId.longValue() == -1)
        {
            return null;
        }
        return NotepadDaoUtil.getCategoryDao().getCategoryById(categoryId.longValue());
    }

    /**
     * @param categoryId The categoryId to set.
     */
    public void setCategoryId(Long categoryId)
    {
        this.categoryId = categoryId;
        if (this.categoryId == null)
        {
            this.categoryId = new Long(-1);
        }
    }

    /**
     * @return Returns the scope.
     */
    public String getScope()
    {
        return scope;
    }

    /**
     * @param scope The scope to set.
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    }

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {

        return new Integer(PortletPreferencesUtil.getValue(NotepadConstants.VIEW_PAGE_SIZE, Integer
                .toString(NotepadConstants.DEFAULT_PAGE_SIZE)));
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer maxResults) throws IOException
    {

        PortletPreferencesUtil.setValue(NotepadConstants.VIEW_PAGE_SIZE, maxResults.toString());
    }

}
