/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model.hatena;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Calendar;
import java.util.Date;

public class Comment
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(Comment.class);

    private String username;

    private String body;

    private String timestamp;

    /**
     * @return Returns the body.
     */
    public String getBody()
    {
        return body;
    }

    /**
     * @param body The body to set.
     */
    public void setBody(String body)
    {
        this.body = body;
    }

    /**
     * @return Returns the timestamp.
     */
    public String getTimestamp()
    {
        return timestamp;
    }

    /**
     * @param timestamp The timestamp to set.
     */
    public void setTimestamp(String timestamp)
    {
        this.timestamp = timestamp;
    }

    /**
     * @return Returns the username.
     */
    public String getUsername()
    {
        return username;
    }

    /**
     * @param username The username to set.
     */
    public void setUsername(String username)
    {
        this.username = username;
    }

    public Date getTime()
    {
        try
        {
            return new Date(Long.parseLong(getTimestamp()));
        }
        catch (NumberFormatException e)
        {
            log.error("Invalid format: " + getTimestamp(), e);
            return Calendar.getInstance().getTime();
        }
    }
}
