/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model.hatena;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.util.DateUtil;

public class Day
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(Day.class);

    private String date;

    private String title;

    private String body;

    private List comments = new ArrayList();

    /**
     * @return Returns the body.
     */
    public String getBody()
    {
        return body;
    }

    /**
     * @param body The body to set.
     */
    public void setBody(String body)
    {
        this.body = body;
    }

    /**
     * @return Returns the comments.
     */
    public List getComments()
    {
        return comments;
    }

    /**
     * @param comments The comments to set.
     */
    public void setComments(List comments)
    {
        this.comments = comments;
    }

    /**
     * @param comments The comments to set.
     */
    public void addComment(Comment comment)
    {
        comments.add(comment);
    }

    /**
     * @return Returns the date.
     */
    public String getDate()
    {
        return date;
    }

    /**
     * @param date The date to set.
     */
    public void setDate(String date)
    {
        this.date = date;
    }

    /**
     * @return Returns the title.
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * @param title The title to set.
     */
    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * @return Returns the date.
     */
    public Date getTime()
    {
        StringTokenizer st = new StringTokenizer(date, "-");
        int year = 1970;
        int month = 0;
        int d = 1;
        if (st.hasMoreTokens())
        {
            try
            {
                year = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e)
            {
                log.error("Invalid format: " + date, e);
                return Calendar.getInstance().getTime();
            }
        }
        if (st.hasMoreTokens())
        {
            try
            {
                month = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e)
            {
                log.error("Invalid format: " + date, e);
                return Calendar.getInstance().getTime();
            }
        }
        if (st.hasMoreTokens())
        {
            try
            {
                d = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e)
            {
                log.error("Invalid format: " + date, e);
                return Calendar.getInstance().getTime();
            }
        }
        return DateUtil.get(year - 1900, month - 1, d, 0, 0, 0, 0);
    }

}
