/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.jsfhelloworld.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.util.LocaleUtil;

import jp.sf.pal.jsfhelloworld.JSFHellloWorldConstants;

public class InputNamePageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(InputNamePageBean.class);

    private JSFHelloWorldSessionBean jsfHelloWorldSession;

    public String input()
    {
        if (log.isDebugEnabled())
        {
            log.debug("input() - jsfHelloWorldSession.getName()="
                    + jsfHelloWorldSession.getName());
        }

        if (jsfHelloWorldSession.getName() != null
                && !jsfHelloWorldSession.getName().equals(""))
        {
            return JSFHellloWorldConstants.NAVI_TO_SAYHELLO;
        }

        FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString(
                LocaleUtil.getLocale(), "InputNamePageBean.value_is_null"));
        return null;
    }

    /**
     * @return Returns the jsfHelloWorldSession.
     */
    public JSFHelloWorldSessionBean getJsfHelloWorldSession()
    {
        return jsfHelloWorldSession;
    }

    /**
     * @param jsfHelloWorldSession The jsfHelloWorldSession to set.
     */
    public void setJsfHelloWorldSession(
            JSFHelloWorldSessionBean jsfHelloWorldSession)
    {
        this.jsfHelloWorldSession = jsfHelloWorldSession;
    }
}
